/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzYwX;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzFw;
import com.aspose.words.net.System.Data.zzWdb;
import com.aspose.words.net.System.Data.zzWlq;
import com.aspose.words.net.System.Data.zzZCJ;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zz9x;
    private final DataColumnCollection zzaJ;
    private final ConstraintCollection zzXGu;
    private final zzFw zzYAc;
    private ResultSet zzXAv;
    private String zzdP;
    private DataSet zzXle;
    private String zzVx;
    private UniqueConstraint zzYKu;
    private boolean zzgy;
    private final List<DataTableEventListener> zzWkw;
    private final Set<DataRow> zzYDo;
    private DataRelationCollection zzvh;

    public DataTable() {
        this.zz9x = new DataRowCollection(this);
        this.zzaJ = new DataColumnCollection(this);
        this.zzXGu = new ConstraintCollection(this);
        this.zzYAc = new zzFw(this);
        this.zzVx = "";
        this.zzgy = true;
        this.zzWkw = new ArrayList<DataTableEventListener>();
        this.zzYDo = new HashSet<DataRow>();
        this.zzvh = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zz9x = new DataRowCollection(this);
        this.zzaJ = new DataColumnCollection(this);
        this.zzXGu = new ConstraintCollection(this);
        this.zzYAc = new zzFw(this);
        this.zzVx = "";
        this.zzgy = true;
        this.zzWkw = new ArrayList<DataTableEventListener>();
        this.zzYDo = new HashSet<DataRow>();
        this.zzvh = new DataRelationCollection();
        this.zzdP = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzWdb.zzFH(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zz9x = new DataRowCollection(this);
        this.zzaJ = new DataColumnCollection(this);
        this.zzXGu = new ConstraintCollection(this);
        this.zzYAc = new zzFw(this);
        this.zzVx = "";
        this.zzgy = true;
        this.zzWkw = new ArrayList<DataTableEventListener>();
        this.zzYDo = new HashSet<DataRow>();
        this.zzvh = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzXAv = resultSet;
        this.zzdP = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzXAv != null) {
            if (this.zzXAv.getStatement() != null) {
                this.zzXAv.getStatement().getConnection().close();
            }
            this.zzXAv = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzdP;
    }

    public void setTableName(String tableName) {
        this.zzdP = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzaJ.getCount();
    }

    public String getColumnName(int index) {
        return this.zzaJ.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzXAv;
    }

    public DataSet getDataSet() {
        return this.zzXle;
    }

    final void zzWO6(DataSet dataSet) {
        this.zzXle = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzXle.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzvh.add(dataRelation);
        }
        return this.zzvh;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzXle.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zz9x;
    }

    public DataColumnCollection getColumns() {
        return this.zzaJ;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzXGu;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzYKu == null) {
            return new DataColumn[0];
        }
        return this.zzYKu.getColumns();
    }

    final void zzFw(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzYKu != null) {
                this.zzYKu.zzEA(false);
                this.getConstraints().remove(this.zzYKu);
                this.zzYKu = null;
            }
            return;
        }
        if (this.zzYKu != null && DataColumn.areColumnSetsTheSame(value, this.zzYKu.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzFH(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzYKu != null) {
            this.zzYKu.zzEA(false);
            this.getConstraints().remove(this.zzYKu);
            this.zzYKu = null;
        }
        UniqueConstraint.zzFH(this.getConstraints(), uniqueConstraint);
        this.zzYKu = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzVx;
    }

    public void setNamespace(String namespace) {
        this.zzVx = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzgy;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzgy = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzYDo.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzWdb.zzFH(this.getResultSet(), this);
            zzWdb.zzWdb(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzYwX.zzWO6(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzWdb.zzWDH(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzWkw.contains(listener)) {
            this.zzWkw.add(listener);
        }
    }

    public void removeEventListener(zzZCJ listener) {
        if (this.zzWkw.contains(listener)) {
            this.zzWkw.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzWkw.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzYDo.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzWkw) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzYDo.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzWkw) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzYDo.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzWkw) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzWkw) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzWkw) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzWlq zzFH(zzWdb[] zzWdbArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzWdbArray.length];
        for (int i = 0; i < zzWdbArray.length; ++i) {
            dataColumnArray[i] = zzWdbArray[i].zzKl();
        }
        DataTable dataTable = this;
        zzWlq zzWlq2 = dataTable.zzYAc.zzWO6(dataColumnArray);
        if (zzWlq2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzWlq2;
    }

    final zzFw zzYA4() {
        return this.zzYAc;
    }

    final Set<DataRow> zzXl9() {
        return this.zzYDo;
    }
}

