/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzcF;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzXUo = new ArrayList();
    private final Map<String, DataColumn> zzYRq = new HashMap<String, DataColumn>();
    private DataTable zzZjk;

    DataColumnCollection(DataTable table) {
        this.zzZjk = table;
    }

    public void add(DataColumn column) {
        if (zzcF.zzXje(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzZOg(column.getColumnName());
        if (this.zzYRq.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzWO6(this.zzZjk);
        column.setOrdinal(this.zzXUo.size());
        this.zzXUo.add(column);
        this.zzYRq.put(string, column);
        this.zzZjk.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzZjk);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzZjk);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzcF.zzXje(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzZOg(columnName);
        DataColumn dataColumn = this.zzYRq.get(string);
        if (dataColumn != null) {
            int n = this.zzXUo.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzXUo.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzXUo.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzXUo.remove(n);
            this.zzYRq.remove(DataColumnCollection.zzZOg(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzZjk.getRows()) {
                dataRow.remove(n);
            }
            this.zzZjk.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzXUo.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzXUo.iterator();
    }

    public void clear() {
        this.zzYRq.clear();
        this.zzXUo.clear();
    }

    final DataColumn[] zzYEY() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzXUo);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzFH(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzXUo.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzXUo.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzZOg(string);
            String string3 = DataColumnCollection.zzZOg(dataColumn.getColumnName());
            this.zzYRq.remove(string3);
            this.zzYRq.put(string2, dataColumn);
            return;
        }
    }

    private static String zzZOg(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

