/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzV9;
import com.aspose.words.internal.zzVXP;
import com.aspose.words.internal.zzWak;
import com.aspose.words.internal.zzWyM;
import com.aspose.words.internal.zzXwh;
import com.aspose.words.internal.zzY2D;
import com.aspose.words.internal.zzYyZ;
import com.aspose.words.internal.zzZeb;
import com.aspose.words.internal.zzZzP;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzXjT
extends CertPathBuilderSpi {
    private final zzZeb zzXqj;
    private zzYyZ zzXR4;

    zzXjT(zzZeb zzZeb2) {
        this.zzXqj = zzZeb2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzVXP pkixParams;
        if (params instanceof zzVXP) {
            pkixParams = (zzVXP)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzVXP.zzFH((PKIXBuilderParameters)params).zzZwk();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzVXP.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzWyM zzWyM2 = pkixParams.zzXFJ().zzXsz();
        try {
            collection = zzY2D.zzFH(zzWyM2, pkixParams.zzXFJ().zzZ2w());
            collection.addAll(zzY2D.zzFH(zzWyM2, pkixParams.zzXFJ().zzE9()));
        }
        catch (zzYyZ zzYyZ2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzYyZ2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzFH(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzXR4 != null) {
            throw new CertPathBuilderException(this.zzXR4.getMessage(), this.zzXR4.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzFH(X509Certificate x509Certificate, zzVXP zzVXP2, List list) throws CertPathBuilderException {
        zzZzP zzZzP2;
        zzV9 zzV92;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzVXP2.zzX0x().contains(x509Certificate)) {
            return null;
        }
        if (zzVXP2.zzWdS() != -1 && list.size() - 1 > zzVXP2.zzWdS()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzV92 = new zzV9(this.zzXqj);
            zzZzP2 = new zzZzP(this.zzXqj);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzY2D.zzFH(x509Certificate, zzVXP2.zzXFJ().zzWWG(), zzVXP2.zzXFJ().zzZ6s()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzV92.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzYyZ("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzZzP2.engineValidate(certPath, zzVXP2);
                }
                catch (Exception exception) {
                    throw new zzYyZ("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzWak> arrayList = new ArrayList<zzWak>();
            arrayList.addAll(zzVXP2.zzXFJ().zzZ2w());
            try {
                arrayList.addAll(zzY2D.zzFH(x509Certificate.getExtensionValue(zzXwh.zzWDn.getId()), zzVXP2.zzXFJ().zzXiw()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzYyZ("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzY2D.zzFH(x509Certificate, zzVXP2.zzXFJ().zzE9(), arrayList));
            }
            catch (zzYyZ zzYyZ2) {
                throw new zzYyZ("Cannot find issuer certificate for certificate in certification path.", zzYyZ2);
            }
            if (hashSet.isEmpty()) {
                throw new zzYyZ("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzFH(x509Certificate2, zzVXP2, list);
            }
        }
        catch (zzYyZ zzYyZ3) {
            this.zzXR4 = zzYyZ3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

