/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzWuZ;
import com.aspose.words.internal.zzXT6;
import com.aspose.words.internal.zzXV7;
import com.aspose.words.internal.zzXfE;
import com.aspose.words.internal.zzcF;
import com.aspose.words.internal.zzcr;
import com.aspose.words.zzZ43;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzYE7;
    private zzZ43 zzl8;

    Watermark(Document doc, zzZ43 watermarkProvider) {
        this.zzYE7 = doc;
        this.zzl8 = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzZT5(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzFH(text, textWatermarkOptions, this.zzYE7);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzXT6.zzWdb((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzYE7, 75);
        shape.getImageData().setImage(image);
        this.zzFH(shape, options, this.zzYE7);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzXT6.zzWdb((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzYE7, 75);
        shape.getImageData().setImage(imagePath);
        this.zzFH(shape, options, this.zzYE7);
    }

    public final int getType() {
        Shape shape = this.zzl8.get();
        if (shape == null) {
            return 2;
        }
        shape.zztd();
        if (shape.zzLf()) {
            return 0;
        }
        if (shape.zzX0e()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzl8.add(shape);
    }

    public final void remove() {
        this.zzl8.remove();
    }

    private static void zzZT5(String string) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (zzXfE.zzYKX(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzXT6.zzFH(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzFH(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzWdb(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzWDH(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzWdb(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzZbo() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzWu4()) / d2) > (double)(f = pageSetup.zzYtS())) {
            d = (double)f / d3;
        }
        shape.zzYTR(zzcr.zzZCJ(d2 * d, 2, 1));
        shape.zzYLZ(zzcr.zzZCJ(d3 * d, 2, 1));
    }

    private Shape zzFH(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzFH(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzWDH(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzFH(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzZO4() ? 1.0f : textWatermarkOptions.getFontSize();
        zzXV7 zzXV72 = document.zzWJh().zzZCJ(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzXV72.zzY8b(shape.getTextPath().getText());
        if (textWatermarkOptions.zzZO4()) {
            l = Watermark.zzFH(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzYTR(zzcr.zzZCJ(Float.intBitsToFloat(n), 2, 1));
        shape.zzYLZ(zzcr.zzZCJ(zzWuZ.zzWq(l), 2, 1));
    }

    private static long zzFH(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzWu4();
        float f2 = pageSetup.zzYtS();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzWuZ.zzWq(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzWuZ.zz7h(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzWuZ.zzWq(l) >= Float.intBitsToFloat(n)) {
            return zzWuZ.zz7h(f2 / f3, f2);
        }
        float f6 = f;
        return zzWuZ.zz7h(f6, f6 * f3);
    }

    private static void zzWDH(Shape shape, String string) {
        shape.setName(zzcF.zzWdb("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
        shape.setBehindText(true);
    }
}

