/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SectionStart;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzXT6;
import com.aspose.words.internal.zzcF;
import com.aspose.words.zzGG;
import com.aspose.words.zzWbn;
import com.aspose.words.zzYKV;

public final class Section
extends CompositeNode<Node>
implements zzYKV {
    private zzWbn zzYhD;
    private PageSetup zzWoR;
    private HeaderFooterCollection zzX3B;

    public Section(DocumentBase doc) {
        this(doc, new zzWbn());
    }

    Section(DocumentBase doc, zzWbn sectPr) {
        super(doc);
        this.zzYhD = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzX3B == null) {
            this.zzX3B = new HeaderFooterCollection(this);
        }
        return this.zzX3B;
    }

    public final PageSetup getPageSetup() {
        if (this.zzWoR == null) {
            Section section = this;
            this.zzWoR = new PageSetup(section, section.getDocument().zzYUz(), this.getDocument().getStyles(), new zzFH(this));
        }
        return this.zzWoR;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzXae();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzWtw(!value);
    }

    final zzWbn zzXy0() {
        return this.zzYhD;
    }

    final void zzWdb(zzWbn zzWbn2) {
        this.zzYhD = zzWbn2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzFH(boolean bl, zzGG zzGG2) {
        zzWbn zzWbn2;
        Section section = (Section)super.zzFH(bl, zzGG2);
        zzWbn zzWbn3 = this.zzYhD;
        section.zzYhD = zzWbn2 = (zzWbn)zzWbn3.zzYvA();
        section.zzWoR = null;
        section.zzX3B = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public final int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionStart(this);
    }

    @Override
    public final int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzWO6(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzWO6(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzZr4(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzWlq(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzZr4(n) == null;
            }
        }
        return false;
    }

    final void zzZCJ(Shape shape, boolean bl) throws Exception {
        this.zzFH(shape, 4, bl);
        this.zzFH(shape, 0, bl);
        this.zzFH(shape, 1, bl);
    }

    private void zzFH(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzzc());
        shape2.setName(zzcF.zzWdb("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final boolean zzCw() {
        boolean bl = false;
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzZj5()) {
                if (!shape.zztd()) continue;
                shape.remove();
                bl = true;
            }
        }
        return bl;
    }

    private void zzWO6(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzWdb(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzYhD.zzXZ6(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzYUz().zzZ73.zzWcp(key);
        }
        return zzWbn.zzY6J(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzYhD.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzYUz().zzZ73.zzYlo(key, value);
            return;
        }
        this.zzYhD.zzYlo(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzYhD.clear();
    }

    final boolean zzVXM() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzYT5() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = super.toString();
        Section section = this;
        objectArray[1] = SectionStart.toString(section.zzYhD.getSectionStart());
        return zzcF.zzWdb("{0} {1}", objectArray);
    }

    static final class zzFH
    implements zzYKV {
        private Section zzYBL;

        zzFH(Section section) {
            this.zzYBL = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzEQ().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzEQ().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzEQ().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzYKV zzEQ() {
            Document document = zzXT6.zzFH((Object)this.zzYBL.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzYBL;
        }
    }
}

