/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XlsxSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzWXC;
import com.aspose.words.internal.zzWbA;

public abstract class SaveOptions {
    private IDocumentSavingCallback zzXgX;
    private boolean zzZBP;
    boolean zzOj = true;
    private boolean zzVVh = true;
    private boolean zzXkw = false;
    private boolean zzbC;
    private boolean zzY55 = true;
    private boolean zzZKz;
    private String zzXzM;
    private boolean zzXi9;
    private boolean zzWuc = false;
    private int zzYT2 = 1;
    private int zzWtQ = 1;
    private int zzX9k = 0;
    private String zzWJ8 = "";
    private boolean zzZPK = true;
    private boolean zzPP = true;
    private boolean zzZUY;
    private boolean zzWga;
    private int zzYKA = 0;
    private boolean zzFo = true;
    private boolean zzYG2 = false;

    protected SaveOptions() {
    }

    final boolean zzYlU() {
        return this.zzbC;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzW1E() {
        return false;
    }

    boolean zzVW5() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzY55;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzY55 = value;
    }

    public String getTempFolder() {
        return this.zzXzM;
    }

    public void setTempFolder(String value) {
        this.zzXzM = value;
    }

    public boolean getPrettyFormat() {
        return this.zzZKz;
    }

    public void setPrettyFormat(boolean value) {
        this.zzZKz = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzXi9;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzXi9 = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzWuc;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzWuc = value;
    }

    public int getDmlRenderingMode() {
        return this.zzYT2;
    }

    public void setDmlRenderingMode(int value) {
        this.zzYT2 = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzX9k;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzX9k = value;
    }

    public int getImlRenderingMode() {
        return this.zzWtQ;
    }

    public void setImlRenderingMode(int value) {
        this.zzWtQ = value;
    }

    public String getDefaultTemplate() {
        return this.zzWJ8;
    }

    public void setDefaultTemplate(String value) {
        this.zzWJ8 = value;
    }

    public boolean getUpdateFields() {
        return this.zzZPK;
    }

    public void setUpdateFields(boolean value) {
        this.zzZPK = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzZUY;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzZUY = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzWga;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzWga = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzYG2;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzYG2 = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzXkw;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzXkw = value;
    }

    final boolean zzYvQ() {
        return this.zzPP;
    }

    final boolean zzYGJ() {
        return this.zzFo;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                return new ImageSaveOptions(saveFormat);
            }
            case 80: {
                return new XlsxSaveOptions();
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzYWn(zzWXC.zzW74(zzWbA.zzY2P(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzYKA;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzYKA = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzXgX;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzXgX = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzZBP;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzZBP = value;
    }

    final boolean zzYSN() {
        return this.zzVVh;
    }

    final void zzZhh(boolean bl) {
        this.zzVVh = false;
    }
}

