/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzXT6;
import com.aspose.words.internal.zzZ9C;
import com.aspose.words.internal.zzcF;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzGG;
import com.aspose.words.zzXtn;
import com.aspose.words.zzXyb;
import com.aspose.words.zzYzt;
import com.aspose.words.zzZ45;
import com.aspose.words.zzZ69;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzhp;
    private Node zzup;
    private Node zzZee;
    private int zzXUw;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzZCJ(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzhp == null) {
            return null;
        }
        if (this.zzhp.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzhp;
    }

    final CompositeNode zzZYH() {
        if (zzYzt.zzZ8i(this.getParentNode())) {
            return this.getParentNode().zzZYH();
        }
        return this.getParentNode();
    }

    final CompositeNode zz5m() {
        if (zzYzt.zzZ8i(this.getParentNode()) || zzYzt.zzZRs(this.getParentNode())) {
            return this.getParentNode().zz5m();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzhp != null) {
            return this.zzhp.getDocument();
        }
        return null;
    }

    final Document zzWZm() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzYvT() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzZmq();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzZee;
    }

    final Node zzZ8n() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzYzt.zzYNu((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzeO() {
        Node node = zzYzt.zzYOi(this.getPreviousSibling(), false);
        if (node == null && zzYzt.zzZ8i(this.getParentNode())) {
            node = this.getParentNode().zzeO();
        }
        return node;
    }

    final Node zzXnY() {
        Node node = zzYzt.zzWn8(this.getNextSibling(), false);
        if (node == null && zzYzt.zzZ8i(this.getParentNode())) {
            node = this.getParentNode().zzXnY();
        }
        return node;
    }

    final CompositeNode zzY0o() {
        Node node = this;
        while ((node = node.zzeO()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzXRF() {
        Node node = this;
        while ((node = node.zzXnY()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzup;
    }

    final Node zzZFs() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzYzt.zzYNu((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzWZp() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzW7z() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzXcK() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzYzt.zzVXw(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzYlT() {
        return this.zzup;
    }

    final void zzWta(Node node) {
        this.zzup = node;
    }

    final Node zzZZw() {
        return this.zzZee;
    }

    final void zzZRi(Node node) {
        this.zzZee = node;
    }

    final Node zzZh0() {
        Node node = this;
        if (node.zzup != null) {
            node = this;
            return node.zzup;
        }
        return this.getParentNode();
    }

    final int zzXBY() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzYzt.zzXMC(this);
        boolean bl2 = zzYzt.zzY8b(this);
        boolean bl3 = zzYzt.zzjJ(this);
        boolean bl4 = zzYzt.zzZ7l(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzXBY() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzXBY() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzFH(isCloneChildren, new zzFH(this));
    }

    Node zzFH(boolean bl, zzGG zzGG2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzhp != null) {
            node.zzhp = this.getDocument().zzX2O();
        }
        node.zzup = null;
        node.zzZee = null;
        if (zzGG2 != null) {
            zzGG2.zzWO6(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzSC(StringBuilder stringBuilder) {
        zzXT6.zzWdb(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    final zzZ69 zzZeX() {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            zzZ69 zzZ692 = zzXT6.zzFH((Object)compositeNode, zzZ69.class);
            if (zzZ692 == null) continue;
            return zzZ692;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzg(Node node) {
        this.zzhp = node != null ? node : this.getDocument().zzX2O();
    }

    final void zzZCJ(DocumentBase documentBase) {
        this.zzhp = documentBase != null ? documentBase.zzX2O() : null;
    }

    final boolean zzEs(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzWLk() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zz0n(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzsb(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzF(Node node, int n) {
        for (Node node2 = this.nextPreOrder(node); node2 != null; node2 = node2.nextPreOrder(node)) {
            if (node2.getNodeType() != 8) continue;
            return node2;
        }
        return null;
    }

    final Node zzSC(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzXRj(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    final Node zzW7g(Node node) {
        return this.getParentNode().insertAfter(node, this);
    }

    final Node zzYni(Node node) {
        return this.getParentNode().insertBefore(node, this);
    }

    public String toString(int saveFormat) throws Exception {
        zzXyb zzXyb2 = zzYzt.zzZOi(saveFormat);
        return zzXyb2.zzXkh(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzXyb zzXyb2 = zzYzt.zzWdb(saveOptions);
        return zzXyb2.zzXkh(this);
    }

    final Node zzWPp(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzYzt.zzYxU(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzXtn zzY2j() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzXtn.zzNu(node);
        }
        return zzXtn.zzZAc(this.getParentNode());
    }

    final zzXtn zzXlV() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzXtn.zzZAc(node);
        }
        return zzXtn.zzNu(this.getParentNode());
    }

    final boolean zzZRO(Node node) {
        return Node.zzXdu(this, node);
    }

    final boolean zzvR() {
        return this.getAncestor(1) == null;
    }

    static Node zzIg(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzZ9C<Node> zzZ9C2 = Node.zzYsv(node);
        zzZ9C<Node> zzZ9C3 = Node.zzYsv(node2);
        return Node.zzFH(zzZ9C2, zzZ9C3);
    }

    static boolean zzXdu(Node node, Node node2) {
        zzZ9C<Node> zzZ9C2;
        if (node == null || node2 == null) {
            return false;
        }
        zzZ9C<Node> zzZ9C3 = Node.zzYsv(node);
        Node node3 = Node.zzFH(zzZ9C3, zzZ9C2 = Node.zzYsv(node2));
        if (node3 == null) {
            return false;
        }
        zzZ9C<Node> zzZ9C4 = zzZ9C3;
        if (zzZ9C4.size() == 0 || (zzZ9C4 = zzZ9C2).size() == 0) {
            zzZ9C4 = zzZ9C2;
            boolean bl = zzZ9C4.size() > 0;
            return bl;
        }
        Object e = zzZ9C3.peek();
        Object e2 = zzZ9C2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes(0, false)) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzZ9C<Node> zzYsv(Node node) {
        zzZ9C<Node> zzZ9C2 = new zzZ9C<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzZ9C2.push(node2);
        }
        return zzZ9C2;
    }

    private static Node zzFH(zzZ9C<Node> zzZ9C2, zzZ9C<Node> zzZ9C3) {
        Node node = null;
        while (zzZ9C2.peek() == zzZ9C3.peek()) {
            node = (Node)zzZ9C2.pop();
            zzZ9C3.pop();
            zzZ9C<Node> zzZ9C4 = zzZ9C2;
            if (zzZ9C4.size() != 0 && (zzZ9C4 = zzZ9C3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzXUw;
    }

    public void setCustomNodeId(int value) {
        this.zzXUw = value;
    }

    private String zzYjj() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this; node != null && node.getParentNode() != null; node = node.getParentNode()) {
            int n = 0;
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null && node2 != node; node2 = node2.getNextSibling()) {
                ++n;
            }
            zzXT6.zzFH(stringBuilder, "{0}{1}", node == this ? "" : ".", n);
        }
        return zzcF.zzWiz(stringBuilder.toString());
    }

    public String toString() {
        return zzcF.zzWiz(zzcF.zzWdb("{0} {1}", Node.nodeTypeToString(this.getNodeType()), this.zzYjj()));
    }

    public void dd() {
    }

    final Node zzjJ(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzYEz(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzXMC(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zzYEz(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zzYEz(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zzFH
    implements zzGG {
        private Node zzZbv;
        private HashMap<Integer, Integer> zzYCb;

        zzFH(Node node) {
            this.zzZbv = node;
        }

        @Override
        public final void zzWO6(Node node, Node node2) {
            if (node == this.zzZbv) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zzZ45 zzZ452 = (zzZ45)((Object)node2);
            if (this.zzYCb == null) {
                this.zzYCb = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zzXT6.zzFH(this.zzYCb, Integer.valueOf(zzZ452.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzZKb();
                zzXT6.zzWdb(this.zzYCb, Integer.valueOf(zzZ452.getIdInternal()), Integer.valueOf(n));
            }
            zzZ452.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zzXT6.zzFH(this.zzYCb, Integer.valueOf(zzZ452.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zzZ452.setParentIdInternal(n2);
            }
        }
    }
}

