/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzWXC;
import com.aspose.words.internal.zzWay;
import com.aspose.words.internal.zzXT6;
import com.aspose.words.internal.zzXfE;
import com.aspose.words.internal.zzYqW;
import com.aspose.words.internal.zzaX;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzZ0q;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzXnG = new HashMap();
    private static HashMap<Integer, Integer> zzXzv = new HashMap();
    private static HashMap<Integer, Integer> zzYUR = new HashMap();
    private static HashMap<Integer, Integer> zzYaw = new HashMap();
    private static HashMap<Integer, Integer> zzW2W = new HashMap();
    private static HashMap<Integer, Integer> zzW6G = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzXT6.zzZCJ(fileName, "fileName");
        try (zzWay zzWay2 = zzXT6.zzWlx(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzXRM(zzWay2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzXRM(zzYqW.zzFH(stream));
    }

    static FileFormatInfo zzXRM(zzaX zzaX2) throws Exception {
        if (zzaX2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        try {
            zzZ0q zzZ0q2 = new zzZ0q();
            zzaX zzaX3 = zzaX2;
            zzZ0q zzZ0q3 = zzZ0q2;
            return zzZ0q2.zzWdb(zzaX3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzZCJ(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzCC(zzWXC.zzWNU(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzYWn(zzWXC.zzWNU(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzXfE.zzXVo(string = zzWXC.zzVSo(FileFormatUtil.zzYxJ(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzCC(FileFormatUtil.zzXtP(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzYWn(FileFormatUtil.zzYxJ(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzWXC.zzVSo(FileFormatUtil.zzXtP(saveFormat));
        if (zzXfE.zzXVo(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: extension");
        }
        return FileFormatUtil.zzYWn(zzWXC.zzW74(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzWXC.zzVSo(FileFormatUtil.zzZb8(imageType));
    }

    static Exception zzZCJ(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzYq2(int n) {
        return zzWXC.toString(FileFormatUtil.zzXtP(n));
    }

    static int zzYWn(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzXT6.zzFH(zzW2W, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzho(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzXT6.zzFH(zzW6G, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzZRj(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzYxJ(int n) {
        return zzXT6.zzFH(zzXnG, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzXtP(int n) {
        return zzXT6.zzFH(zzXzv, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzZb8(int n) {
        return zzXT6.zzFH(zzYUR, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzCC(int n) {
        return zzXT6.zzFH(zzYaw, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzX2I(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzXT6.zzWdb(zzW2W, Integer.valueOf(n), Integer.valueOf(n2));
            zzXT6.zzWdb(zzXzv, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzYaw.containsKey(n)) {
                zzXT6.zzWdb(zzYaw, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzXT6.zzWdb(zzXnG, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzXT6.zzWdb(zzW6G, Integer.valueOf(n), Integer.valueOf(n4));
            zzXT6.zzWdb(zzYUR, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzX2I(13, 10, 10, 1);
        FileFormatUtil.zzX2I(13, 0, 0, 1);
        FileFormatUtil.zzX2I(14, 11, 11, 1);
        FileFormatUtil.zzX2I(15, 20, 20, 1);
        FileFormatUtil.zzX2I(15, 0, 254, 1);
        FileFormatUtil.zzX2I(16, 21, 21, 1);
        FileFormatUtil.zzX2I(17, 22, 22, 1);
        FileFormatUtil.zzX2I(18, 23, 23, 1);
        FileFormatUtil.zzX2I(20, 24, 24, 1);
        FileFormatUtil.zzX2I(21, 25, 25, 1);
        FileFormatUtil.zzX2I(22, 26, 26, 1);
        FileFormatUtil.zzX2I(23, 27, 27, 1);
        FileFormatUtil.zzX2I(26, 30, 30, 1);
        FileFormatUtil.zzX2I(19, 31, 31, 1);
        FileFormatUtil.zzX2I(27, 50, 50, 1);
        FileFormatUtil.zzX2I(28, 45, 255, 1);
        FileFormatUtil.zzX2I(29, 51, 51, 1);
        FileFormatUtil.zzX2I(30, 54, 52, 1);
        FileFormatUtil.zzX2I(31, 0, 53, 1);
        FileFormatUtil.zzX2I(33, 53, 54, 1);
        FileFormatUtil.zzX2I(24, 60, 60, 1);
        FileFormatUtil.zzX2I(25, 61, 61, 1);
        FileFormatUtil.zzX2I(36, 40, 64, 1);
        FileFormatUtil.zzX2I(43, 47, 255, 1);
        FileFormatUtil.zzX2I(44, 48, 255, 1);
        FileFormatUtil.zzX2I(37, 41, 255, 1);
        FileFormatUtil.zzX2I(38, 46, 255, 1);
        FileFormatUtil.zzX2I(40, 42, 255, 1);
        FileFormatUtil.zzX2I(39, 44, 255, 1);
        FileFormatUtil.zzX2I(32, 52, 55, 1);
        FileFormatUtil.zzX2I(34, 70, 62, 1);
        FileFormatUtil.zzX2I(35, 73, 63, 1);
        FileFormatUtil.zzX2I(41, 71, 255, 1);
        FileFormatUtil.zzX2I(8, 100, 255, 1);
        FileFormatUtil.zzX2I(9, 105, 255, 1);
        FileFormatUtil.zzX2I(6, 101, 255, 6);
        FileFormatUtil.zzX2I(7, 102, 255, 7);
        FileFormatUtil.zzX2I(5, 104, 255, 5);
        FileFormatUtil.zzX2I(4, 0, 255, 4);
        FileFormatUtil.zzX2I(3, 0, 255, 3);
        FileFormatUtil.zzX2I(42, 72, 255, 1);
        FileFormatUtil.zzX2I(2, 103, 255, 2);
        FileFormatUtil.zzX2I(10, 106, 255, 8);
        FileFormatUtil.zzX2I(48, 80, 255, 1);
        FileFormatUtil.zzX2I(11, 0, 255, 9);
    }
}

