/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zzW4T;
import com.aspose.words.internal.zzWEZ;
import com.aspose.words.internal.zzWbA;
import com.aspose.words.internal.zzWuZ;
import com.aspose.words.internal.zzWw0;
import com.aspose.words.internal.zzXC5;
import com.aspose.words.internal.zzXT6;
import com.aspose.words.internal.zzXfE;
import com.aspose.words.internal.zzYCv;
import com.aspose.words.internal.zzZ27;
import com.aspose.words.internal.zzZ9C;
import com.aspose.words.internal.zzZRY;
import com.aspose.words.internal.zzZYI;
import com.aspose.words.internal.zzZZq;
import com.aspose.words.internal.zzaX;
import com.aspose.words.internal.zzcF;
import com.aspose.words.internal.zziX;
import com.aspose.words.internal.zzxu;
import com.aspose.words.zz5A;
import com.aspose.words.zz6T;
import com.aspose.words.zzHl;
import com.aspose.words.zzMs;
import com.aspose.words.zzVYI;
import com.aspose.words.zzW2H;
import com.aspose.words.zzW3l;
import com.aspose.words.zzWJL;
import com.aspose.words.zzWNr;
import com.aspose.words.zzWZb;
import com.aspose.words.zzWag;
import com.aspose.words.zzWbn;
import com.aspose.words.zzWgW;
import com.aspose.words.zzWls;
import com.aspose.words.zzWrB;
import com.aspose.words.zzX5A;
import com.aspose.words.zzX5B;
import com.aspose.words.zzXFt;
import com.aspose.words.zzXT;
import com.aspose.words.zzXXa;
import com.aspose.words.zzXYM;
import com.aspose.words.zzXqp;
import com.aspose.words.zzXtn;
import com.aspose.words.zzY2Y;
import com.aspose.words.zzY2g;
import com.aspose.words.zzYAb;
import com.aspose.words.zzYK8;
import com.aspose.words.zzYUi;
import com.aspose.words.zzYWn;
import com.aspose.words.zzYa2;
import com.aspose.words.zzYc1;
import com.aspose.words.zzYhQ;
import com.aspose.words.zzYhl;
import com.aspose.words.zzYzt;
import com.aspose.words.zzZ1R;
import com.aspose.words.zzZAc;
import com.aspose.words.zzZeb;
import com.aspose.words.zzZqk;
import com.aspose.words.zzd5;
import com.aspose.words.zzdR;
import com.aspose.words.zzkz;
import com.aspose.words.zzpN;
import com.aspose.words.zzyv;
import com.aspose.words.zzz0;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzXqp,
zzYAb,
zzYc1,
zzpN {
    private Document zzYE7;
    private Node zzX6U;
    private Node zzWlU;
    private zzYUi zzVRJ;
    private Font zzjn;
    private zzZ9C<zzYUi> zzYmD;
    private zzZ9C<zzWZb> zzY8Z;
    private zzZ9C<zzFH> zzyB;
    private zz5A zzXsV = zz5A.zzX0Y();
    private zzXXa zzWk9 = new zzXXa();
    private zzWZb zzZCI;
    private RowFormat zzVPs;
    private CellFormat zzZ5U;
    private ParagraphFormat zze3;
    private zzZ9C<zzW2H> zzTE;
    private int zzWCs = 0;
    private int zzXHS = -1;
    private int zzXMH;
    private boolean zzYCj;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzYOi(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzYOi(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzYOi(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzFH(documentBuilder.getCurrentSection(), zzY2Y.zzZRZ(headerFooterType), 0, 0);
    }

    private void zzYOi(int n, int n2, int n3, int n4) {
        this.zzYE7.ensureMinimum();
        Section section = (Section)this.zzYE7.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzFH(section, 1, n3, n4);
    }

    private void zzFH(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzY2Y.zzYhV(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = section.appendChild(new HeaderFooter(this.zzYE7, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzYE7));
            }
        }
        this.zzFH(story, n2, n3);
    }

    private void zzFH(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzFH((CompositeNode)paragraph2, n3);
    }

    final void zzFH(Paragraph paragraph, int n) {
        this.zzFH((CompositeNode)paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldName");
        }
        FieldMergeField fieldMergeField = this.zzXPv().zzvR() ? zzYK8.zzYVE(this.zzYE7, fieldName) : zzYK8.zzZbN(this.zzXPv(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzFH(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzFH(field, isAfter, false);
    }

    private boolean zzFH(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzYa2 zzYa22 = field.getFormat().zzWBA();
        Inline inline = zzYa22.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzFH(inline.zzYFY(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: bookmarkName");
        }
        Node node = isStart ? zzWrB.zzFH(this.zzYE7, bookmarkName) : zzWrB.zzWdb(this.zzYE7, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzXBY() == 6) {
            this.zzFH(node.zzZYH(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzYzt.zzWNU(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzFH((CompositeNode)paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzFH(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToStructuredDocumentTag(int structuredDocumentTagIndex, int characterIndex) {
        StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.getCurrentStory().getChild(28, structuredDocumentTagIndex, true);
        if (structuredDocumentTag == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: structuredDocumentTagIndex");
        }
        this.moveToStructuredDocumentTag(structuredDocumentTag, characterIndex);
    }

    public void moveToStructuredDocumentTag(StructuredDocumentTag structuredDocumentTag, int characterIndex) {
        if (structuredDocumentTag == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: structuredDocumentTag");
        }
        if (characterIndex >= 0) {
            this.zzWdb(structuredDocumentTag, characterIndex);
            return;
        }
        if (++characterIndex == 0) {
            this.zzFH(structuredDocumentTag);
            return;
        }
        this.zzZCJ(structuredDocumentTag, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzVQi(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzFH((CompositeNode)cell, characterIndex);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzXBY() == 6) {
            this.zzjw(node);
        } else {
            Node node2 = node;
            if (zzYzt.zzYNu(node2.getNodeType())) {
                Paragraph paragraph = zzYzt.zzWNU(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzjw(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzXBY() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzjw(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzXMH = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzXoW();
            return;
        }
        if (!this.zzYd3()) {
            this.zzXoW();
        }
    }

    private void zzFH(CompositeNode compositeNode, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(compositeNode);
    }

    private boolean zzYd3() {
        Node node = this.zzXPv();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
            if (node == null && this.zzXPv().getParentNode().getNodeType() == 28) {
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzFH(((StructuredDocumentTag)documentBuilder.zzXPv().getParentNode()).zzXsa(), true);
                return true;
            }
        }
        if (node == null) {
            for (node = this.zzXPv(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzFH(inline.zzYFY(), true);
            return true;
        }
        return false;
    }

    private void zzXoW() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzFH(documentBuilder.getCurrentParagraph().zzXcb(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzVQi(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzMq() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzXPv().zzEs(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzXRF();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzFH((CompositeNode)paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzZAc(text, false);
    }

    public void writeln(String text) {
        this.zzZAc(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph;
        if (this.zzXPv() != null && this.zzXPv().zzXBY() == 6 && (this.isAtEndOfStructuredDocumentTag() || this.zzXPv().getParentNode() instanceof StructuredDocumentTag)) {
            throw new IllegalStateException("Cannot insert a node of this type at this location.");
        }
        this.zzau();
        Paragraph paragraph2 = this.getCurrentParagraph();
        zzWls zzWls2 = new zzWls(this.getDocument());
        try {
            paragraph = new Paragraph(this.zzYE7, this.zzYq0(), this.zzZii());
            if (paragraph2 == null && this.isAtEndOfStructuredDocumentTag()) {
                this.getCurrentStructuredDocumentTag().appendChild(paragraph);
            } else {
                this.getCurrentParagraph().zzW7g(paragraph);
            }
            if (this.isAtEndOfParagraph() || paragraph2 == null) {
                this.moveTo(paragraph);
            } else {
                paragraph.zzWdb(this.zzXPv(), null, paragraph.getLastChild());
            }
        }
        finally {
            zzWls2.dispose();
        }
        if (this.getDocument().zzYxT()) {
            zzYzt.zzZCJ((zzZqk)(paragraph2 != null ? paragraph2 : paragraph), this.getDocument().zzYnw());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzZP5() {
        zzYUi zzYUi2;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zzau();
        Node node = this.zzXPv();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzYFd(false);
        } else {
            run2 = run = (Run)node.zzsb(21);
        }
        if (run2 == null && zzXT6.zzF(node, paragraph.zzWWl())) {
            run = paragraph.zzWWl();
        }
        if (run != null) {
            cloneable = run.zzYFY();
            zzYUi2 = (zzYUi)((zzWag)cloneable).zzYvA();
        } else {
            cloneable = paragraph.zzXcb();
            zzYUi2 = (zzYUi)((zzWag)cloneable).zzYvA();
        }
        zzYUi zzYUi3 = zzYUi2;
        Paragraph paragraph2 = new Paragraph(this.zzYE7, this.zzYq0(), zzYUi3);
        paragraph.zzYni(paragraph2);
        zzWls zzWls2 = new zzWls(this.zzYE7);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzWdb(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzWls2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzyv.zzYVE(this);
    }

    public void insertBreak(int breakType) {
        this.zzVXw(breakType, true);
    }

    final void zzVXw(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzXSC(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzYgQ(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzWxl())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzXSC(bl)) {
                        this.zzYgQ(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzXSC(bl)) {
                        this.zzXBK(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzXSC(bl)) {
                        this.zzXBK(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzXSC(bl)) {
                        this.zzXBK(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzXSC(bl)) {
                        this.zzXBK(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzXSC(bl)) {
                        this.zzXBK(4);
                    }
                    return;
                }
                case 8: {
                    this.zzYgQ(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzXfE.zzXVo(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzcF.zzWdb("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzau();
        return zzYzt.zzFH(fieldType, updateField, this.zzZii(), this.zzY5x(), this.zzTb(), this.zzTb() == null);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzau();
        return zzYzt.zzFH(fieldCode, this.zzZii(), this.zzY5x(), this.zzTb(), this.zzTb() == null);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzau();
        return zzYzt.zzFH(fieldCode, fieldValue, this.zzZii(), this.zzY5x(), this.zzTb(), this.zzTb() == null);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzXT6.zzWdb((Object)displayText, "displayText");
        zzXT6.zzWdb((Object)urlOrBookmark, "hrefOrBookmark");
        zzMs zzMs2 = this.zzWdb(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzMs2.zzZCJ(documentBuilder.zzZEq(88, true));
        return zzYzt.zzFH(zzMs2.getStart(), zzMs2.getSeparator(), zzMs2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (format == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzXsC(70);
        if (zzXfE.zzXVo(name)) {
            this.startBookmark(name);
        }
        this.zzKt(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzXYm(70);
        String string = zzXfE.zzXVo(fieldValue) ? fieldValue : FormField.zzZp2;
        Run run = new Run(this.zzYE7, string, this.zzZii());
        this.insertNode(run);
        Node node = this.zzZEq(70, true);
        if (zzXfE.zzXVo(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzYTr(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzFH((CompositeNode)((Paragraph)node.zzZYH()), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzXsC(71);
        if (zzXfE.zzXVo(name)) {
            this.startBookmark(name);
        }
        this.zzKt(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzZEq(71, false);
        if (zzXfE.zzXVo(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzYTr(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (items == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzXsC(83);
        if (zzXfE.zzXVo(name)) {
            this.startBookmark(name);
        }
        this.zzKt(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzZEq(83, false);
        if (zzXfE.zzXVo(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzYTr(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzYE7, footnoteType, !zzXfE.zzXVo(referenceMark), referenceMark, this.zzZii());
        Style style = this.getDocument().getStyles().zzYwt(zzYzt.zztX(footnoteType));
        footnote.zzYFY().set(50, style.zzYhJ());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzYE7);
        Style style2 = this.getDocument().getStyles().zzYwt(zzYzt.zzZo9(footnoteType));
        paragraph.zzWMN().set(1000, style2.zzYhJ());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzYE7, '\u0002', new zzYUi()) : new Run(this.zzYE7, footnote.getReferenceMark(), new zzYUi());
        inline.zzYFY().set(50, style.zzYhJ());
        paragraph.appendChild(inline);
        if (zzXfE.zzXVo(footnoteText)) {
            Node node = this.zzXPv();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzjw(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzZ4f(zzaX zzaX2) throws Exception {
        return this.zzFH(zzaX2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzZ4f(zzaX.zzWdb(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzFH(zzaX zzaX2, double d, double d2) throws Exception {
        return this.zzFH(zzaX2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzFH(zzaX.zzWdb(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: image");
        }
        try (zzZ27 zzZ272 = new zzZ27();){
            zziX.zzFH(image, zzZ272);
            Shape shape = this.zzFH(zzZ272, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzXT6.zzZCJ(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzYCv.zzY4I(fileName);
        try {
            Shape shape = this.zzFH((zzaX)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzaX)object).close();
            }
        }
    }

    private Shape zzFH(zzaX zzaX2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzaX2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        byte[] byArray = zzXT6.zzYVE(zzaX2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzFH(zzaX.zzWdb(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzFH(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzFH(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        boolean bl2 = false;
        if (zzWEZ.zzWDx(object)) {
            object4 = new zziX((byte[])object);
            bl2 = true;
            ((zzXC5)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzYE7.getCompatibilityOptions().getMswVersion() > 12 || this.zzYE7.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzYE7, 0);
            object3 = new zzX5A();
            ((zzZ1R)object3).zzFH(zzdR.zzWHW("rect"));
            ((zzX5A)object3).zzFH(new zzkz());
            ((zzX5A)object3).zzYAl().zzWBf().zzZCJ(this.zzYE7);
            object2 = new zzWNr();
            ((zzWgW)object2).zzWdb(new zzHl(this.zzYE7.zzzc(), ""));
            ((zzWgW)object2).zzFH(new zzX5B());
            ((zzXYM)object3).zzFH((zzWgW)object2);
            shape.setShapeType(75);
            shape.zzWlq((zzXYM)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzYE7, 75);
        }
        if (zzWEZ.zzfi(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzFH((byte[])object, new zzz0(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzz0(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzWEZ.zztg((byte[])object2));
                this.zzFH((zzX5A)shape.zzXTa(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzX5A)shape.zzXTa()).zzYAl().zzWBf().zzWfp((byte[])object);
            object3 = zzWEZ.zziX(object);
            object4 = new zzz0(((zzZZq)object3).getWidthPoints(), ((zzZZq)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzWdb(this.zzZii());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzWEZ.zzYTu(object)) {
            d5 = DocumentBuilder.zzFH(shape, object);
        }
        shape.zzFH(d3, d4, (zzz0)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzFH(Shape shape, byte[] byArray) throws Exception {
        int n = zzWEZ.zzVTQ(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzYzt.zzWV4(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzYzt.zzW0C(n);
        return d;
    }

    private void zzFH(zzX5A zzX5A2, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzX5A2.zzYAl().zzWBf().getExtensions();
        try (zzZ27 zzZ272 = new zzZ27(byArray);){
            object = zzYzt.zzFH(zzZ272, this.zzYE7);
            ((zzd5)object).zzWlx(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzd5)object).zzZ3O();
            byArray2 = ((zzd5)object).zzWCP(true);
        }
        zzX5A2.zzYAl().zzWBf().setExtensions(new zzZYI<zzYhQ>());
        object = zzYhQ.zzFH(byArray2, this.zzYE7);
        zzX5A2.zzYAl().zzWBf().getExtensions().zzWDH(((zzYhQ)object).getUri(), (zzYhQ)object);
    }

    private Shape zzFH(zzaX zzaX2, String string, boolean bl, zzaX zzaX3) throws Exception {
        zzY2g zzY2g2 = zzY2g.zzW1a(string);
        Shape shape = this.zzFH(zzaX3, bl, zzY2g2, null);
        zzZeb zzZeb2 = zzXT.zzFH(zzaX2, string, bl);
        return DocumentBuilder.zzFH(null, false, shape, zzY2g2.zzZti, zzZeb2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzFH(zzaX.zzWdb(stream), progId, asIcon, zzaX.zzWdb(presentation));
    }

    private Shape zzFH(String string, boolean bl, boolean bl2, zzaX zzaX2) throws Exception {
        zzY2g zzY2g2 = zzY2g.zzWAa(zzWbA.zzY2P(string));
        return this.zzFH(string, bl, bl2, zzaX2, zzY2g2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzFH(fileName, isLinked, asIcon, zzaX.zzWdb(presentation));
    }

    private Shape zzFH(String string, String string2, boolean bl, boolean bl2, zzaX zzaX2) throws Exception {
        zzY2g zzY2g2 = zzY2g.zzW1a(string2);
        return this.zzFH(string, bl, bl2, zzaX2, zzY2g2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzFH(fileName, progId, isLinked, asIcon, zzaX.zzWdb(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzY2g zzY2g2 = zzY2g.zzWAa(zzWbA.zzY2P(fileName));
        return this.zzFH(fileName, isLinked, iconFile, iconCaption, zzY2g2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzY2g zzY2g2 = zzY2g.zzW1a(progId);
        return this.zzFH(fileName, isLinked, iconFile, iconCaption, zzY2g2);
    }

    private Shape zzWdb(zzaX zzaX2, String string, String string2, String string3) throws Exception {
        zzY2g zzY2g2 = zzY2g.zzW1a(string);
        Shape shape = this.zzFH(string2, string3, zzY2g2);
        zzZeb zzZeb2 = zzXT.zzFH(zzaX2, string, true);
        return DocumentBuilder.zzFH(null, false, shape, zzY2g2.zzZti, zzZeb2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzWdb(zzaX.zzWdb(stream), progId, iconFile, iconCaption);
    }

    final Shape zzFH(zzYhl zzYhl2, zzaX zzaX2) throws Exception {
        Shape shape = this.zzWpU(zzaX2);
        shape.setShapeType(201);
        shape.setShapeAttr(4112, zzYhl2);
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzau();
        if (this.zzWEm()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzWEZ(documentBuilder.getDocument().toString(70)));
            return;
        }
        zz6T zz6T2 = zzYzt.zzFH(html, options, this);
        zz6T2.zzpv();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzau();
        return zzYzt.zzFH(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzau();
        return zzYzt.zzFH(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzXFt zzXFt2 = new zzXFt();
        return zzXFt2.zzFH(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzW3l(this).zzFH(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzW3l(this).zzFH(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzYE7, 75);
        shape.zzWdb(this.zzZii());
        shape.zzWL1(true);
        shape.getSignatureLine().zzFH(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzZ8(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzZ8i(this.zzYE7);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzWEm() {
        boolean bl = false;
        if (this.zzXPv().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzXPv().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzWEZ(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzau();
        if (this.zzMq() == null) {
            this.startTable();
        }
        if (this.zzMq().zzjW() == 1) {
            this.zzMq().zzZRw();
        }
        if (this.zzMq().zzjW() == 3) {
            this.zzMq().zzZdm();
        }
        return this.zzMq().zzZq0();
    }

    public Table startTable() {
        this.zzTE.push(new zzW2H(this));
        return this.zzMq().startTable();
    }

    public Table endTable() {
        if (this.zzMq() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzMq().endTable();
        this.zzTE.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzMq() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzMq().endRow();
        if (this.zzjn != null && this.zzjn.getHidden()) {
            row.zzWbn().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzYE7, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzYE7, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzY5e();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzYE7, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzXHx();
        bookmarkStart.zzWy8(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzY5e();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzXHx();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzYE7, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzTy(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzYE7);
        this.zzXHS = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzXHS == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzYE7, this.zzXHS);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzYE7, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzXT6.zzWdb((Object)importFormatOptions, "ImportFormatOptions");
        this.zzau();
        return zzVYI.zzFH(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Node insertDocumentInline(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzXT6.zzWdb((Object)importFormatOptions, "ImportFormatOptions");
        this.zzau();
        importFormatOptions.zzXdM(true);
        Node node = zzVYI.zzFH(this, srcDoc, importFormatMode, importFormatOptions);
        importFormatOptions.zzXdM(false);
        return node;
    }

    public Document getDocument() {
        return this.zzYE7;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzYE7) {
            return;
        }
        this.zzYE7 = value;
        this.zzjw(null);
        this.zzVRJ = new zzYUi();
        this.zzYmD = null;
        this.zzY8Z = null;
        this.zzjn = null;
        this.zzTE = new zzZ9C();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzjn == null) {
            DocumentBuilder documentBuilder = this;
            this.zzjn = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzjn;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        if (this.zze3 == null) {
            DocumentBuilder documentBuilder = this;
            this.zze3 = new ParagraphFormat(documentBuilder, documentBuilder.getDocument().getStyles());
        }
        return this.zze3;
    }

    public ListFormat getListFormat() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().getListFormat();
        }
        return null;
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzVPs == null) {
            this.zzVPs = new RowFormat(this);
        }
        return this.zzVPs;
    }

    public CellFormat getCellFormat() {
        if (this.zzZ5U == null) {
            this.zzZ5U = new CellFormat(this);
        }
        return this.zzZ5U;
    }

    final void zzW7Y(Node node) {
        this.getCurrentParagraph().zzYni(node);
    }

    public void pushFont() {
        zzYUi zzYUi2;
        if (this.getCurrentParagraph() != null) {
            zzYUi zzYUi3 = this.getCurrentParagraph().zzXcb();
            zzYUi2 = (zzYUi)zzYUi3.zzYvA();
        } else {
            zzYUi2 = this.zzZii();
        }
        zzYUi zzYUi4 = zzYUi2;
        this.zzW7s().push(new zzFH(this.zzZii(), zzYUi4));
    }

    public void popFont() {
        zzZ9C<zzFH> zzZ9C2 = this.zzW7s();
        if (zzZ9C2.size() > 0) {
            zzFH zzFH2 = (zzFH)this.zzW7s().pop();
            this.zzFH(zzFH2.zzYFY(), false);
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzYTr(zzFH2.zzYVf());
            }
        }
    }

    final void zzDb() {
        this.zzZiy().push(this.zzZii());
    }

    final void zzYV2() {
        zzZ9C<zzYUi> zzZ9C2 = this.zzZiy();
        if (zzZ9C2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzFH((zzYUi)documentBuilder.zzZiy().pop(), false);
        }
    }

    final void zzZVa() {
        this.zzap().push(this.zzYq0());
    }

    final void zzHs() {
        zzZ9C<zzWZb> zzZ9C2 = this.zzap();
        if (zzZ9C2.size() > 0) {
            zzWZb zzWZb2 = (zzWZb)this.zzap().pop();
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzFH(zzWZb2);
            }
        }
    }

    private zzMs zzWdb(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzXsC(88);
        zzYWn zzYWn2 = new zzYWn();
        zzYWn2.setTarget(string2);
        zzYWn2.setScreenTip(string3);
        if (bl) {
            zzYWn2.setSubAddress(string);
        } else {
            zzYWn2.setAddress(zzW4T.zzY0A(string));
            zzYWn2.setSubAddress(zzW4T.zzXjq(string));
        }
        this.zzKt(zzYWn2.zzXWU());
        FieldSeparator fieldSeparator = this.zzXYm(88);
        return new zzMs(fieldStart, fieldSeparator, null);
    }

    final zzMs zzYOi(String string, String string2, String string3) {
        boolean bl = zzW4T.zzZPk(string);
        String string4 = bl ? zzW4T.zzXjq(string) : string;
        return this.zzWdb(string4, bl, string2, string3);
    }

    final zzMs zzFH(zzYWn zzYWn2) {
        FieldStart fieldStart = this.zzXsC(88);
        this.zzKt(zzYWn2.zzXWU());
        FieldSeparator fieldSeparator = this.zzXYm(88);
        return new zzMs(fieldStart, fieldSeparator, null);
    }

    final FieldEnd zzWLs() {
        return this.zzZEq(88, true);
    }

    final zzYUi zzZii() {
        zzYUi zzYUi2 = this.zzVRJ;
        return (zzYUi)zzYUi2.zzYvA();
    }

    final zzWZb zzYq0() {
        zzWZb zzWZb2 = this.zzWMN();
        return (zzWZb)zzWZb2.zzYvA();
    }

    final zz5A zzYHx() {
        zz5A zz5A2 = this.zzWbn();
        return (zz5A)zz5A2.zzYvA();
    }

    final zzXXa zzb1() {
        zzXXa zzXXa2 = this.zzYpt();
        return (zzXXa)zzXXa2.zzYvA();
    }

    public boolean isAtStartOfParagraph() {
        if (this.getCurrentParagraph() == null) {
            return false;
        }
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzXPv(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzXPv().getNodeType() == 8;
    }

    public boolean isAtEndOfStructuredDocumentTag() {
        return this.zzYCj && this.zzXPv().getNodeType() == 28;
    }

    private void zzZAc(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            switch (((StructuredDocumentTag)this.zzXPv()).getLevel()) {
                case 2: {
                    this.insertParagraph();
                    bl = false;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot insert text at this cursor position.");
                }
            }
        }
        String string2 = zzY2Y.zzY2F(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzZwN(string2.substring(n4, n4 + n2));
                }
                switch (this.zzWCs) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzYgQ(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzZwN(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzau();
        if (this.zzMq() != null && this.zzMq().zzjW() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            this.getCurrentStructuredDocumentTag().appendChild(node);
            return;
        }
        this.zzXPv().zzYni(node);
    }

    final void zzZTI(int n) {
        this.zzXSC(true);
        this.zzXBK(n);
    }

    private void zzXBK(int n) {
        this.insertParagraph();
        zzWls zzWls2 = new zzWls(this.getDocument());
        try {
            zzWbn zzWbn2 = this.getCurrentSection().zzXy0();
            zzWbn zzWbn3 = (zzWbn)zzWbn2.zzYvA();
            Section section = new Section(this.zzYE7, zzWbn3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzYE7));
            this.zzYE7.insertAfter(section, this.getCurrentSection());
            section.getBody().zzWdb(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzWls2.dispose();
        }
    }

    final FieldStart zzXsC(int n) {
        this.zzau();
        return zzYzt.zzFH(n, this.zzZii(), this.zzY5x(), this.zzTb(), this.zzTb() == null);
    }

    final Run zzKt(String string) {
        return zzYzt.zzWdb(string, this.zzZii(), this.zzY5x(), this.zzTb(), this.zzTb() == null);
    }

    final FieldEnd zzZEq(int n, boolean bl) {
        return zzYzt.zzWdb(n, bl, this.zzZii(), this.zzY5x(), this.zzTb(), this.zzTb() == null);
    }

    final FieldSeparator zzXYm(int n) {
        return zzYzt.zzWdb(n, this.zzZii(), this.zzY5x(), this.zzTb(), this.zzTb() == null);
    }

    private FormField zzYTr(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzYE7, new zzWJL(), this.zzZii());
        CompositeNode compositeNode = node == null ? this.zzY5x() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzXSC(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzMq() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzVQi(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzZwN(String string) {
        if (this.zzVYS(string)) {
            zzWuZ zzWuZ2 = new zzWuZ(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzZRY zzZRY2 : zzWuZ2.zzXOx(this.getParagraphFormat().getBidi())) {
                zzZAc zzZAc2 = zzZAc.zzYz5(zzZRY2.zzmt());
                zzYUi zzYUi2 = this.zzZii();
                zzYUi2.zzYlo(265, zzZAc2);
                if (zzZRY2.zzYWM()) {
                    zzYUi2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzYE7, zzZRY2.getText(), zzYUi2);
                this.insertNode(run);
            }
            return;
        }
        this.zzYgQ(string);
    }

    private boolean zzVYS(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzWw0.zzZ7l(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzFH(zzYUi zzYUi2, boolean bl) {
        zzYUi zzYUi3;
        if (bl) {
            zzYUi zzYUi4 = zzYUi2;
            zzYUi3 = (zzYUi)zzYUi4.zzYvA();
        } else {
            zzYUi3 = zzYUi2;
        }
        this.zzVRJ = zzYUi3;
    }

    final void zzOx() {
        this.zzVRJ.clear();
    }

    final void zzXI5() {
        if (this.zzY5e() != null) {
            zzXXa zzXXa2;
            zzXXa zzXXa3 = zzXXa2 = this.zzY5e().zzYpt();
            this.zzWk9 = (zzXXa)zzXXa3.zzYvA();
            zzXXa2.zzWdb(this.zzWk9);
        }
    }

    private Shape zzFH(String string, boolean bl, boolean bl2, zzaX zzaX2, zzY2g zzY2g2) throws Exception {
        if (zzY2g2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        Shape shape = this.zzFH(zzaX2, bl2, zzY2g2, string);
        zzZeb zzZeb2 = zzXT.zzFH(string, bl, bl2, zzY2g2);
        return DocumentBuilder.zzFH(string, bl, shape, zzY2g2.zzZti, zzZeb2);
    }

    private Shape zzFH(String string, boolean bl, String string2, String string3, zzY2g zzY2g2) throws Exception {
        if (zzY2g2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string3 == null) {
            string3 = zzWbA.zzZmZ(string);
        }
        Shape shape = string2 != null ? this.zzYkW(string2, string3) : this.zzFH(null, string3, zzY2g2);
        zzZeb zzZeb2 = zzXT.zzFH(string, bl, true, zzY2g2);
        return DocumentBuilder.zzFH(string, bl, shape, zzY2g2.zzZti, zzZeb2);
    }

    private static Shape zzFH(String string, boolean bl, Shape shape, String string2, zzZeb zzZeb2) {
        if (shape == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: insertedOleImage");
        }
        shape.setShapeType(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzWdb(zzZeb2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzFH(zzaX zzaX2, boolean bl, zzY2g zzY2g2, String string) throws Exception {
        if (zzY2g2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (zzaX2 != null) {
            return this.zzWpU(zzaX2);
        }
        if (!bl) {
            return this.zzXZW(zzXT.zzB5().get("normal"));
        }
        String string2 = string != null ? zzWbA.zzZmZ(string) : zzXT.zzX1I(zzY2g2.zzXid);
        return this.zzFH(zzY2g2, string2);
    }

    private Shape zzFH(String string, String string2, zzY2g zzY2g2) throws Exception {
        if (zzY2g2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string2 == null) {
            string2 = zzXT.zzX1I(zzY2g2.zzXid);
        }
        if (string != null) {
            return this.zzYkW(string, string2);
        }
        return this.zzFH(zzY2g2, string2);
    }

    private Shape zzFH(zzY2g zzY2g2, String string) throws Exception {
        if (zzY2g2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        byte[] byArray = zzXT.zzWoT(zzY2g2.zzXid);
        zzxu zzxu2 = new zzxu(byArray, null, string, this.getDocument().zzWJh());
        return this.zzXZW(zzxu2.zzZb5());
    }

    private Shape zzYkW(String string, String string2) throws Exception {
        zzxu zzxu2 = new zzxu(string, string2, this.getDocument().zzWJh());
        return this.zzXZW(zzxu2.zzZb5());
    }

    private Shape zzWpU(zzaX zzaX2) throws Exception {
        byte[] byArray = zzXT6.zzYVE(zzaX2);
        return this.zzXZW(byArray);
    }

    private Shape zzXZW(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzYE7, 1);
        shape.setShapeType(75);
        shape.zzWdb(this.zzZii());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzZ8(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzFH(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzWdb(compositeNode, n);
            return;
        }
        this.zzZCJ(compositeNode, n);
    }

    private void zzWdb(CompositeNode compositeNode, int n) {
        zzXtn zzXtn2 = zzXtn.zzZAc(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            int n2;
            int n3;
            zzXtn2.zzFH(null, true, true, true, false, true);
            node = zzXtn2.getNode();
            if (zzXtn2.zzYNG() && (!node.isComposite() || node.zzXBY() != 6 || n != 0)) continue;
            int n4 = n3 = node.isComposite() ? ((CompositeNode)node).zzYNN().length() : node.getTextLength();
            if (!zzXtn2.zzYNG() && n3 == 0 && node.isComposite() && node != compositeNode || (n2 = n) != 0 && (n -= n3) >= 0) continue;
            if (!zzXtn2.zzYNG() && node == compositeNode && compositeNode.getNodeType() == 28) {
                this.zzFH((StructuredDocumentTag)compositeNode);
                return;
            }
            this.zzFH(null, node);
            this.zzXMH = n2;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzFH(StructuredDocumentTag structuredDocumentTag) {
        this.zzjw(structuredDocumentTag);
        this.zzYCj = true;
        this.zzXMH = 0;
        zzYUi zzYUi2 = structuredDocumentTag.zzXsa();
        switch (structuredDocumentTag.zzXBY()) {
            case 6: {
                Node node;
                for (node = structuredDocumentTag.zzH8(); node != null && !(node instanceof Inline); node = node.getPreviousSibling()) {
                }
                if (node == null) break;
                zzYUi2 = ((Inline)node).zzYFY();
                break;
            }
            case 3: {
                Paragraph paragraph = (Paragraph)structuredDocumentTag.getChild(8, -1, true);
                if (paragraph == null) break;
                zzYUi2 = paragraph.zzXcb();
                break;
            }
            default: {
                return;
            }
        }
        this.zzFH(zzYUi2, true);
    }

    private void zzZCJ(CompositeNode compositeNode, int n) {
        zzXtn zzXtn2 = zzXtn.zzNu(compositeNode);
        while (zzXtn2.getNode() != compositeNode || !zzXtn2.zzYNG()) {
            int n2;
            Node node = zzXtn2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzYNN().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzFH(null, node);
                this.zzXMH = n;
                return;
            }
            while (zzXtn2.zzFH(null, false, true, true, false, true) && zzXtn2.zzYNG() && zzXtn2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzau() {
        int n = this.zzXMH;
        if (n == 0) {
            return;
        }
        this.zzXMH = 0;
        Run run = zzXT6.zzFH((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzZGx(n);
        }
    }

    private Run zzYgQ(String string) {
        Run run = new Run(this.zzYE7, string, this.zzZii());
        this.insertNode(run);
        return run;
    }

    final boolean zz8c() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzZRf() {
        return this.zzWCs;
    }

    final void zzYNE(int n) {
        this.zzWCs = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzXPv();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzXPv();
        }
        return (Paragraph)this.zzXPv().getAncestor(8);
    }

    public StructuredDocumentTag getCurrentStructuredDocumentTag() {
        if (this.isAtEndOfStructuredDocumentTag()) {
            return (StructuredDocumentTag)this.zzXPv();
        }
        return (StructuredDocumentTag)this.zzXPv().getAncestor(28);
    }

    public Story getCurrentStory() {
        return (Story)this.zzXPv().getAncestor(Story.class);
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzW2H zzMq() {
        zzZ9C<zzW2H> zzZ9C2 = this.zzTE;
        if (zzZ9C2.size() > 0) {
            return (zzW2H)this.zzTE.peek();
        }
        return null;
    }

    private Cell zzY5e() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzXUU();
    }

    private CompositeNode zzY5x() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return (CompositeNode)this.zzXPv();
        }
        return this.zzXPv().getParentNode();
    }

    private Node zzTb() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzXPv();
    }

    private zzZ9C<zzYUi> zzZiy() {
        if (this.zzYmD == null) {
            this.zzYmD = new zzZ9C();
        }
        return this.zzYmD;
    }

    private zzZ9C<zzWZb> zzap() {
        if (this.zzY8Z == null) {
            this.zzY8Z = new zzZ9C();
        }
        return this.zzY8Z;
    }

    private zzZ9C<zzFH> zzW7s() {
        if (this.zzyB == null) {
            this.zzyB = new zzZ9C();
        }
        return this.zzyB;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzVRJ.zzXZ6(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int key, int revisionsView) {
        return this.zzVRJ.zzYPK(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzDm(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzDm(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzVRJ.zzYlo(fontAttr, value);
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzGp()) {
            this.getCurrentParagraph().zzXcb().zzYlo(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzVRJ.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzVRJ.clear();
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzGp()) {
            this.getCurrentParagraph().zzXcb().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key) {
        return this.zzWMN().zzXZ6(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key, int revisionsView) {
        return this.zzWMN().zzYPK(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedParaAttr(int key) {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzYLZ(key, 0);
        }
        return this.getDocument().getStyles().zztG().zzWcp(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchParaAttr(int key) {
        DocumentBuilder documentBuilder = this;
        Object object = documentBuilder.getDirectParaAttr(key);
        if (object != null) {
            return object;
        }
        return documentBuilder.fetchInheritedParaAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setParaAttr(int key, Object value) {
        if (this.getCurrentParagraph() != null) {
            this.getCurrentParagraph().setParaAttr(key, value);
            return;
        }
        this.zzWMN().zzYlo(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeParaAttr(int key) {
        this.zzWMN().remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearParaAttrs() {
        this.zzWMN().clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzWbn().zzXZ6(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzWbn().zzWcp(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzWbn().zzYmk(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzWbn().zzYlo(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzWbn().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzWbn().clear();
        zz5A.zzX0Y().zzWdb(this.zzWbn());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzYpt().zzXZ6(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzYpt().zzWcp(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzYpt().zzYmk(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzXT6.zzFH(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzY5e() != null ? this.zzY5e().getCellFormat() : this.getCellFormat();
            border.zzFH(cellFormat);
        }
        this.zzYpt().zzYlo(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzYpt().clear();
    }

    private Node zzXPv() {
        Node node = this.zzX6U != null && this.zzX6U.getParentNode() == null ? this.zzWlU : this.zzX6U;
        if (node != null && node.zzXBY() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        this.zzYCj = this.zzYCj && node != null && node.getNodeType() == 28;
        return node;
    }

    private void zzjw(Node node) {
        this.zzX6U = node;
        if (this.zzX6U != null) {
            this.zzWlU = this.zzX6U.getParentNode();
        }
        this.zzYCj = false;
    }

    private zzWZb zzWMN() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzWMN();
        }
        if (this.zzZCI == null) {
            this.zzZCI = new zzWZb();
        }
        return this.zzZCI;
    }

    private zz5A zzWbn() {
        if (this.zzMq() != null && this.zzMq().zzjW() == 1) {
            return this.zzXsV;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzWbn();
        }
        return this.zzXsV;
    }

    private zzXXa zzYpt() {
        if (this.zzMq() != null && this.zzMq().zzjW() != 3) {
            return this.zzWk9;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzXUU().zzYpt();
        }
        return this.zzWk9;
    }

    static final class zzFH {
        private zzYUi zzVRJ;
        private zzYUi zzXPB;

        public zzFH(zzYUi zzYUi2, zzYUi zzYUi3) {
            this.zzVRJ = zzYUi2;
            this.zzXPB = zzYUi3;
        }

        public final zzYUi zzYFY() {
            return this.zzVRJ;
        }

        public final zzYUi zzYVf() {
            return this.zzXPB;
        }
    }
}

