/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zz7m;
import com.aspose.words.internal.zzNc;
import com.aspose.words.internal.zzVYF;
import com.aspose.words.internal.zzWay;
import com.aspose.words.internal.zzXT6;
import com.aspose.words.internal.zzXV9;
import com.aspose.words.internal.zzXyK;
import com.aspose.words.internal.zzYeI;
import com.aspose.words.internal.zzZ27;
import com.aspose.words.internal.zzZ58;
import com.aspose.words.internal.zzaX;
import com.aspose.words.internal.zzcF;
import com.aspose.words.zzW2J;
import com.aspose.words.zzWDk;
import com.aspose.words.zzXN2;
import com.aspose.words.zzXj7;
import com.aspose.words.zzXqJ;
import com.aspose.words.zzYSJ;
import com.aspose.words.zzYma;
import com.aspose.words.zzZ0q;
import com.aspose.words.zzZEs;
import com.aspose.words.zzZIe;
import com.aspose.words.zzZJn;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzFH(zzaX zzaX2, zzaX zzaX3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzXT6.zzWdb((Object)zzaX2, "srcStream");
        zzXT6.zzWdb((Object)zzaX3, "dstStream");
        zzXT6.zzWdb((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzWdb(zzaX2, zzaX3, certificateHolder, signOptions);
        zzaX3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzFH(zzaX.zzWdb(srcStream), (zzaX)zzaX.zzZCJ(dstStream), certHolder, signOptions);
    }

    private static void zzWdb(zzaX zzaX2, zzaX zzaX3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzZCJ(digitalSignature);
        }
        if (zzZ0q.zzby(zzaX2)) {
            DigitalSignatureUtil.zzFH(zzaX2, zzaX3, digitalSignature, true);
            return;
        }
        zzZ0q zzZ0q2 = new zzZ0q();
        zzaX zzaX4 = zzaX2;
        zzZ0q zzZ0q3 = zzZ0q2;
        FileFormatInfo fileFormatInfo = zzZ0q2.zzWdb(zzaX4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zz7m zz7m2 = new zz7m(zzaX2);
                int n = fileFormatInfo.zzZU4() == 1 ? 1 : 2;
                zzXqJ.zzFH(zz7m2, digitalSignature, n);
                zzaX3.zz7h(0L);
                zz7m2.zzZBH(zzaX3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzFH(fileFormatInfo.zzsy(), zzaX3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzFH(zzaX2, zzaX3, digitalSignature, false);
                return;
            }
            case 60: 
            case 61: {
                DigitalSignatureUtil.zzFH(zzaX2, zzaX3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzXT6.zzZCJ(srcFileName, "srcFileName");
        zzXT6.zzZCJ(dstFileName, "dstFileName");
        try (zzWay zzWay2 = zzXT6.zzWdb(srcFileName, 3, 1);){
            try (zzWay zzWay3 = zzXT6.zzWdb(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzFH((zzaX)zzWay2, (zzaX)zzWay3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzNc zzNc2 = zzaX.zzZCJ(dstStream);
        zzaX zzaX2 = zzaX.zzWdb(srcStream);
        DigitalSignatureUtil.zzFH(zzaX2, (zzaX)zzNc2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzWay zzWay2 = zzXT6.zzWdb(srcFileName, 3, 1);){
            try (zzWay zzWay3 = zzXT6.zzWdb(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzWDH(zzWay2, zzWay3);
            }
            return;
        }
    }

    private static void zzWDH(zzaX zzaX2, zzaX zzaX3) throws Exception {
        zzZ0q zzZ0q2 = new zzZ0q();
        zzaX zzaX4 = zzaX2;
        Object object = zzZ0q2;
        FileFormatInfo fileFormatInfo = zzZ0q2.zzWdb(zzaX4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zz7m zz7m2 = new zz7m(zzaX2);
                zz7m2.zzYLt().zzWNU("_xmlsignatures");
                zz7m2.zzYLt().zzWNU("_signatures");
                zzaX3.zzX75(0L);
                zz7m2.zzZBH(zzaX3);
                zzaX zzaX5 = zzaX3;
                zzaX5.zz7h(zzaX5.zzXje());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzZ58 zzZ582 = new zzZ58(zzaX2);
                zzXyK zzXyK2 = zzZ582.zzFH(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzXyK2 != null) {
                    for (zzXV9 zzXV92 : zzXyK2.zzYVk()) {
                        String string = zzXyK2.zzFH(zzXV92);
                        zzZ582.zzmb().remove(string);
                    }
                    zzZ582.zzmb().remove(zzXyK2.getName());
                    zzXV9 zzXV93 = zzZ582.zzYVk().zzVQi("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzZ582.zzYVk().remove(zzXV93.getId());
                    zzZ582.zzX5F();
                }
                zzaX3.zzX75(0L);
                zzZ582.zzZBH(zzaX3);
                zzaX zzaX6 = zzaX3;
                zzaX6.zz7h(zzaX6.zzXje());
                return;
            }
            case 60: 
            case 61: {
                zzXN2 zzXN22 = new zzXN2(zzaX2);
                zzYma zzYma2 = zzXN22.zzWYd("/META-INF/documentsignatures.xml");
                if (zzYma2 != null) {
                    zzXN22.zzXWM().remove(zzYma2.getName());
                }
                zzaX3.zzX75(0L);
                String string = "application/vnd.oasis.opendocument.text";
                zzaX4 = zzaX3;
                object = zzXN22;
                ((zzXN2)object).zzFH(zzaX4, string, null);
                zzaX zzaX7 = zzaX3;
                zzaX7.zz7h(zzaX7.zzXje());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzWDH(zzaX.zzWdb(srcStream), zzaX.zzZCJ(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzWay zzWay2 = zzXT6.zzWdb(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzZzH(zzWay2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzZzH(zzaX zzaX2) throws Exception {
        if (zzZ0q.zzby(zzaX2)) {
            return DigitalSignatureUtil.zzWMJ(zzaX2);
        }
        zzZ0q zzZ0q2 = new zzZ0q();
        zzaX zzaX3 = zzaX2;
        zzZ0q zzZ0q3 = zzZ0q2;
        FileFormatInfo fileFormatInfo = zzZ0q2.zzWdb(zzaX3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzaX2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzZzH(zzaX.zzWdb(stream));
    }

    static zzZ27 zzFH(zz7m zz7m2, String string) throws Exception {
        zzW2J zzW2J2 = new zzW2J(zz7m2);
        if (zzW2J2.zzXfj()) {
            zzZ27 zzZ272 = zzW2J2.zzZW8(string);
            return zzZ272;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzYDe(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzcF.zzWdb("Unexpected digest algorithm: {0}.", n));
    }

    static String zzWEo(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzYDe(n);
    }

    private static void zzFH(zzaX zzaX2, zzaX zzaX3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzZ58 zzZ582 = new zzZ58(zzaX2);
        zzXj7 zzXj72 = bl ? new zzWDk(zzZ582) : new zzZEs(zzZ582);
        zzXj72.zzWdb(digitalSignature);
        zzaX3.zz7h(0L);
        zzZ582.zzZBH(zzaX3);
    }

    private static void zzFH(zzaX zzaX2, zzaX zzaX3, DigitalSignature digitalSignature) throws Exception {
        zzXN2 zzXN22 = new zzXN2(zzaX2);
        zzZJn zzZJn2 = new zzZJn(zzXN22);
        zzZJn2.zzWdb(digitalSignature);
        zzaX3.zz7h(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzaX zzaX4 = zzaX3;
        zzXN2 zzXN23 = zzXN22;
        zzXN23.zzFH(zzaX4, string, null);
    }

    private static void zzFH(zz7m zz7m2, zzaX zzaX2, DigitalSignature digitalSignature, String string) throws Exception {
        zzZ27 zzZ272 = DigitalSignatureUtil.zzFH(zz7m2, string);
        zzZ27 zzZ273 = new zzZ27();
        DigitalSignatureUtil.zzFH((zzaX)zzZ272, (zzaX)zzZ273, digitalSignature, false);
        zz7m zz7m3 = zzW2J.zzWDH(zzZ273, string);
        zz7m3.zzZBH(zzaX2);
    }

    private static DigitalSignatureCollection zzWMJ(zzaX zzaX2) throws Exception {
        zzaX2.zzX75(0L);
        zzZ58 zzZ582 = new zzZ58(zzaX2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzXyK zzXyK2 = zzZ582.zzFH(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzXyK2 != null) {
            for (zzXV9 zzXV92 : zzXyK2.zzYVk()) {
                String string = zzXyK2.zzFH(zzXV92);
                zzXyK zzXyK3 = zzZ582.zzZRO(string);
                zzXyK zzXyK4 = zzZ582.zzFH(zzXyK3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzVYF zzVYF2 = zzYeI.zzWXy(zzXyK4.zzAC().zzXzP());
                zzZIe.zzFH(zzXyK3.zzYam(), zzVYF2, new zzYSJ(zzZ582), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

