/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzXT6;
import com.aspose.words.zzGG;
import com.aspose.words.zzVR9;
import com.aspose.words.zzWls;
import com.aspose.words.zzWwc;
import com.aspose.words.zzY8E;
import com.aspose.words.zzYUg;
import com.aspose.words.zzYzt;
import com.aspose.words.zzZ2p;
import com.aspose.words.zzZEX;
import java.util.Iterator;

public abstract class CompositeNode<V extends Node>
extends Node
implements zzYUg,
Iterable<V> {
    private Node zzXNK;
    private Node zzXpS;
    private Node zzYM;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        zzY8E zzY8E2 = new zzY8E(this.getDocument());
        try {
            while (this.hasChildNodes()) {
                this.getParentNode().insertAfter(this.getLastChild(), this);
            }
            this.getParentNode().zzZCJ(this, true);
            return;
        }
        finally {
            zzY8E2.dispose();
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzXQY() {
        return this.zzRZ() != null;
    }

    final boolean zzYe8() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzIM() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzWwc) {
                return true;
            }
            CompositeNode compositeNode = zzXT6.zzFH((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzIM()) continue;
            return true;
        }
        return false;
    }

    public Node getFirstChild() {
        return this.zzXNK;
    }

    public Node getLastChild() {
        return this.zzXpS;
    }

    final Node zzRZ() {
        return zzYzt.zzWn8(this.getFirstChild(), false);
    }

    final Node zzWi5() {
        return zzYzt.zzYOi(this.getLastChild(), false);
    }

    final CompositeNode zzZ4d() {
        return (CompositeNode)zzYzt.zzWn8(this.getFirstChild(), true);
    }

    final CompositeNode zzWT0() {
        return (CompositeNode)zzYzt.zzYOi(this.getLastChild(), true);
    }

    final Node zzZi5() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzYzt.zzYNu((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzH8() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzYzt.zzYNu((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzFH(boolean bl, zzGG zzGG2) {
        CompositeNode compositeNode = (CompositeNode)super.zzFH(bl, zzGG2);
        ((CompositeNode)super.zzFH(bl, zzGG2)).zzXpS = null;
        compositeNode.zzXNK = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzW4B(node.zzFH(true, zzGG2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzSC(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzSC(StringBuilder stringBuilder) {
        this.zzZBH(stringBuilder);
        zzXT6.zzWdb(stringBuilder, this.zzYNN());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzWdb(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, bl);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzYzt.zzWy1(nodeType);
            Node node2 = node = bl ? this.zzRZ() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzXnY() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzVR9.zzZCJ(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzVR9.zzWO6(this, xpath);
    }

    @Override
    public Iterator<V> iterator() {
        return new zzZ2p(this);
    }

    public <T extends Node> T appendChild(T newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public <T extends Node> T prependChild(T newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public <T extends Node> T insertAfter(T newChild, Node refChild) {
        return this.zzFH(newChild, refChild, true);
    }

    public <T extends Node> T insertBefore(T newChild, Node refChild) {
        return this.zzFH(newChild, refChild, false);
    }

    public <T extends Node> T removeChild(T oldChild) {
        return this.zzZCJ(oldChild, false);
    }

    private <T extends Node> T zzZCJ(T t, boolean bl) {
        if (t == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oldChild");
        }
        if (t.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = zzYzt.zzFH(documentBase, t, (Node)this, null, 1);
        DocumentBase documentBase2 = documentBase;
        if (documentBase2.zzYxT() && zzYzt.zzZCK(t)) {
            return t;
        }
        zzYzt.zzFH(documentBase, nodeChangingArgs);
        if (!bl && zzYzt.zzcQ(t)) {
            zzYzt.zzX2I(t, false);
        }
        T t2 = this.zz7h(t);
        zzYzt.zzWdb(documentBase, nodeChangingArgs);
        return t2;
    }

    public void removeAllChildren() {
        zzZEX.zzWW1(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzW4B(Node node) {
        node.getParentNode();
        if (this.zzXpS == null) {
            node.zzZRi(null);
            node.zzWta(null);
            this.zzXNK = node;
        } else {
            node.zzZRi(this.zzXpS);
            node.zzWta(null);
            this.zzXpS.zzWta(node);
        }
        this.zzXpS = node;
        node.zzg(this);
        return node;
    }

    final void zzFH(Node node, Node node2, Node node3) {
        this.zzFH(node, node2, node3, false);
    }

    final void zzFH(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzWlq(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzWdb(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzWO6(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzYzt.zzYNu(node3.getNodeType())) continue;
            if (zzYzt.zzWlq(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzYNN().length();
    }

    String zzYNN() {
        return "";
    }

    final String zzZkb() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzZBH(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzZBH(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzSC(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.acceptStart(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.acceptEnd(visitor));
    }

    public abstract int acceptStart(DocumentVisitor var1) throws Exception;

    public abstract int acceptEnd(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    boolean zzWlq(Node node) {
        return true;
    }

    final <T extends Node> T zzFH(T t, Node node, boolean bl) {
        Object object;
        if (node != null && node.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (t == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (t == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzEs(t)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (t == node) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = t.getDocument();
        zzYzt.zzWdb(documentBase, documentBase2);
        if (t.getNodeType() != 37 && !this.zzWlq(t)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = t.getParentNode();
        Node node2 = t.getNextSibling();
        if (compositeNode != null) {
            object = new zzWls(documentBase);
            try {
                compositeNode.zzZCJ(t, true);
            }
            finally {
                ((zzWls)object).dispose();
            }
        }
        object = zzYzt.zzFH(documentBase, t, null, (Node)this, 0);
        zzYzt.zzFH(documentBase, (NodeChangingArgs)object);
        if (this.zzXpS == null) {
            t.zzZRi(null);
            t.zzWta(null);
            this.zzXNK = t;
            this.zzXpS = t;
        } else if (bl) {
            if (node != null) {
                this.zzWdb(t, node);
            } else {
                this.zzZCJ(t, this.zzXNK);
            }
        } else if (node != null) {
            this.zzZCJ(t, node);
        } else {
            this.zzWdb(t, this.zzXpS);
        }
        t.zzg(this);
        zzYzt.zzWdb(documentBase, (NodeChangingArgs)object);
        DocumentBase documentBase3 = documentBase;
        if (documentBase3.zzYxT()) {
            zzYzt.zzFH(t, compositeNode, node2);
        }
        return t;
    }

    private void zzWdb(Node node, Node node2) {
        Node node3 = node2.zzYlT();
        node.zzZRi(node2);
        node.zzWta(node3);
        node2.zzWta(node);
        if (node3 == null) {
            this.zzXpS = node;
            return;
        }
        node3.zzZRi(node);
    }

    private void zzZCJ(Node node, Node node2) {
        Node node3 = node2.zzZZw();
        node.zzZRi(node3);
        node.zzWta(node2);
        node2.zzZRi(node);
        if (node3 == null) {
            this.zzXNK = node;
            return;
        }
        node3.zzWta(node);
    }

    private <T extends Node> T zz7h(T t) {
        if (t == this.zzXNK) {
            if (this.zzXNK == this.zzXpS) {
                this.zzXNK = null;
                this.zzXpS = null;
            } else {
                this.zzXNK = t.zzYlT();
                this.zzXNK.zzZRi(null);
            }
        } else {
            Node node = t.zzZZw();
            Node node2 = t.zzYlT();
            node.zzWta(node2);
            if (node2 == null) {
                this.zzXpS = node;
            } else {
                node2.zzZRi(node);
            }
        }
        t.zzWta(null);
        t.zzZRi(null);
        t.zzg(null);
        return t;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzYM = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzYM;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

