/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CommentCollection;
import com.aspose.words.CommentRangeEnd;
import com.aspose.words.CommentRangeStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.InlineStory;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SpecialChar;
import com.aspose.words.internal.zzXT6;
import com.aspose.words.internal.zzYYU;
import com.aspose.words.internal.zzYqW;
import com.aspose.words.zzHt;
import com.aspose.words.zzYUi;
import com.aspose.words.zzYni;
import com.aspose.words.zzZ45;
import com.aspose.words.zzZBz;
import com.aspose.words.zzZgF;
import java.util.ArrayList;
import java.util.Date;

public final class Comment
extends InlineStory
implements zzZ45,
zzZBz {
    private int zztA;
    private boolean zzVR7;
    private boolean zzZrp;
    private int zzNG;
    private int zzXJW = -1;
    private String zzYG1 = "";
    private String zzX0Q = "";
    private zzYYU zzXZV = zzYYU.zzWLJ;
    private zzYYU zzYLe = zzYYU.zzWLJ;
    private CommentCollection zzZKE;

    Comment(DocumentBase doc, zzYUi runPr) {
        super(doc, runPr);
        this.zzNG = doc.zzZKb();
    }

    public Comment(DocumentBase doc) {
        this(doc, "", "", zzYYU.zzWLJ);
    }

    private Comment(DocumentBase doc, String author, String initial, zzYYU dateTime) {
        this(doc, new zzYUi());
        this.setAuthor(author);
        this.setInitial(initial);
        zzYYU zzYYU2 = dateTime;
        Comment comment = this;
        this.zzXZV = zzYYU2;
        this.getFont().setStyleIdentifier(39);
    }

    public Comment(DocumentBase doc, String author, String initial, Date dateTime) {
        this(doc, author, initial, zzYYU.zzFH(dateTime));
    }

    @Override
    public final int getNodeType() {
        return 19;
    }

    @Override
    public final int getStoryType() {
        return 4;
    }

    public final int getId() {
        return this.zzNG;
    }

    public final void setId(int value) {
        this.zzNG = value;
        if (this.getDocument() != null) {
            this.getDocument().zzXlg();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getIdInternal() {
        return this.getId();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setIdInternal(int value) {
        this.setId(value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getParentIdInternal() {
        return this.getParentId();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setParentIdInternal(int value) {
        this.setParentId(value);
    }

    public final String getInitial() {
        return this.zzYG1;
    }

    public final void setInitial(String value) {
        zzXT6.zzWdb((Object)value, "Initial");
        this.zzYG1 = value;
    }

    public final Date getDateTime() {
        Comment comment = this;
        return zzYYU.zzX2I(comment.zzXZV);
    }

    private void zzjw(zzYYU zzYYU2) {
        this.zzXZV = zzYYU2;
        if (!zzYYU.zzFH(this.zzYLe, zzYYU.zzWLJ)) {
            this.zzYLe = !zzYYU.zzFH(zzYYU2, zzYYU.zzWLJ) ? zzYYU2.zzVZu() : zzYYU.zzWLJ;
        }
    }

    public final void setDateTime(Date value) {
        this.zzjw(zzYYU.zzFH(value));
    }

    final zzYYU zzYXi() {
        return this.zzXZV;
    }

    final void zzIg(zzYYU zzYYU2) {
        this.zzXZV = zzYYU2;
    }

    final zzYYU zzXs2() {
        return this.zzYLe;
    }

    final void zzXdu(zzYYU zzYYU2) {
        this.zzYLe = zzYYU2;
    }

    public final String getAuthor() {
        return this.zzX0Q;
    }

    public final void setAuthor(String value) {
        zzXT6.zzWdb((Object)value, "Author");
        this.zzX0Q = value;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    private Comment zzFH(String string, String string2, zzYYU zzYYU2, String string3) throws Exception {
        if (this.getParentId() != -1) {
            throw new IllegalStateException("Cannot add a reply to another reply.");
        }
        if (this.getParentNode() == null) {
            throw new IllegalStateException("No parent node.");
        }
        Comment comment = new Comment(this.getDocument(), string, string2, zzYYU2);
        comment.setIdInternal(zzYni.zzFH(this.getDocument()));
        comment.setParentId(this.zzNG);
        comment.setText(string3);
        Comment comment2 = this;
        Comment comment3 = zzXT6.zzFH((Object)this.zzZFs(), Comment.class);
        while (comment3 != null && comment3.getParentId() == this.zzNG) {
            comment2 = comment3;
            comment3 = zzXT6.zzFH((Object)comment3.zzZFs(), Comment.class);
        }
        this.getParentNode().insertAfter(comment, comment2);
        zzHt zzHt2 = new zzHt();
        if (zzHt2.zzWdb(this.getDocument(), this.zzNG)) {
            this.zzFH(zzHt2.zzKr(), new CommentRangeStart(this.getDocument(), comment.getId()));
            this.zzFH(zzHt2.zzWpj(), new CommentRangeEnd(this.getDocument(), comment.getId()));
        }
        return comment;
    }

    public final Comment addReply(String author, String initial, Date dateTime, String text) throws Exception {
        return this.zzFH(author, initial, zzYYU.zzFH(dateTime), text);
    }

    private void zzFH(CommentRangeStart commentRangeStart, CommentRangeStart commentRangeStart2) {
        Node node2;
        ArrayList arrayList = new ArrayList();
        for (Node node2 : this.getReplies()) {
            zzYqW.zzFH(arrayList, Integer.valueOf(node2.getId()));
        }
        Object object = commentRangeStart;
        while (((Node)object).getNextSibling() != null && ((Node)(node2 = ((Node)object).getNextSibling())).getNodeType() == 33 && arrayList.contains(((CommentRangeStart)node2).getId())) {
            object = node2;
        }
        ((Node)object).zzW7g(commentRangeStart2);
    }

    private void zzFH(CommentRangeEnd commentRangeEnd, CommentRangeEnd commentRangeEnd2) {
        ArrayList arrayList = new ArrayList();
        for (Node node : this.getReplies()) {
            if (((Comment)node).getId() == commentRangeEnd2.getId()) continue;
            zzYqW.zzFH(arrayList, Integer.valueOf(((Comment)node).getId()));
        }
        Object object = commentRangeEnd;
        while (((Node)object).getNextSibling() != null) {
            int n;
            Node node;
            node = ((Node)object).getNextSibling();
            if (node.getNodeType() == 34) {
                n = ((CommentRangeEnd)node).getId();
            } else {
                if (node.getNodeType() != 19) break;
                n = ((Comment)node).getId();
            }
            if (!arrayList.contains(n) && n != this.zzNG) break;
            object = node;
        }
        ((Node)object).zzW7g(commentRangeEnd2);
    }

    public final void removeReply(Comment reply) throws Exception {
        zzHt zzHt2 = new zzHt();
        if (zzHt2.zzWdb(this.getDocument(), reply.getId())) {
            zzHt2.zzKr().remove();
            zzHt2.zzWpj().remove();
        }
        reply.remove();
    }

    public final void removeAllReplies() throws Exception {
        for (Comment comment : this.getReplies().zzXgW()) {
            this.removeReply(comment);
        }
    }

    @Override
    public final int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitCommentStart(this);
    }

    @Override
    public final int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitCommentEnd(this);
    }

    public final void setText(String text) {
        this.removeAllChildren();
        Paragraph paragraph = new Paragraph(this.getDocument());
        paragraph.getParagraphFormat().setStyleIdentifier(30);
        this.appendChild(paragraph);
        DocumentBuilder documentBuilder = new DocumentBuilder(this.zzWZm());
        documentBuilder.moveTo(paragraph);
        SpecialChar specialChar = new SpecialChar(this.zzWZm(), '\u0005', new zzYUi());
        specialChar.getFont().setStyleIdentifier(39);
        documentBuilder.insertNode(specialChar);
        documentBuilder.write(text);
    }

    public final Comment getAncestor() {
        if (this.getDocument() == null || this.getParentId() == -1) {
            return null;
        }
        for (Comment comment : this.getDocument().getChildNodes(19, true)) {
            if (comment.getId() != this.getParentId()) continue;
            return comment;
        }
        return null;
    }

    public final CommentCollection getReplies() {
        if (this.zzZKE == null) {
            this.zzZKE = new CommentCollection(this.getDocument(), this);
        }
        return this.zzZKE;
    }

    public final boolean getDone() {
        return this.zzZrp;
    }

    public final void setDone(boolean value) {
        this.zzZrp = value;
    }

    public final int getParentId() {
        return this.zzXJW;
    }

    public final void setParentId(int value) {
        this.zzXJW = value;
        if (this.getDocument() != null) {
            this.getDocument().zzXlg();
        }
    }

    final int zzXJU() {
        return this.zztA;
    }

    final void zzXDF(int n) {
        this.zztA = n;
    }

    final boolean zzY83() {
        return this.zzVR7;
    }

    final void zzwg(boolean bl) {
        this.zzVR7 = bl;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzZgF getMoveFromRevision() {
        return this.zzYFY().getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveFromRevision(zzZgF value) {
        zzZgF zzZgF2 = value;
        zzYUi zzYUi2 = this.zzYFY();
        zzYUi2.zzYlo(13, zzZgF2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzZgF getMoveToRevision() {
        return this.zzYFY().getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveToRevision(zzZgF value) {
        zzZgF zzZgF2 = value;
        zzYUi zzYUi2 = this.zzYFY();
        zzYUi2.zzYlo(15, zzZgF2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void removeMoveRevisions() {
        this.zzYFY().remove(13);
        this.zzYFY().remove(15);
    }

    final String zzZRK() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzSC(stringBuilder);
        if (stringBuilder.length() > 0 && stringBuilder.charAt(0) == '\u0005') {
            stringBuilder.delete(0, 1);
        }
        return stringBuilder.toString();
    }
}

