/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartDataPointCollection;
import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzYYU;
import com.aspose.words.zzEA;
import com.aspose.words.zzLw;
import com.aspose.words.zzRD;
import com.aspose.words.zzW48;
import com.aspose.words.zzWHC;
import com.aspose.words.zzXQL;
import com.aspose.words.zzY35;
import com.aspose.words.zzYgQ;
import com.aspose.words.zzYzt;
import com.aspose.words.zzZ9w;
import com.aspose.words.zzwm;
import com.aspose.words.zzzU;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzY35 zzWBe;

    ChartSeriesCollection(zzY35 chartSpace) {
        this.zzWBe = chartSpace;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzqM().zzXPM().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzqM().zzXPM().iterator();
    }

    public void removeAt(int index) {
        this.zzqM().zzVVp(index);
    }

    public void clear() {
        this.zzqM().zzXe6();
        for (zzWHC zzWHC2 : this.zzWBe.zzZmA()) {
            zzWHC2.zzZFx(false);
        }
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzFH(chartSeriesCollection.zzqM().zzXJn(), seriesName, categories, values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzFH(chartSeriesCollection.zzqM().zzXJn(), seriesName, xValues, yValues);
    }

    private ChartSeries zzFH(String string, zzYYU[] zzYYUArray, double[] dArray) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzFH(chartSeriesCollection.zzqM().zzXJn(), string, zzYYUArray, dArray);
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzFH(seriesName, zzYYU.zzFH(dates), values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzFH(chartSeriesCollection.zzqM().zzXJn(), seriesName, xValues, yValues, bubbleSizes);
    }

    final ChartSeries zzFH(zzWHC zzWHC2, String string, String[] stringArray, double[] dArray) {
        if (stringArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (stringArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (stringArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzFH(zzWHC2, string, dArray);
        chartSeries.zzWTK().zzWDH(ChartSeriesCollection.zzXWE(stringArray));
        return chartSeries;
    }

    final ChartSeries zzFH(zzWHC zzWHC2, String string, double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzFH(zzWHC2, string, dArray2);
        chartSeries.zzWTK().zzWDH(ChartSeriesCollection.zzWlq(dArray));
        return chartSeries;
    }

    private ChartSeries zzFH(zzWHC zzWHC2, String string, zzYYU[] zzYYUArray, double[] dArray) {
        if (zzYYUArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzYYUArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzYYUArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzFH(zzWHC2, string, dArray);
        chartSeries.zzWTK().zzWDH(ChartSeriesCollection.zzFH(zzYYUArray));
        if (!zzWHC2.zzZlK()) {
            zzWHC2.zzZFx(true);
        }
        return chartSeries;
    }

    final ChartSeries zzFH(zzWHC zzWHC2, String string, double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (zzWHC2.zzRE() != 15) {
            zzWHC2.zzFw(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzFH(zzWHC2, string, dArray2);
        chartSeries.zzY5G().zzuz().zzF(3, chartSeries.zzY09().zzYFa());
        chartSeries.zzWTK().zzWDH(ChartSeriesCollection.zzWlq(dArray));
        if (dArray3 != null) {
            chartSeries.zzXTy().zzWDH(ChartSeriesCollection.zzWlq(dArray3));
        }
        return chartSeries;
    }

    private ChartSeries zzFH(zzWHC zzWHC2, String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(zzWHC2);
        chartSeries.setName(string);
        ChartSeriesCollection.zzYOi(chartSeries);
        chartSeries.zzY9q().zzWDH(ChartSeriesCollection.zzWlq(dArray));
        this.zzWBe.zzWTE();
        this.zzqM().zzZBH(chartSeries);
        return chartSeries;
    }

    private static void zzYOi(ChartSeries chartSeries) {
        chartSeries.zzY5G().zzuz().zzF(5, new zzEA());
        if (ChartDataPointCollection.zzW3B(chartSeries.zzY09().zzRE())) {
            chartSeries.setInvertIfNegative(false);
        }
        switch (chartSeries.zzY09().zzRE()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzFH(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzFH(chartSeries, 5);
                ChartSeriesCollection.zzX2I(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzFH(chartSeries, 1);
                ChartSeriesCollection.zzX2I(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzYlo(chartSeries);
            }
        }
    }

    private static void zzYlo(ChartSeries chartSeries) {
        zzEA zzEA2 = new zzEA();
        zzEA2.setOutline(new zzZ9w());
        zzwm zzwm2 = new zzwm();
        zzwm2.zzYv5(1);
        zzEA2.getOutline().setFill(new zzRD(zzwm2));
        zzEA2.getOutline().zzVQi(19050.0);
        chartSeries.zzY5G().zzuz().zzF(5, zzEA2);
    }

    private static void zzX2I(ChartSeries chartSeries) {
        zzEA zzEA2 = new zzEA();
        zzEA2.setOutline(new zzZ9w());
        zzEA2.getOutline().setFill(new zzzU());
        zzEA2.getOutline().setEndCap(0);
        zzEA2.getOutline().zzVQi(19050.0);
        chartSeries.zzY5G().zzuz().zzF(5, zzEA2);
    }

    private static void zzFH(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzY09());
        chartMarker.zzZhD().zzF(0, n);
        chartSeries.zzY5G().zzuz().zzF(4, chartMarker);
    }

    private static zzW48 zzWlq(double[] dArray) {
        int n = 0;
        zzW48 zzW482 = new zzW48(2);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzW482.zzWn8(new zzYgQ(n, d, "General"));
            }
            ++n;
        }
        zzW482.zzYLU(dArray.length);
        return zzW482;
    }

    private static zzW48 zzFH(zzYYU[] zzYYUArray) {
        int n = 0;
        zzW48 zzW482 = new zzW48(2);
        zzYYU[] zzYYUArray2 = zzYYUArray;
        int n2 = zzYYUArray.length;
        for (int i = 0; i < n2; ++i) {
            zzYYU zzYYU2 = zzYYUArray2[i];
            zzW482.zzWn8(new zzYgQ(n++, zzYzt.zzWEo(zzYYU2), "m/d/yyyy"));
        }
        zzW482.zzYLU(zzYYUArray.length);
        return zzW482;
    }

    private static zzW48 zzXWE(String[] stringArray) {
        int n = 0;
        zzW48 zzW482 = new zzW48(1);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzW482.zzWn8(new zzXQL(n++, string));
        }
        zzW482.zzYLU(stringArray.length);
        return zzW482;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzqM().zzXPM().size();
    }

    private zzLw zzqM() {
        return this.zzWBe.zzZbT().zzqM();
    }
}

