/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzXT6;
import com.aspose.words.zzGG;
import com.aspose.words.zzWS6;
import com.aspose.words.zzWag;
import com.aspose.words.zzX4q;
import com.aspose.words.zzXXa;
import com.aspose.words.zzY2Y;
import com.aspose.words.zzYAb;
import com.aspose.words.zzYzt;
import com.aspose.words.zzZgF;
import com.aspose.words.zzZqk;

public class Cell
extends CompositeNode<Node>
implements zzYAb,
zzZqk {
    private zzXXa zzWk9;
    private CellFormat zzZ5U;
    private ParagraphCollection zzWr;
    private TableCollection zzZYl;

    public Cell(DocumentBase doc) {
        this(doc, new zzXXa());
    }

    Cell(DocumentBase doc, zzXXa cellPr) {
        super(doc);
        this.zzWk9 = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    public Cell getNextCell() {
        return (Cell)this.zzXRF();
    }

    public Cell getPreviousCell() {
        return (Cell)this.zzY0o();
    }

    public Row getParentRow() {
        return (Row)this.zzZYH();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzYTR() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzWO6(this, true);
        }
        return -1;
    }

    final int zzXW7() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzXW7();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzZ5U == null) {
            this.zzZ5U = new CellFormat(this);
        }
        return this.zzZ5U;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzWr == null) {
            this.zzWr = new ParagraphCollection(this);
        }
        return this.zzWr;
    }

    public TableCollection getTables() {
        if (this.zzZYl == null) {
            this.zzZYl = new TableCollection(this);
        }
        return this.zzZYl;
    }

    final zzXXa zzYpt() {
        return this.zzWk9;
    }

    final void zzFH(zzXXa zzXXa2) {
        this.zzWk9 = zzXXa2;
    }

    @Override
    final Node zzFH(boolean bl, zzGG zzGG2) {
        zzXXa zzXXa2;
        Cell cell = (Cell)super.zzFH(bl, zzGG2);
        zzXXa zzXXa3 = this.zzWk9;
        cell.zzWk9 = zzXXa2 = (zzXXa)zzXXa3.zzYvA();
        cell.zzZ5U = null;
        cell.zzWr = null;
        cell.zzZYl = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitCellStart(this);
    }

    @Override
    public int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzY2Y.zzW4B(this);
    }

    @Override
    final boolean zzWlq(Node node) {
        return zzYzt.zzY8b(node);
    }

    final int zzXHx() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        for (Cell cell = row.getFirstCell(); cell != null; cell = cell.getNextCell()) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell != this) continue;
            return n;
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzWk9.zzXZ6(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzWk9.zzXZ6(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzX4q zzX4q2 = zzXT6.zzFH(object, zzX4q.class);
        if (zzX4q2 != null && zzX4q2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzZwN(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzXXa.zzY6J(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzWk9.zzYlo(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzWk9.clear();
    }

    private Object zzZwN(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzXT6.zzFH((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzFH(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzWS6 getInsertRevision() {
        Cell cell = this;
        return cell.zzWk9.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzWS6 value) {
        Cloneable cloneable = this;
        zzWS6 zzWS62 = value;
        cloneable = cloneable.zzWk9;
        ((zzWag)cloneable).zzYlo(14, zzWS62);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzWS6 getDeleteRevision() {
        Cell cell = this;
        return cell.zzWk9.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzWS6 value) {
        Cloneable cloneable = this;
        zzWS6 zzWS62 = value;
        cloneable = cloneable.zzWk9;
        ((zzWag)cloneable).zzYlo(12, zzWS62);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZgF getMoveFromRevision() {
        Cell cell = this;
        return cell.zzWk9.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzZgF value) {
        Cloneable cloneable = this;
        zzZgF zzZgF2 = value;
        cloneable = cloneable.zzWk9;
        ((zzWag)cloneable).zzYlo(13, zzZgF2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZgF getMoveToRevision() {
        Cell cell = this;
        return cell.zzWk9.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzZgF value) {
        Cloneable cloneable = this;
        zzZgF zzZgF2 = value;
        cloneable = cloneable.zzWk9;
        ((zzWag)cloneable).zzYlo(15, zzZgF2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzWk9.remove(13);
        cell = this;
        cell.zzWk9.remove(15);
    }

    final zzXXa zzZrB(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzXXa zzXXa2 = new zzXXa();
        this.zzFH(3120, zzXXa2);
        this.zzFH(3140, zzXXa2);
        this.zzFH(3110, zzXXa2);
        this.zzFH(3130, zzXXa2);
        this.zzFH(3090, zzXXa2);
        this.zzFH(3100, zzXXa2);
        this.zzFH(3070, zzXXa2);
        this.zzFH(3080, zzXXa2);
        if (bl && (tableStyle = zzXT6.zzFH((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzWdb(this, zzXXa2);
        }
        this.zzWk9.zzWdb((zzWag)zzXXa2);
        return zzXXa2;
    }

    private void zzFH(int n, zzXXa zzXXa2) {
        zzXXa2.zzYlo(n, this.fetchInheritedCellAttr(n));
    }
}

