/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.internal.zzXT6;
import com.aspose.words.internal.zzYEc;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzZZv;
import java.awt.Color;
import java.util.Iterator;

public final class BorderCollection
implements Iterable<Border> {
    private zzZZv zzlp;

    BorderCollection(zzZZv parent) {
        this.zzlp = parent;
    }

    public final boolean equals(BorderCollection brColl) throws Exception {
        if (zzXT6.zzF(this, brColl)) {
            return true;
        }
        return this.getLeft().equals(brColl.getLeft()) && this.getRight().equals(brColl.getRight()) && this.getTop().equals(brColl.getTop()) && this.getBottom().equals(brColl.getBottom()) && this.getHorizontal().equals(brColl.getHorizontal()) && this.getVertical().equals(brColl.getVertical()) && this.getColor().equals(brColl.getColor()) && this.zzYh3().equals(brColl.zzYh3()) && this.getDistanceFromText() == brColl.getDistanceFromText() && this.getLineWidth() == brColl.getLineWidth() && this.getLineStyle() == brColl.getLineStyle() && this.getCount() == brColl.getCount() && this.getShadow() == brColl.getShadow() && this.isVisible() == brColl.isVisible();
    }

    public final Border getByBorderType(int borderType) throws Exception {
        RefInt refInt = new RefInt(0);
        boolean bl = !this.zzlp.getPossibleBorderKeys().zzFH(borderType, refInt);
        int borderKey = refInt.get();
        if (bl) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        Border border = (Border)this.zzlp.getDirectBorderAttr(borderKey);
        if (border == null) {
            border = new Border(this.zzlp, borderKey);
            this.zzlp.setBorderAttr(borderKey, border);
        }
        return border;
    }

    public final Border get(int index) throws Exception {
        int n = this.zzlp.getPossibleBorderKeys().zzax().get(index);
        return this.getByBorderType(n);
    }

    public final Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public final Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public final Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public final Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public final Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public final Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public final int getCount() {
        return this.zzlp.getPossibleBorderKeys().getCount();
    }

    public final double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public final void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzlp.getPossibleBorderKeys().zzax().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzYm2(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public final int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public final void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzlp.getPossibleBorderKeys().zzax().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzYm2(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public final Color getColor() throws Exception {
        return this.zzYh3().zzZww();
    }

    public final void setColor(Color value) throws Exception {
        this.zzYBR(zzYEc.zzFH(value));
    }

    private zzYEc zzYh3() throws Exception {
        return this.get(0).zzYh3();
    }

    private void zzYBR(zzYEc zzYEc2) throws Exception {
        Iterator iterator = this.zzlp.getPossibleBorderKeys().zzax().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzYm2(n)) continue;
            this.getByBorderType(n).zzYBR(zzYEc2);
        }
    }

    final boolean zzXC5(int n) {
        return this.zzlp.getPossibleBorderKeys().zzZOg(n);
    }

    public final double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public final void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzlp.getPossibleBorderKeys().zzax().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzYm2(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public final boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public final void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzlp.getPossibleBorderKeys().zzax().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzYm2(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public final void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public final Iterator<Border> iterator() {
        return new zzFH(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzYm2(int n) {
        return n != 6 && n != 7;
    }

    static final class zzFH
    implements Iterator<Border> {
        private BorderCollection zzZ8k;
        private int zzZoK;

        zzFH(BorderCollection borderCollection) {
            this.zzZ8k = borderCollection;
            this.zzZoK = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzZoK >= this.zzZ8k.getCount() - 1) {
                return false;
            }
            ++this.zzZoK;
            return true;
        }

        private Border zzY62() {
            try {
                return this.zzZ8k.get(this.zzZoK);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            return this.zzY62();
        }
    }
}

