/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzYom;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzVWC;
import com.aspose.words.net.System.Data.zzWS3;
import com.aspose.words.net.System.Data.zzYKF;
import com.aspose.words.net.System.Data.zzYgl;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzXQv;
    private final DataColumnCollection zzq3;
    private final ConstraintCollection zzYDr;
    private final zzYgl zz1E;
    private ResultSet zzZ5s;
    private String zzXAl;
    private DataSet zzyw;
    private String zz8n;
    private UniqueConstraint zzZEY;
    private boolean zzXQS;
    private final List<DataTableEventListener> zzYCQ;
    private final Set<DataRow> zzZet;
    private DataRelationCollection zzX2g;

    public DataTable() {
        this.zzXQv = new DataRowCollection(this);
        this.zzq3 = new DataColumnCollection(this);
        this.zzYDr = new ConstraintCollection(this);
        this.zz1E = new zzYgl(this);
        this.zz8n = "";
        this.zzXQS = true;
        this.zzYCQ = new ArrayList<DataTableEventListener>();
        this.zzZet = new HashSet<DataRow>();
        this.zzX2g = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzXQv = new DataRowCollection(this);
        this.zzq3 = new DataColumnCollection(this);
        this.zzYDr = new ConstraintCollection(this);
        this.zz1E = new zzYgl(this);
        this.zz8n = "";
        this.zzXQS = true;
        this.zzYCQ = new ArrayList<DataTableEventListener>();
        this.zzZet = new HashSet<DataRow>();
        this.zzX2g = new DataRelationCollection();
        this.zzXAl = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzWS3.zzXK2(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzXQv = new DataRowCollection(this);
        this.zzq3 = new DataColumnCollection(this);
        this.zzYDr = new ConstraintCollection(this);
        this.zz1E = new zzYgl(this);
        this.zz8n = "";
        this.zzXQS = true;
        this.zzYCQ = new ArrayList<DataTableEventListener>();
        this.zzZet = new HashSet<DataRow>();
        this.zzX2g = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzZ5s = resultSet;
        this.zzXAl = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzZ5s != null) {
            if (this.zzZ5s.getStatement() != null) {
                this.zzZ5s.getStatement().getConnection().close();
            }
            this.zzZ5s = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzXAl;
    }

    public void setTableName(String tableName) {
        this.zzXAl = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzq3.getCount();
    }

    public String getColumnName(int index) {
        return this.zzq3.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzZ5s;
    }

    public DataSet getDataSet() {
        return this.zzyw;
    }

    final void zziA(DataSet dataSet) {
        this.zzyw = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzyw.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzX2g.add(dataRelation);
        }
        return this.zzX2g;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzyw.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzXQv;
    }

    public DataColumnCollection getColumns() {
        return this.zzq3;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzYDr;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzZEY == null) {
            return new DataColumn[0];
        }
        return this.zzZEY.getColumns();
    }

    final void zzYgl(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzZEY != null) {
                this.zzZEY.zzWaX(false);
                this.getConstraints().remove(this.zzZEY);
                this.zzZEY = null;
            }
            return;
        }
        if (this.zzZEY != null && DataColumn.areColumnSetsTheSame(value, this.zzZEY.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzXK2(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzZEY != null) {
            this.zzZEY.zzWaX(false);
            this.getConstraints().remove(this.zzZEY);
            this.zzZEY = null;
        }
        UniqueConstraint.zzXK2(this.getConstraints(), uniqueConstraint);
        this.zzZEY = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zz8n;
    }

    public void setNamespace(String namespace) {
        this.zz8n = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzXQS;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzXQS = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzZet.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzWS3.zzXK2(this.getResultSet(), this);
            zzWS3.zzWS3(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzYom.zziA(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzWS3.zzYtJ(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzYCQ.contains(listener)) {
            this.zzYCQ.add(listener);
        }
    }

    public void removeEventListener(zzYKF listener) {
        if (this.zzYCQ.contains(listener)) {
            this.zzYCQ.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzYCQ.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzZet.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzYCQ) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzZet.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzYCQ) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzZet.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzYCQ) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzYCQ) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzYCQ) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzVWC zzXK2(zzWS3[] zzWS3Array) {
        DataColumn[] dataColumnArray = new DataColumn[zzWS3Array.length];
        for (int i = 0; i < zzWS3Array.length; ++i) {
            dataColumnArray[i] = zzWS3Array[i].zzXig();
        }
        DataTable dataTable = this;
        zzVWC zzVWC2 = dataTable.zz1E.zziA(dataColumnArray);
        if (zzVWC2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzVWC2;
    }

    final zzYgl zzYyU() {
        return this.zz1E;
    }

    final Set<DataRow> zzY4p() {
        return this.zzZet;
    }
}

