/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SectionStart;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzY8e;
import com.aspose.words.internal.zzYb0;
import com.aspose.words.zzVZZ;
import com.aspose.words.zzW5n;
import com.aspose.words.zzWgD;

public final class Section
extends CompositeNode<Node>
implements zzW5n {
    private zzVZZ zzWJf;
    private PageSetup zzXzx;
    private HeaderFooterCollection zzWSs;

    public Section(DocumentBase doc) {
        this(doc, new zzVZZ());
    }

    Section(DocumentBase doc, zzVZZ sectPr) {
        super(doc);
        this.zzWJf = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzWSs == null) {
            this.zzWSs = new HeaderFooterCollection(this);
        }
        return this.zzWSs;
    }

    public final PageSetup getPageSetup() {
        if (this.zzXzx == null) {
            Section section = this;
            this.zzXzx = new PageSetup(section, section.getDocument().zzWkS(), this.getDocument().getStyles(), new zzXK2(this));
        }
        return this.zzXzx;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzZpn();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzVQp(!value);
    }

    final zzVZZ zzZ0Y() {
        return this.zzWJf;
    }

    final void zzWS3(zzVZZ zzVZZ2) {
        this.zzWJf = zzVZZ2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzXK2(boolean bl, zzWgD zzWgD2) {
        zzVZZ zzVZZ2;
        Section section = (Section)super.zzXK2(bl, zzWgD2);
        zzVZZ zzVZZ3 = this.zzWJf;
        section.zzWJf = zzVZZ2 = (zzVZZ)zzVZZ3.zzYFg();
        section.zzXzx = null;
        section.zzWSs = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public final int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionStart(this);
    }

    @Override
    public final int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zziA(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zziA(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzok(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzVWC(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzok(n) == null;
            }
        }
        return false;
    }

    final void zzYKF(Shape shape, boolean bl) throws Exception {
        this.zzXK2(shape, 4, bl);
        this.zzXK2(shape, 0, bl);
        this.zzXK2(shape, 1, bl);
    }

    private void zzXK2(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzXPS());
        shape2.setName(zzY8e.zzWS3("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final boolean zzXY1() {
        boolean bl = false;
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzZmq()) {
                if (!shape.zzYP1()) continue;
                shape.remove();
                bl = true;
            }
        }
        return bl;
    }

    private void zziA(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzWS3(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzWJf.zzZf3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzWkS().zzXOU.zzgw(key);
        }
        return zzVZZ.zzXbT(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzWJf.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzWkS().zzXOU.zzYU(key, value);
            return;
        }
        this.zzWJf.zzYU(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzWJf.clear();
    }

    final boolean zz3Y() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzY2R() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = super.toString();
        Section section = this;
        objectArray[1] = SectionStart.toString(section.zzWJf.getSectionStart());
        return zzY8e.zzWS3("{0} {1}", objectArray);
    }

    static final class zzXK2
    implements zzW5n {
        private Section zzWRV;

        zzXK2(Section section) {
            this.zzWRV = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzX5z().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzX5z().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzX5z().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzW5n zzX5z() {
            Document document = zzYb0.zzXK2((Object)this.zzWRV.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzWRV;
        }
    }
}

