/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XlsxSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zz5Y;
import com.aspose.words.internal.zzXn5;

public abstract class SaveOptions {
    private IDocumentSavingCallback zzW95;
    private boolean zzZbF;
    boolean zzZoe = true;
    private boolean zzXIS = true;
    private boolean zzXFd = false;
    private boolean zzYMP;
    private boolean zzWMU = true;
    private boolean zzZmV;
    private String zzpu;
    private boolean zzYTC;
    private boolean zzXdN = false;
    private int zzWSQ = 1;
    private int zzVTQ = 1;
    private int zzg = 0;
    private String zzZgn = "";
    private boolean zzkx = true;
    private boolean zzZbl = true;
    private boolean zzZSN;
    private boolean zzZwv;
    private int zzVT8 = 0;
    private boolean zzXTs = true;
    private boolean zzrI = false;

    protected SaveOptions() {
    }

    final boolean zzXSD() {
        return this.zzYMP;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzpZ() {
        return false;
    }

    boolean zzY2X() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzWMU;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzWMU = value;
    }

    public String getTempFolder() {
        return this.zzpu;
    }

    public void setTempFolder(String value) {
        this.zzpu = value;
    }

    public boolean getPrettyFormat() {
        return this.zzZmV;
    }

    public void setPrettyFormat(boolean value) {
        this.zzZmV = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzYTC;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzYTC = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzXdN;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzXdN = value;
    }

    public int getDmlRenderingMode() {
        return this.zzWSQ;
    }

    public void setDmlRenderingMode(int value) {
        this.zzWSQ = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzg;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzg = value;
    }

    public int getImlRenderingMode() {
        return this.zzVTQ;
    }

    public void setImlRenderingMode(int value) {
        this.zzVTQ = value;
    }

    public String getDefaultTemplate() {
        return this.zzZgn;
    }

    public void setDefaultTemplate(String value) {
        this.zzZgn = value;
    }

    public boolean getUpdateFields() {
        return this.zzkx;
    }

    public void setUpdateFields(boolean value) {
        this.zzkx = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzZSN;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzZSN = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzZwv;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzZwv = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzrI;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzrI = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzXFd;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzXFd = value;
    }

    final boolean zzWGV() {
        return this.zzZbl;
    }

    final boolean zzWLN() {
        return this.zzXTs;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                return new ImageSaveOptions(saveFormat);
            }
            case 80: {
                return new XlsxSaveOptions();
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzYLC(zz5Y.zzYXY(zzXn5.zzZi0(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzVT8;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzVT8 = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzW95;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzW95 = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzZbF;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzZbF = value;
    }

    final boolean zzWkm() {
        return this.zzXIS;
    }

    final void zzZ1E(boolean bl) {
        this.zzXIS = false;
    }
}

