/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.List;
import com.aspose.words.ListCollection;
import com.aspose.words.ListLevel;
import com.aspose.words.Paragraph;
import com.aspose.words.internal.zzYb0;
import com.aspose.words.zz5u;
import com.aspose.words.zzWYy;
import com.aspose.words.zzYOw;

public class ListFormat {
    private zzWYy zzX2U;
    private zz5u zzQQ;
    private ListCollection zzH2;
    private ListLevel zzZZY;
    private ListLevel zzZmn;

    ListFormat(zzWYy parentParaAttrs, zz5u parentRunAttrs, ListCollection lists) {
        this.zzX2U = parentParaAttrs;
        this.zzQQ = parentRunAttrs;
        this.zzH2 = lists;
    }

    public void applyBulletDefault() {
        if (this.zzH2.getCount() > 2046) {
            zzYOw.zzWS3(this.zzH2.getDocument().getWarningCallback(), 17, "List count exceed maximum allowed, document can have problem while opened in MS Word.", new Object[0]);
        }
        ListFormat listFormat = this;
        listFormat.zzIl(listFormat.zzH2.add(0).getListId());
        this.setListLevelNumber(0);
        ListFormat listFormat2 = this;
        this.zzZZY = null;
    }

    public void applyNumberDefault() {
        if (this.zzH2.getCount() > 2046) {
            zzYOw.zzWS3(this.zzH2.getDocument().getWarningCallback(), 17, "List count exceed maximum allowed, document can have problem while opened in MS Word.", new Object[0]);
        }
        ListFormat listFormat = this;
        listFormat.zzIl(listFormat.zzH2.add(6).getListId());
        this.setListLevelNumber(0);
        ListFormat listFormat2 = this;
        this.zzZZY = null;
    }

    public void removeNumbers() {
        this.setList(null);
        ListFormat listFormat = this;
        this.zzZZY = null;
    }

    public void listIndent() throws Exception {
        if (this.zzYiz() < 8) {
            ListFormat listFormat = this;
            listFormat.setListLevelNumber(listFormat.zzYiz() + 1);
            ListFormat listFormat2 = this;
            this.zzZZY = null;
        }
    }

    public void listOutdent() throws Exception {
        if (this.zzYiz() > 0) {
            ListFormat listFormat = this;
            listFormat.setListLevelNumber(listFormat.zzYiz() - 1);
            ListFormat listFormat2 = this;
            this.zzZZY = null;
        }
    }

    public int getListLevelNumber() {
        Document document = zzYb0.zzXK2((Object)this.zzH2.getDocument(), Document.class);
        if (document != null && document.getRevisionsView() == 1) {
            return this.zzXQa();
        }
        return this.zzYiz();
    }

    public void setListLevelNumber(int value) {
        this.zzX2U.setParaAttr(1110, value);
        ListFormat listFormat = this;
        this.zzZZY = null;
    }

    final int zzYiz() {
        return (Integer)this.zzX2U.fetchParaAttr(1110);
    }

    final int zzXQa() {
        Paragraph paragraph = zzYb0.zzXK2((Object)this.zzX2U, Paragraph.class);
        if (paragraph != null) {
            return (Integer)paragraph.zzZ9W(1110, 1);
        }
        return this.zzYiz();
    }

    public boolean isListItem() {
        return this.getListId() != 0;
    }

    public List getList() {
        int n = this.getListId();
        if (n != 0) {
            return this.zzH2.zzZ8t(n);
        }
        return null;
    }

    public void setList(List value) {
        if (value == null) {
            this.zzIl(0);
            this.setListLevelNumber(0);
        } else {
            if (value.getDocument() != this.zzH2.getDocument()) {
                throw new IllegalArgumentException("The list belongs to a different document.");
            }
            if (value.isListStyleDefinition()) {
                throw new IllegalArgumentException("The list is a definition of a list style.");
            }
            this.zzIl(value.getListId());
        }
        ListFormat listFormat = this;
        this.zzZZY = null;
    }

    final List zzYfC() {
        int n = this.zz6S();
        if (n != 0) {
            return this.zzH2.zzZ8t(n);
        }
        return null;
    }

    public ListLevel getListLevel() {
        try {
            Document document = zzYb0.zzXK2((Object)this.zzH2.getDocument(), Document.class);
            if (document != null && document.getRevisionsView() == 1) {
                return this.zzZ5z();
            }
            return this.zzYh5();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private ListLevel zzYh5() {
        try {
            if (this.zzZZY == null) {
                List list = this.getList();
                ListLevel listLevel = list != null ? list.zz6v(this.zzYiz()) : null;
                this.zzZZY = listLevel != null ? new ListLevel(listLevel, this.zzQQ) : null;
            }
            return this.zzZZY;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    final ListLevel zzZ5z() {
        if (this.zzZmn == null) {
            List list = this.zzYfC();
            ListLevel listLevel = list != null ? list.zz6v(this.zzXQa()) : null;
            this.zzZmn = listLevel != null ? new ListLevel(listLevel, this.zzQQ) : null;
        }
        return this.zzZmn;
    }

    final int getListId() {
        return (Integer)this.zzX2U.fetchParaAttr(1120);
    }

    private void zzIl(int n) {
        Object object = this.zzX2U.getDirectParaAttr(1160);
        int n2 = object != null ? (Integer)object : 0;
        int n3 = 0;
        if (n2 != 0 && n != 0 && this.getListLevel() != null && n2 < (n3 = this.getListLevel().zzpe().zzuN() + this.getListLevel().zzpe().zzWUl())) {
            n3 = 0;
        }
        this.zzX2U.setParaAttr(1120, n);
        ListFormat listFormat = this;
        this.zzZZY = null;
        if (n == 0 || object == null || this.getListLevel() == null) {
            return;
        }
        if (n2 == 0) {
            this.zzX2U.removeParaAttr(1160);
            return;
        }
        int n4 = n2 - n3 + this.getListLevel().zzpe().zzuN() + this.getListLevel().zzpe().zzWUl();
        this.zzX2U.setParaAttr(1160, n4);
    }

    private int zz6S() {
        Paragraph paragraph = zzYb0.zzXK2((Object)this.zzX2U, Paragraph.class);
        if (paragraph != null) {
            return (Integer)paragraph.zzZ9W(1120, 1);
        }
        return this.getListId();
    }
}

