/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzA3;
import com.aspose.words.internal.zzDT;
import com.aspose.words.internal.zzL9;
import com.aspose.words.internal.zzVXf;
import com.aspose.words.internal.zzXA3;
import com.aspose.words.internal.zzXAD;
import com.aspose.words.internal.zzXSl;
import com.aspose.words.internal.zzXl7;
import com.aspose.words.internal.zzY8e;
import com.aspose.words.internal.zzYb0;
import com.aspose.words.internal.zzYlp;
import com.aspose.words.internal.zzzS;
import com.aspose.words.zz9f;
import com.aspose.words.zzVRF;
import com.aspose.words.zzWnd;
import com.aspose.words.zzXQ0;
import com.aspose.words.zzXiG;
import com.aspose.words.zzY8R;
import com.aspose.words.zzYLe;
import com.aspose.words.zzYoz;
import com.aspose.words.zzZ3o;
import com.aspose.words.zzam;
import com.aspose.words.zzxs;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzXK2(zzDT zzDT2, zzDT zzDT3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzYb0.zzWS3((Object)zzDT2, "srcStream");
        zzYb0.zzWS3((Object)zzDT3, "dstStream");
        zzYb0.zzWS3((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzWS3(zzDT2, zzDT3, certificateHolder, signOptions);
        zzDT3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzXK2(zzDT.zzWS3(srcStream), (zzDT)zzDT.zzYKF(dstStream), certHolder, signOptions);
    }

    private static void zzWS3(zzDT zzDT2, zzDT zzDT3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzYKF(digitalSignature);
        }
        if (zzXiG.zzZkd(zzDT2)) {
            DigitalSignatureUtil.zzXK2(zzDT2, zzDT3, digitalSignature, true);
            return;
        }
        zzXiG zzXiG2 = new zzXiG();
        zzDT zzDT4 = zzDT2;
        zzXiG zzXiG3 = zzXiG2;
        FileFormatInfo fileFormatInfo = zzXiG2.zzWS3(zzDT4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzXA3 zzXA32 = new zzXA3(zzDT2);
                int n = fileFormatInfo.zzZGs() == 1 ? 1 : 2;
                zz9f.zzXK2(zzXA32, digitalSignature, n);
                zzDT3.zzZT0(0L);
                zzXA32.zzwi(zzDT3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzXK2(fileFormatInfo.zz31(), zzDT3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzXK2(zzDT2, zzDT3, digitalSignature, false);
                return;
            }
            case 60: 
            case 61: {
                DigitalSignatureUtil.zzXK2(zzDT2, zzDT3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzYb0.zzYKF(srcFileName, "srcFileName");
        zzYb0.zzYKF(dstFileName, "dstFileName");
        try (zzVXf zzVXf2 = zzYb0.zzWS3(srcFileName, 3, 1);){
            try (zzVXf zzVXf3 = zzYb0.zzWS3(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzXK2((zzDT)zzVXf2, (zzDT)zzVXf3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzL9 zzL92 = zzDT.zzYKF(dstStream);
        zzDT zzDT2 = zzDT.zzWS3(srcStream);
        DigitalSignatureUtil.zzXK2(zzDT2, (zzDT)zzL92, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzVXf zzVXf2 = zzYb0.zzWS3(srcFileName, 3, 1);){
            try (zzVXf zzVXf3 = zzYb0.zzWS3(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzYtJ(zzVXf2, zzVXf3);
            }
            return;
        }
    }

    private static void zzYtJ(zzDT zzDT2, zzDT zzDT3) throws Exception {
        zzXiG zzXiG2 = new zzXiG();
        zzDT zzDT4 = zzDT2;
        Object object = zzXiG2;
        FileFormatInfo fileFormatInfo = zzXiG2.zzWS3(zzDT4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzXA3 zzXA32 = new zzXA3(zzDT2);
                zzXA32.zzXoY().zzW0o("_xmlsignatures");
                zzXA32.zzXoY().zzW0o("_signatures");
                zzDT3.zzWhg(0L);
                zzXA32.zzwi(zzDT3);
                zzDT zzDT5 = zzDT3;
                zzDT5.zzZT0(zzDT5.zzXYZ());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzYlp zzYlp2 = new zzYlp(zzDT2);
                zzXSl zzXSl2 = zzYlp2.zzXK2(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzXSl2 != null) {
                    for (zzXAD zzXAD2 : zzXSl2.zzZdA()) {
                        String string = zzXSl2.zzXK2(zzXAD2);
                        zzYlp2.zzRm().remove(string);
                    }
                    zzYlp2.zzRm().remove(zzXSl2.getName());
                    zzXAD zzXAD3 = zzYlp2.zzZdA().zzp5("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzYlp2.zzZdA().remove(zzXAD3.getId());
                    zzYlp2.zzZ6s();
                }
                zzDT3.zzWhg(0L);
                zzYlp2.zzwi(zzDT3);
                zzDT zzDT6 = zzDT3;
                zzDT6.zzZT0(zzDT6.zzXYZ());
                return;
            }
            case 60: 
            case 61: {
                zzam zzam2 = new zzam(zzDT2);
                zzY8R zzY8R2 = zzam2.zz0E("/META-INF/documentsignatures.xml");
                if (zzY8R2 != null) {
                    zzam2.zzXU().remove(zzY8R2.getName());
                }
                zzDT3.zzWhg(0L);
                String string = "application/vnd.oasis.opendocument.text";
                zzDT4 = zzDT3;
                object = zzam2;
                ((zzam)object).zzXK2(zzDT4, string, null);
                zzDT zzDT7 = zzDT3;
                zzDT7.zzZT0(zzDT7.zzXYZ());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzYtJ(zzDT.zzWS3(srcStream), zzDT.zzYKF(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzVXf zzVXf2 = zzYb0.zzWS3(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzVS(zzVXf2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzVS(zzDT zzDT2) throws Exception {
        if (zzXiG.zzZkd(zzDT2)) {
            return DigitalSignatureUtil.zzWG0(zzDT2);
        }
        zzXiG zzXiG2 = new zzXiG();
        zzDT zzDT3 = zzDT2;
        zzXiG zzXiG3 = zzXiG2;
        FileFormatInfo fileFormatInfo = zzXiG2.zzWS3(zzDT3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzDT2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzVS(zzDT.zzWS3(stream));
    }

    static zzXl7 zzXK2(zzXA3 zzXA32, String string) throws Exception {
        zzYoz zzYoz2 = new zzYoz(zzXA32);
        if (zzYoz2.zzWz1()) {
            zzXl7 zzXl72 = zzYoz2.zz5Y(string);
            return zzXl72;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzXO3(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzY8e.zzWS3("Unexpected digest algorithm: {0}.", n));
    }

    static String zzY4D(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzXO3(n);
    }

    private static void zzXK2(zzDT zzDT2, zzDT zzDT3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzYlp zzYlp2 = new zzYlp(zzDT2);
        zzZ3o zzZ3o2 = bl ? new zzWnd(zzYlp2) : new zzYLe(zzYlp2);
        zzZ3o2.zzWS3(digitalSignature);
        zzDT3.zzZT0(0L);
        zzYlp2.zzwi(zzDT3);
    }

    private static void zzXK2(zzDT zzDT2, zzDT zzDT3, DigitalSignature digitalSignature) throws Exception {
        zzam zzam2 = new zzam(zzDT2);
        zzxs zzxs2 = new zzxs(zzam2);
        zzxs2.zzWS3(digitalSignature);
        zzDT3.zzZT0(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzDT zzDT4 = zzDT3;
        zzam zzam3 = zzam2;
        zzam3.zzXK2(zzDT4, string, null);
    }

    private static void zzXK2(zzXA3 zzXA32, zzDT zzDT2, DigitalSignature digitalSignature, String string) throws Exception {
        zzXl7 zzXl72 = DigitalSignatureUtil.zzXK2(zzXA32, string);
        zzXl7 zzXl73 = new zzXl7();
        DigitalSignatureUtil.zzXK2((zzDT)zzXl72, (zzDT)zzXl73, digitalSignature, false);
        zzXA3 zzXA33 = zzYoz.zzYtJ(zzXl73, string);
        zzXA33.zzwi(zzDT2);
    }

    private static DigitalSignatureCollection zzWG0(zzDT zzDT2) throws Exception {
        zzDT2.zzWhg(0L);
        zzYlp zzYlp2 = new zzYlp(zzDT2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzXSl zzXSl2 = zzYlp2.zzXK2(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzXSl2 != null) {
            for (zzXAD zzXAD2 : zzXSl2.zzZdA()) {
                String string = zzXSl2.zzXK2(zzXAD2);
                zzXSl zzXSl3 = zzYlp2.zzlD(string);
                zzXSl zzXSl4 = zzYlp2.zzXK2(zzXSl3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzA3 zzA32 = zzzS.zzf0(zzXSl4.zzWF1().zzZGh());
                zzVRF.zzXK2(zzXSl3.zzWtH(), zzA32, new zzXQ0(zzYlp2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

