/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzYb0;
import com.aspose.words.zzWgD;
import com.aspose.words.zzWo9;
import com.aspose.words.zzWxU;
import com.aspose.words.zzXwP;
import com.aspose.words.zzY1i;
import com.aspose.words.zzYOw;
import com.aspose.words.zzYlM;
import com.aspose.words.zzZU8;
import com.aspose.words.zzZhV;
import java.util.Iterator;

public abstract class CompositeNode<V extends Node>
extends Node
implements zzZU8,
Iterable<V> {
    private Node zzZzu;
    private Node zzXZ4;
    private Node zzYND;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        zzXwP zzXwP2 = new zzXwP(this.getDocument());
        try {
            while (this.hasChildNodes()) {
                this.getParentNode().insertAfter(this.getLastChild(), this);
            }
            this.getParentNode().zzYKF(this, true);
            return;
        }
        finally {
            zzXwP2.dispose();
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzeJ() {
        return this.zzXtl() != null;
    }

    final boolean zzZj6() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzXln() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzZhV) {
                return true;
            }
            CompositeNode compositeNode = zzYb0.zzXK2((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzXln()) continue;
            return true;
        }
        return false;
    }

    public Node getFirstChild() {
        return this.zzZzu;
    }

    public Node getLastChild() {
        return this.zzXZ4;
    }

    final Node zzXtl() {
        return zzYOw.zzW7T(this.getFirstChild(), false);
    }

    final Node zzWiZ() {
        return zzYOw.zzYbj(this.getLastChild(), false);
    }

    final CompositeNode zzWiK() {
        return (CompositeNode)zzYOw.zzW7T(this.getFirstChild(), true);
    }

    final CompositeNode zzYlG() {
        return (CompositeNode)zzYOw.zzYbj(this.getLastChild(), true);
    }

    final Node zzYok() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzYOw.zzvp((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzYeQ() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzYOw.zzvp((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzXK2(boolean bl, zzWgD zzWgD2) {
        CompositeNode compositeNode = (CompositeNode)super.zzXK2(bl, zzWgD2);
        ((CompositeNode)super.zzXK2(bl, zzWgD2)).zzXZ4 = null;
        compositeNode.zzZzu = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzXaj(node.zzXK2(true, zzWgD2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzUv(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzUv(StringBuilder stringBuilder) {
        this.zzwi(stringBuilder);
        zzYb0.zzWS3(stringBuilder, this.zzZ7I());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzWS3(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, bl);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzYOw.zzYf3(nodeType);
            Node node2 = node = bl ? this.zzXtl() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzYdp() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzWo9.zzYKF(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzWo9.zziA(this, xpath);
    }

    @Override
    public Iterator<V> iterator() {
        return new zzY1i(this);
    }

    public <T extends Node> T appendChild(T newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public <T extends Node> T prependChild(T newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public <T extends Node> T insertAfter(T newChild, Node refChild) {
        return this.zzXK2(newChild, refChild, true);
    }

    public <T extends Node> T insertBefore(T newChild, Node refChild) {
        return this.zzXK2(newChild, refChild, false);
    }

    public <T extends Node> T removeChild(T oldChild) {
        return this.zzYKF(oldChild, false);
    }

    private <T extends Node> T zzYKF(T t, boolean bl) {
        if (t == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oldChild");
        }
        if (t.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = CompositeNode.zzXK2(documentBase, t, this, null, 1);
        DocumentBase documentBase2 = documentBase;
        if (documentBase2.zzZKF() && zzYOw.zzXAV(t)) {
            return t;
        }
        CompositeNode.zzXK2(documentBase, nodeChangingArgs);
        if (!bl && zzYOw.zzZHs(t)) {
            zzYOw.zzOT(t, false);
        }
        T t2 = this.zzZT0(t);
        CompositeNode.zzWS3(documentBase, nodeChangingArgs);
        return t2;
    }

    public void removeAllChildren() {
        zzYlM.zzZZ4(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzXaj(Node node) {
        node.getParentNode();
        if (this.zzXZ4 == null) {
            node.zzXDx(null);
            node.zzZkc(null);
            this.zzZzu = node;
        } else {
            node.zzXDx(this.zzXZ4);
            node.zzZkc(null);
            this.zzXZ4.zzZkc(node);
        }
        this.zzXZ4 = node;
        node.zzZEz(this);
        return node;
    }

    final void zzXK2(Node node, Node node2, Node node3) {
        this.zzXK2(node, node2, node3, false);
    }

    final void zzXK2(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzVWC(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzWS3(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zziA(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzYOw.zzvp(node3.getNodeType())) continue;
            if (zzYOw.zzVWC(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzZ7I().length();
    }

    String zzZ7I() {
        return "";
    }

    final String zzXlK() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzwi(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzwi(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzUv(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.acceptStart(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.acceptEnd(visitor));
    }

    public abstract int acceptStart(DocumentVisitor var1) throws Exception;

    public abstract int acceptEnd(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    boolean zzVWC(Node node) {
        return true;
    }

    private static NodeChangingArgs zzXK2(DocumentBase documentBase, Node node, Node node2, Node node3, int n) {
        return documentBase.zzXK2(node, node2, node3, n);
    }

    private static void zzXK2(DocumentBase documentBase, NodeChangingArgs nodeChangingArgs) {
        if (nodeChangingArgs != null) {
            documentBase.zzXK2(nodeChangingArgs);
        }
    }

    private static void zzWS3(DocumentBase documentBase, NodeChangingArgs nodeChangingArgs) {
        if (nodeChangingArgs != null) {
            documentBase.zzWS3(nodeChangingArgs);
        }
    }

    final <T extends Node> T zzXK2(T t, Node node, boolean bl) {
        Object object;
        if (node != null && node.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (t == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (t == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzZq3(t)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (t == node) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = t.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (t.getNodeType() != 37 && !this.zzVWC(t)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = t.getParentNode();
        Node node2 = t.getNextSibling();
        if (compositeNode != null) {
            object = new zzWxU(documentBase);
            try {
                compositeNode.zzYKF(t, true);
            }
            finally {
                ((zzWxU)object).dispose();
            }
        }
        object = CompositeNode.zzXK2(documentBase, t, null, this, 0);
        CompositeNode.zzXK2(documentBase, (NodeChangingArgs)object);
        if (this.zzXZ4 == null) {
            t.zzXDx(null);
            t.zzZkc(null);
            this.zzZzu = t;
            this.zzXZ4 = t;
        } else if (bl) {
            if (node != null) {
                this.zzWS3(t, node);
            } else {
                this.zzYKF(t, this.zzZzu);
            }
        } else if (node != null) {
            this.zzYKF(t, node);
        } else {
            this.zzWS3(t, this.zzXZ4);
        }
        t.zzZEz(this);
        CompositeNode.zzWS3(documentBase, (NodeChangingArgs)object);
        DocumentBase documentBase3 = documentBase;
        if (documentBase3.zzZKF()) {
            zzYOw.zzXK2(t, compositeNode, node2);
        }
        return t;
    }

    private void zzWS3(Node node, Node node2) {
        Node node3 = node2.zzWbR();
        node.zzXDx(node2);
        node.zzZkc(node3);
        node2.zzZkc(node);
        if (node3 == null) {
            this.zzXZ4 = node;
            return;
        }
        node3.zzXDx(node);
    }

    private void zzYKF(Node node, Node node2) {
        Node node3 = node2.zzY3q();
        node.zzXDx(node3);
        node.zzZkc(node2);
        node2.zzXDx(node);
        if (node3 == null) {
            this.zzZzu = node;
            return;
        }
        node3.zzZkc(node);
    }

    private <T extends Node> T zzZT0(T t) {
        if (t == this.zzZzu) {
            if (this.zzZzu == this.zzXZ4) {
                this.zzZzu = null;
                this.zzXZ4 = null;
            } else {
                this.zzZzu = t.zzWbR();
                this.zzZzu.zzXDx(null);
            }
        } else {
            Node node = t.zzY3q();
            Node node2 = t.zzWbR();
            node.zzZkc(node2);
            if (node2 == null) {
                this.zzXZ4 = node;
            } else {
                node2.zzXDx(node);
            }
        }
        t.zzZkc(null);
        t.zzXDx(null);
        t.zzZEz(null);
        return t;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzYND = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzYND;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

