/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CommentCollection;
import com.aspose.words.CommentRangeEnd;
import com.aspose.words.CommentRangeStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.InlineStory;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SpecialChar;
import com.aspose.words.internal.zz9j;
import com.aspose.words.internal.zzWR6;
import com.aspose.words.internal.zzYb0;
import com.aspose.words.zz2d;
import com.aspose.words.zzTf;
import com.aspose.words.zzW7R;
import com.aspose.words.zzWXJ;
import com.aspose.words.zzWwN;
import com.aspose.words.zzX6O;
import java.util.ArrayList;
import java.util.Date;

public final class Comment
extends InlineStory
implements zzWwN,
zzX6O {
    private int zzZKJ;
    private boolean zzZpZ;
    private boolean zzWms;
    private int zzYmn;
    private int zzYbe = -1;
    private String zzXpv = "";
    private String zzWKC = "";
    private zzWR6 zzYtF = zzWR6.zzAq;
    private zzWR6 zzW49 = zzWR6.zzAq;
    private CommentCollection zzWQD;

    Comment(DocumentBase doc, zzWXJ runPr) {
        super(doc, runPr);
        this.zzYmn = doc.zzXmF();
    }

    public Comment(DocumentBase doc) {
        this(doc, "", "", zzWR6.zzAq);
    }

    private Comment(DocumentBase doc, String author, String initial, zzWR6 dateTime) {
        this(doc, new zzWXJ());
        this.setAuthor(author);
        this.setInitial(initial);
        zzWR6 zzWR62 = dateTime;
        Comment comment = this;
        this.zzYtF = zzWR62;
        this.getFont().setStyleIdentifier(39);
    }

    public Comment(DocumentBase doc, String author, String initial, Date dateTime) {
        this(doc, author, initial, zzWR6.zzXK2(dateTime));
    }

    @Override
    public final int getNodeType() {
        return 19;
    }

    @Override
    public final int getStoryType() {
        return 4;
    }

    public final int getId() {
        return this.zzYmn;
    }

    public final void setId(int value) {
        this.zzYmn = value;
        if (this.getDocument() != null) {
            this.getDocument().zzs3();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getIdInternal() {
        return this.getId();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setIdInternal(int value) {
        this.setId(value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getParentIdInternal() {
        return this.getParentId();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setParentIdInternal(int value) {
        this.setParentId(value);
    }

    public final String getInitial() {
        return this.zzXpv;
    }

    public final void setInitial(String value) {
        zzYb0.zzWS3((Object)value, "Initial");
        this.zzXpv = value;
    }

    public final Date getDateTime() {
        Comment comment = this;
        return zzWR6.zzXFC(comment.zzYtF);
    }

    private void zzZ6B(zzWR6 zzWR62) {
        this.zzYtF = zzWR62;
        if (!zzWR6.zzXK2(this.zzW49, zzWR6.zzAq)) {
            this.zzW49 = !zzWR6.zzXK2(zzWR62, zzWR6.zzAq) ? zzWR62.zz9a() : zzWR6.zzAq;
        }
    }

    public final void setDateTime(Date value) {
        this.zzZ6B(zzWR6.zzXK2(value));
    }

    final zzWR6 zzX1() {
        return this.zzYtF;
    }

    final void zzkI(zzWR6 zzWR62) {
        this.zzYtF = zzWR62;
    }

    final zzWR6 zzWjw() {
        return this.zzW49;
    }

    final void zzY8L(zzWR6 zzWR62) {
        this.zzW49 = zzWR62;
    }

    public final String getAuthor() {
        return this.zzWKC;
    }

    public final void setAuthor(String value) {
        zzYb0.zzWS3((Object)value, "Author");
        this.zzWKC = value;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    private Comment zzXK2(String string, String string2, zzWR6 zzWR62, String string3) throws Exception {
        if (this.getParentId() != -1) {
            throw new IllegalStateException("Cannot add a reply to another reply.");
        }
        if (this.getParentNode() == null) {
            throw new IllegalStateException("No parent node.");
        }
        Comment comment = new Comment(this.getDocument(), string, string2, zzWR62);
        comment.setIdInternal(zz2d.zzXK2(this.getDocument()));
        comment.setParentId(this.zzYmn);
        comment.setText(string3);
        Comment comment2 = this;
        Comment comment3 = zzYb0.zzXK2((Object)this.zzYzg(), Comment.class);
        while (comment3 != null && comment3.getParentId() == this.zzYmn) {
            comment2 = comment3;
            comment3 = zzYb0.zzXK2((Object)comment3.zzYzg(), Comment.class);
        }
        this.getParentNode().insertAfter(comment, comment2);
        zzW7R zzW7R2 = new zzW7R();
        if (zzW7R2.zzWS3(this.getDocument(), this.zzYmn)) {
            this.zzXK2(zzW7R2.zz0a(), new CommentRangeStart(this.getDocument(), comment.getId()));
            this.zzXK2(zzW7R2.zzWmp(), new CommentRangeEnd(this.getDocument(), comment.getId()));
        }
        return comment;
    }

    public final Comment addReply(String author, String initial, Date dateTime, String text) throws Exception {
        return this.zzXK2(author, initial, zzWR6.zzXK2(dateTime), text);
    }

    private void zzXK2(CommentRangeStart commentRangeStart, CommentRangeStart commentRangeStart2) {
        Node node2;
        ArrayList arrayList = new ArrayList();
        for (Node node2 : this.getReplies()) {
            zz9j.zzXK2(arrayList, Integer.valueOf(node2.getId()));
        }
        Object object = commentRangeStart;
        while (((Node)object).getNextSibling() != null && ((Node)(node2 = ((Node)object).getNextSibling())).getNodeType() == 33 && arrayList.contains(((CommentRangeStart)node2).getId())) {
            object = node2;
        }
        ((Node)object).zzJO(commentRangeStart2);
    }

    private void zzXK2(CommentRangeEnd commentRangeEnd, CommentRangeEnd commentRangeEnd2) {
        ArrayList arrayList = new ArrayList();
        for (Node node : this.getReplies()) {
            if (((Comment)node).getId() == commentRangeEnd2.getId()) continue;
            zz9j.zzXK2(arrayList, Integer.valueOf(((Comment)node).getId()));
        }
        Object object = commentRangeEnd;
        while (((Node)object).getNextSibling() != null) {
            int n;
            Node node;
            node = ((Node)object).getNextSibling();
            if (node.getNodeType() == 34) {
                n = ((CommentRangeEnd)node).getId();
            } else {
                if (node.getNodeType() != 19) break;
                n = ((Comment)node).getId();
            }
            if (!arrayList.contains(n) && n != this.zzYmn) break;
            object = node;
        }
        ((Node)object).zzJO(commentRangeEnd2);
    }

    public final void removeReply(Comment reply) throws Exception {
        zzW7R zzW7R2 = new zzW7R();
        if (zzW7R2.zzWS3(this.getDocument(), reply.getId())) {
            zzW7R2.zz0a().remove();
            zzW7R2.zzWmp().remove();
        }
        reply.remove();
    }

    public final void removeAllReplies() throws Exception {
        for (Comment comment : this.getReplies().zzYMp()) {
            this.removeReply(comment);
        }
    }

    @Override
    public final int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitCommentStart(this);
    }

    @Override
    public final int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitCommentEnd(this);
    }

    public final void setText(String text) {
        this.removeAllChildren();
        Paragraph paragraph = new Paragraph(this.getDocument());
        paragraph.getParagraphFormat().setStyleIdentifier(30);
        this.appendChild(paragraph);
        DocumentBuilder documentBuilder = new DocumentBuilder(this.zzZWj());
        documentBuilder.moveTo(paragraph);
        SpecialChar specialChar = new SpecialChar(this.zzZWj(), '\u0005', new zzWXJ());
        specialChar.getFont().setStyleIdentifier(39);
        documentBuilder.insertNode(specialChar);
        documentBuilder.write(text);
    }

    public final Comment getAncestor() {
        if (this.getDocument() == null || this.getParentId() == -1) {
            return null;
        }
        for (Comment comment : this.getDocument().getChildNodes(19, true)) {
            if (comment.getId() != this.getParentId()) continue;
            return comment;
        }
        return null;
    }

    public final CommentCollection getReplies() {
        if (this.zzWQD == null) {
            this.zzWQD = new CommentCollection(this.getDocument(), this);
        }
        return this.zzWQD;
    }

    public final boolean getDone() {
        return this.zzWms;
    }

    public final void setDone(boolean value) {
        this.zzWms = value;
    }

    public final int getParentId() {
        return this.zzYbe;
    }

    public final void setParentId(int value) {
        this.zzYbe = value;
        if (this.getDocument() != null) {
            this.getDocument().zzs3();
        }
    }

    final int zzWUQ() {
        return this.zzZKJ;
    }

    final void zzYrg(int n) {
        this.zzZKJ = n;
    }

    final boolean zzYgz() {
        return this.zzZpZ;
    }

    final void zzW7R(boolean bl) {
        this.zzZpZ = bl;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzTf getMoveFromRevision() {
        return this.zzYBa().getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveFromRevision(zzTf value) {
        zzTf zzTf2 = value;
        zzWXJ zzWXJ2 = this.zzYBa();
        zzWXJ2.zzYU(13, zzTf2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzTf getMoveToRevision() {
        return this.zzYBa().getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveToRevision(zzTf value) {
        zzTf zzTf2 = value;
        zzWXJ zzWXJ2 = this.zzYBa();
        zzWXJ2.zzYU(15, zzTf2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void removeMoveRevisions() {
        this.zzYBa().remove(13);
        this.zzYBa().remove(15);
    }

    final String zzWCF() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzUv(stringBuilder);
        if (stringBuilder.length() > 0 && stringBuilder.charAt(0) == '\u0005') {
            stringBuilder.delete(0, 1);
        }
        return stringBuilder.toString();
    }
}

