/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartDataPointCollection;
import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzWR6;
import com.aspose.words.zzVRU;
import com.aspose.words.zzW12;
import com.aspose.words.zzWJ9;
import com.aspose.words.zzWaX;
import com.aspose.words.zzX14;
import com.aspose.words.zzX3B;
import com.aspose.words.zzXNq;
import com.aspose.words.zzXOq;
import com.aspose.words.zzYi2;
import com.aspose.words.zzYsk;
import com.aspose.words.zzYyL;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzX14 zzVWm;

    ChartSeriesCollection(zzX14 chartSpace) {
        this.zzVWm = chartSpace;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzYjL().zzYIm().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzYjL().zzYIm().iterator();
    }

    public void removeAt(int index) {
        this.zzYjL().zz6h(index);
    }

    public void clear() {
        this.zzYjL().zzX7o();
        for (zzWJ9 zzWJ92 : this.zzVWm.zzWY9()) {
            zzWJ92.zzjN(false);
        }
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXK2(chartSeriesCollection.zzYjL().zzXsX(), seriesName, categories, values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXK2(chartSeriesCollection.zzYjL().zzXsX(), seriesName, xValues, yValues);
    }

    private ChartSeries zzXK2(String string, zzWR6[] zzWR6Array, double[] dArray) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXK2(chartSeriesCollection.zzYjL().zzXsX(), string, zzWR6Array, dArray);
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzXK2(seriesName, zzWR6.zzXK2(dates), values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXK2(chartSeriesCollection.zzYjL().zzXsX(), seriesName, xValues, yValues, bubbleSizes);
    }

    final ChartSeries zzXK2(zzWJ9 zzWJ92, String string, String[] stringArray, double[] dArray) {
        if (stringArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (stringArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (stringArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXK2(zzWJ92, string, dArray);
        chartSeries.zzoi().zzYtJ(ChartSeriesCollection.zzWDj(stringArray));
        return chartSeries;
    }

    final ChartSeries zzXK2(zzWJ9 zzWJ92, String string, double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXK2(zzWJ92, string, dArray2);
        chartSeries.zzoi().zzYtJ(ChartSeriesCollection.zzVWC(dArray));
        return chartSeries;
    }

    private ChartSeries zzXK2(zzWJ9 zzWJ92, String string, zzWR6[] zzWR6Array, double[] dArray) {
        if (zzWR6Array == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzWR6Array.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzWR6Array.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXK2(zzWJ92, string, dArray);
        chartSeries.zzoi().zzYtJ(ChartSeriesCollection.zzXK2(zzWR6Array));
        if (!zzWJ92.zzZnW()) {
            zzWJ92.zzjN(true);
        }
        return chartSeries;
    }

    final ChartSeries zzXK2(zzWJ9 zzWJ92, String string, double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (zzWJ92.zzWYO() != 15) {
            zzWJ92.zzYgl(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzXK2(zzWJ92, string, dArray2);
        chartSeries.zzZf5().zzYy6().zzXFC(3, chartSeries.zzbp().zzWwX());
        chartSeries.zzoi().zzYtJ(ChartSeriesCollection.zzVWC(dArray));
        if (dArray3 != null) {
            chartSeries.zzZSI().zzYtJ(ChartSeriesCollection.zzVWC(dArray3));
        }
        return chartSeries;
    }

    private ChartSeries zzXK2(zzWJ9 zzWJ92, String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(zzWJ92);
        chartSeries.setName(string);
        ChartSeriesCollection.zzYbj(chartSeries);
        chartSeries.zzkK().zzYtJ(ChartSeriesCollection.zzVWC(dArray));
        this.zzVWm.zzWSU();
        this.zzYjL().zzwi(chartSeries);
        return chartSeries;
    }

    private static void zzYbj(ChartSeries chartSeries) {
        chartSeries.zzZf5().zzYy6().zzXFC(5, new zzWaX());
        if (ChartDataPointCollection.zzY1d(chartSeries.zzbp().zzWYO())) {
            chartSeries.setInvertIfNegative(false);
        }
        switch (chartSeries.zzbp().zzWYO()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzXK2(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzXK2(chartSeries, 5);
                ChartSeriesCollection.zzOT(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzXK2(chartSeries, 1);
                ChartSeriesCollection.zzOT(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzYU(chartSeries);
            }
        }
    }

    private static void zzYU(ChartSeries chartSeries) {
        zzWaX zzWaX2 = new zzWaX();
        zzWaX2.setOutline(new zzW12());
        zzYsk zzYsk2 = new zzYsk();
        zzYsk2.zzWlK(1);
        zzWaX2.getOutline().setFill(new zzXNq(zzYsk2));
        zzWaX2.getOutline().zz2d(19050.0);
        chartSeries.zzZf5().zzYy6().zzXFC(5, zzWaX2);
    }

    private static void zzOT(ChartSeries chartSeries) {
        zzWaX zzWaX2 = new zzWaX();
        zzWaX2.setOutline(new zzW12());
        zzWaX2.getOutline().setFill(new zzYi2());
        zzWaX2.getOutline().setEndCap(0);
        zzWaX2.getOutline().zz2d(19050.0);
        chartSeries.zzZf5().zzYy6().zzXFC(5, zzWaX2);
    }

    private static void zzXK2(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzbp());
        chartMarker.zzYvj().zzXFC(0, n);
        chartSeries.zzZf5().zzYy6().zzXFC(4, chartMarker);
    }

    private static zzVRU zzVWC(double[] dArray) {
        int n = 0;
        zzVRU zzVRU2 = new zzVRU(2);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzVRU2.zzW7T(new zzXOq(n, d, "General"));
            }
            ++n;
        }
        zzVRU2.zzX5y(dArray.length);
        return zzVRU2;
    }

    private static zzVRU zzXK2(zzWR6[] zzWR6Array) {
        int n = 0;
        zzVRU zzVRU2 = new zzVRU(2);
        zzWR6[] zzWR6Array2 = zzWR6Array;
        int n2 = zzWR6Array.length;
        for (int i = 0; i < n2; ++i) {
            zzWR6 zzWR62 = zzWR6Array2[i];
            zzVRU2.zzW7T(new zzXOq(n++, zzWR62.zzWl6(), "m/d/yyyy"));
        }
        zzVRU2.zzX5y(zzWR6Array.length);
        return zzVRU2;
    }

    private static zzVRU zzWDj(String[] stringArray) {
        int n = 0;
        zzVRU zzVRU2 = new zzVRU(1);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzVRU2.zzW7T(new zzYyL(n++, string));
        }
        zzVRU2.zzX5y(stringArray.length);
        return zzVRU2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzYjL().zzYIm().size();
    }

    private zzX3B zzYjL() {
        return this.zzVWm.zzYM8().zzYjL();
    }
}

