/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzWxE;
import com.aspose.words.internal.zzXgH;
import com.aspose.words.internal.zzZgK;
import com.aspose.words.internal.zzZs7;
import com.aspose.words.internal.zzZwy;
import com.aspose.words.internal.zzg3;
import com.aspose.words.internal.zzii;
import com.aspose.words.zzXy0;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzHa;
    private zzXy0 zzWKe;

    Watermark(Document doc, zzXy0 watermarkProvider) {
        this.zzHa = doc;
        this.zzWKe = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzXCB(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzXDP(text, textWatermarkOptions, this.zzHa);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzZwy.zzYMQ((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzHa, 75);
        shape.getImageData().setImage(image);
        this.zzXDP(shape, options, this.zzHa);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzZwy.zzYMQ((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzHa, 75);
        shape.getImageData().setImage(imagePath);
        this.zzXDP(shape, options, this.zzHa);
    }

    public final int getType() {
        Shape shape = this.zzWKe.get();
        if (shape == null) {
            return 2;
        }
        shape.zzWAv();
        if (shape.zzW6Y()) {
            return 0;
        }
        if (shape.zzZPb()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzWKe.add(shape);
    }

    public final void remove() {
        this.zzWKe.remove();
    }

    private static void zzXCB(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (zzii.zzWqD(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzZwy.zzXDP(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzXDP(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzYMQ(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzWtP(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzYMQ(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzZsy() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzeL()) / d2) > (double)(f = pageSetup.zzZ1S())) {
            d = (double)f / d3;
        }
        shape.zzZrS(zzg3.zzYeh(d2 * d, 2, zzZs7.zzYn0));
        shape.zzvB(zzg3.zzYeh(d3 * d, 2, zzZs7.zzYn0));
    }

    private Shape zzXDP(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzXDP(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzWtP(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzXDP(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzLr() ? 1.0f : textWatermarkOptions.getFontSize();
        zzZgK zzZgK2 = document.zzYQD().zzYeh(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzZgK2.zzW8N(shape.getTextPath().getText());
        if (textWatermarkOptions.zzLr()) {
            l = Watermark.zzXDP(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzZrS(zzg3.zzYeh(Float.intBitsToFloat(n), 2, zzZs7.zzYn0));
        shape.zzvB(zzg3.zzYeh(zzWxE.zz2k(l), 2, zzZs7.zzYn0));
    }

    private static long zzXDP(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzeL();
        float f2 = pageSetup.zzZ1S();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzWxE.zz2k(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzWxE.zzXw2(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzWxE.zz2k(l) >= Float.intBitsToFloat(n)) {
            return zzWxE.zzXw2(f2 / f3, f2);
        }
        float f6 = f;
        return zzWxE.zzXw2(f6, f6 * f3);
    }

    private static void zzWtP(Shape shape, String string) {
        shape.setName(zzXgH.zzYMQ("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
        shape.setBehindText(true);
    }
}

