/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzXgH;
import com.aspose.words.internal.zzZwy;
import com.aspose.words.zzCk;
import com.aspose.words.zzVS2;
import com.aspose.words.zzf2;

public final class Section
extends CompositeNode<Node>
implements zzCk {
    private zzf2 zzZiM;
    private PageSetup zz2T;
    private HeaderFooterCollection zzZZG;

    public Section(DocumentBase doc) {
        this(doc, new zzf2());
    }

    Section(DocumentBase doc, zzf2 sectPr) {
        super(doc);
        this.zzZiM = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzZZG == null) {
            this.zzZZG = new HeaderFooterCollection(this);
        }
        return this.zzZZG;
    }

    public final PageSetup getPageSetup() {
        if (this.zz2T == null) {
            Section section = this;
            this.zz2T = new PageSetup(section, section.getDocument().zzVQX(), this.getDocument().getStyles(), new zzXDP(this));
        }
        return this.zz2T;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzKd();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzZ7S(!value);
    }

    final zzf2 zzWS7() {
        return this.zzZiM;
    }

    final void zzYeh(zzf2 zzf22) {
        this.zzZiM = zzf22;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzXDP(boolean bl, zzVS2 zzVS22) {
        zzf2 zzf22;
        Section section = (Section)super.zzXDP(bl, zzVS22);
        zzf2 zzf23 = this.zzZiM;
        section.zzZiM = zzf22 = (zzf2)zzf23.zzWst();
        section.zz2T = null;
        section.zzZZG = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzXDP(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzYMQ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzWOR(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzWOR(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzWX4(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzX8e(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzWX4(n) == null;
            }
        }
        return false;
    }

    final void zzYeh(Shape shape, boolean bl) throws Exception {
        this.zzXDP(shape, 4, bl);
        this.zzXDP(shape, 0, bl);
        this.zzXDP(shape, 1, bl);
    }

    private void zzXDP(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzWJU());
        shape2.setName(zzXgH.zzYMQ("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final void zzl9() {
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzZ4L()) {
                if (!shape.zzWAv()) continue;
                shape.remove();
            }
        }
    }

    private void zzWOR(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzYMQ(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzZiM.zzWyq(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzVQX().zzZXe.zzBO(key);
        }
        return zzf2.zzZcL(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzZiM.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzVQX().zzZXe.zzZNm(key, value);
            return;
        }
        this.zzZiM.zzZNm(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzZiM.clear();
    }

    final boolean zzXHN() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzAF() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        return super.toString();
    }

    static final class zzXDP
    implements zzCk {
        private Section zzXoM;

        zzXDP(Section section) {
            this.zzXoM = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzJo().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzJo().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzJo().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzCk zzJo() {
            Document document = zzZwy.zzXDP((Object)this.zzXoM.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzXoM;
        }
    }
}

