/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzZQv;
import com.aspose.words.internal.zzZwy;
import com.aspose.words.internal.zzi7;
import com.aspose.words.internal.zzii;
import com.aspose.words.internal.zzod;
import com.aspose.words.internal.zzpG;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzZ97;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzWy0 = new HashMap();
    private static HashMap<Integer, Integer> zzXBx = new HashMap();
    private static HashMap<Integer, Integer> zzZKX = new HashMap();
    private static HashMap<Integer, Integer> zzY2A = new HashMap();
    private static HashMap<Integer, Integer> zzYAm = new HashMap();
    private static HashMap<Integer, Integer> zzYQd = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzZwy.zzYeh(fileName, "fileName");
        try (zzi7 zzi72 = zzZwy.zzZZu(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzW0E(zzi72);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzW0E(zzod.zzXDP(stream));
    }

    static FileFormatInfo zzW0E(zzZQv zzZQv2) throws Exception {
        if (zzZQv2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzZ97 zzZ972 = new zzZ97();
            zzZQv zzZQv3 = zzZQv2;
            zzZ97 zzZ973 = zzZ972;
            return zzZ972.zzYMQ(zzZQv3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzYeh(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzZnx(zzpG.zzVSu(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzZxi(zzpG.zzVSu(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzii.zzWta(string = zzpG.zzZ4K(FileFormatUtil.zznS(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzZnx(FileFormatUtil.zzZ9e(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzZxi(FileFormatUtil.zznS(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzpG.zzZ4K(FileFormatUtil.zzZ9e(saveFormat));
        if (zzii.zzWta(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzZxi(zzpG.zzY56(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzpG.zzZ4K(FileFormatUtil.zzXbJ(imageType));
    }

    static Exception zzYeh(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzXYP(int n) {
        return zzpG.toString(FileFormatUtil.zzZ9e(n));
    }

    static int zzZxi(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzZwy.zzXDP(zzYAm, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzVVO(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzZwy.zzXDP(zzYQd, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzfc(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zznS(int n) {
        return zzZwy.zzXDP(zzWy0, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzZ9e(int n) {
        return zzZwy.zzXDP(zzXBx, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzXbJ(int n) {
        return zzZwy.zzXDP(zzZKX, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzZnx(int n) {
        return zzZwy.zzXDP(zzY2A, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzXgO(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzZwy.zzYMQ(zzYAm, Integer.valueOf(n), Integer.valueOf(n2));
            zzZwy.zzYMQ(zzXBx, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzY2A.containsKey(n)) {
                zzZwy.zzYMQ(zzY2A, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzZwy.zzYMQ(zzWy0, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzZwy.zzYMQ(zzYQd, Integer.valueOf(n), Integer.valueOf(n4));
            zzZwy.zzYMQ(zzZKX, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzXgO(11, 10, 10, 1);
        FileFormatUtil.zzXgO(11, 0, 0, 1);
        FileFormatUtil.zzXgO(12, 11, 11, 1);
        FileFormatUtil.zzXgO(13, 20, 20, 1);
        FileFormatUtil.zzXgO(13, 0, 254, 1);
        FileFormatUtil.zzXgO(14, 21, 21, 1);
        FileFormatUtil.zzXgO(15, 22, 22, 1);
        FileFormatUtil.zzXgO(16, 23, 23, 1);
        FileFormatUtil.zzXgO(18, 24, 24, 1);
        FileFormatUtil.zzXgO(19, 25, 25, 1);
        FileFormatUtil.zzXgO(20, 26, 26, 1);
        FileFormatUtil.zzXgO(21, 27, 27, 1);
        FileFormatUtil.zzXgO(24, 30, 30, 1);
        FileFormatUtil.zzXgO(17, 31, 31, 1);
        FileFormatUtil.zzXgO(25, 50, 50, 1);
        FileFormatUtil.zzXgO(26, 45, 255, 1);
        FileFormatUtil.zzXgO(27, 51, 51, 1);
        FileFormatUtil.zzXgO(28, 0, 52, 1);
        FileFormatUtil.zzXgO(29, 0, 53, 1);
        FileFormatUtil.zzXgO(31, 53, 54, 1);
        FileFormatUtil.zzXgO(22, 60, 60, 1);
        FileFormatUtil.zzXgO(23, 61, 61, 1);
        FileFormatUtil.zzXgO(34, 40, 64, 1);
        FileFormatUtil.zzXgO(41, 47, 255, 1);
        FileFormatUtil.zzXgO(42, 48, 255, 1);
        FileFormatUtil.zzXgO(35, 41, 255, 1);
        FileFormatUtil.zzXgO(36, 46, 255, 1);
        FileFormatUtil.zzXgO(38, 42, 255, 1);
        FileFormatUtil.zzXgO(37, 44, 255, 1);
        FileFormatUtil.zzXgO(30, 52, 55, 1);
        FileFormatUtil.zzXgO(32, 70, 62, 1);
        FileFormatUtil.zzXgO(33, 73, 63, 1);
        FileFormatUtil.zzXgO(39, 71, 255, 1);
        FileFormatUtil.zzXgO(8, 100, 255, 1);
        FileFormatUtil.zzXgO(9, 105, 255, 1);
        FileFormatUtil.zzXgO(6, 101, 255, 6);
        FileFormatUtil.zzXgO(7, 102, 255, 7);
        FileFormatUtil.zzXgO(5, 104, 255, 5);
        FileFormatUtil.zzXgO(4, 0, 255, 4);
        FileFormatUtil.zzXgO(3, 0, 255, 3);
        FileFormatUtil.zzXgO(40, 72, 255, 1);
        FileFormatUtil.zzXgO(2, 103, 255, 2);
    }
}

