/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.internal.zzWL8;
import com.aspose.words.internal.zzZwy;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzW56;
import java.awt.Color;
import java.util.Iterator;

public final class BorderCollection
implements Iterable<Border> {
    private zzW56 zzWDo;

    BorderCollection(zzW56 parent) {
        this.zzWDo = parent;
    }

    public final boolean equals(BorderCollection brColl) throws Exception {
        if (zzZwy.zzcs(this, brColl)) {
            return true;
        }
        return this.getLeft().equals(brColl.getLeft()) && this.getRight().equals(brColl.getRight()) && this.getTop().equals(brColl.getTop()) && this.getBottom().equals(brColl.getBottom()) && this.getHorizontal().equals(brColl.getHorizontal()) && this.getVertical().equals(brColl.getVertical()) && this.getColor().equals(brColl.getColor()) && this.zzYmL().equals(brColl.zzYmL()) && this.getDistanceFromText() == brColl.getDistanceFromText() && this.getLineWidth() == brColl.getLineWidth() && this.getLineStyle() == brColl.getLineStyle() && this.getCount() == brColl.getCount() && this.getShadow() == brColl.getShadow() && this.isVisible() == brColl.isVisible();
    }

    public final Border getByBorderType(int borderType) throws Exception {
        RefInt refInt = new RefInt(0);
        boolean bl = !this.zzWDo.getPossibleBorderKeys().zzXDP(borderType, refInt);
        int borderKey = refInt.get();
        if (bl) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        Border border = (Border)this.zzWDo.getDirectBorderAttr(borderKey);
        if (border == null) {
            border = new Border(this.zzWDo, borderKey);
            this.zzWDo.setBorderAttr(borderKey, border);
        }
        return border;
    }

    public final Border get(int index) throws Exception {
        int n = this.zzWDo.getPossibleBorderKeys().zzYso().get(index);
        return this.getByBorderType(n);
    }

    public final Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public final Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public final Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public final Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public final Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public final Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public final int getCount() {
        return this.zzWDo.getPossibleBorderKeys().getCount();
    }

    public final double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public final void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzWDo.getPossibleBorderKeys().zzYso().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzXDG(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public final int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public final void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzWDo.getPossibleBorderKeys().zzYso().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzXDG(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public final Color getColor() throws Exception {
        return this.zzYmL().zzZ3e();
    }

    public final void setColor(Color value) throws Exception {
        this.zz80(zzWL8.zzXDP(value));
    }

    private zzWL8 zzYmL() throws Exception {
        return this.get(0).zzYmL();
    }

    private void zz80(zzWL8 zzWL82) throws Exception {
        Iterator iterator = this.zzWDo.getPossibleBorderKeys().zzYso().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzXDG(n)) continue;
            this.getByBorderType(n).zz80(zzWL82);
        }
    }

    public final double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public final void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzWDo.getPossibleBorderKeys().zzYso().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzXDG(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public final boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public final void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzWDo.getPossibleBorderKeys().zzYso().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzXDG(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public final void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public final Iterator<Border> iterator() {
        return new zzXDP(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzXDG(int n) {
        return n != 6 && n != 7;
    }

    static final class zzXDP
    implements Iterator<Border> {
        private BorderCollection zzWxw;
        private int zzZxU;

        zzXDP(BorderCollection borderCollection) {
            this.zzWxw = borderCollection;
            this.zzZxU = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzZxU >= this.zzWxw.getCount() - 1) {
                return false;
            }
            ++this.zzZxU;
            return true;
        }

        private Border zzZXO() {
            try {
                return this.zzWxw.get(this.zzZxU);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            return this.zzZXO();
        }
    }
}

