/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzA2;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzO3;
import com.aspose.words.net.System.Data.zzXJV;
import com.aspose.words.net.System.Data.zzYTv;
import com.aspose.words.net.System.Data.zzZM5;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzZuM;
    private final DataColumnCollection zzXER;
    private final ConstraintCollection zzX5o;
    private final zzXJV zzY7v;
    private ResultSet zzWSa;
    private String zzXoP;
    private DataSet zzZfS;
    private String zzWU1;
    private UniqueConstraint zzWIY;
    private boolean zzXtX;
    private final List<DataTableEventListener> zzt8;
    private final Set<DataRow> zzZnm;
    private DataRelationCollection zzZ3Z;

    public DataTable() {
        this.zzZuM = new DataRowCollection(this);
        this.zzXER = new DataColumnCollection(this);
        this.zzX5o = new ConstraintCollection(this);
        this.zzY7v = new zzXJV(this);
        this.zzWU1 = "";
        this.zzXtX = true;
        this.zzt8 = new ArrayList<DataTableEventListener>();
        this.zzZnm = new HashSet<DataRow>();
        this.zzZ3Z = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzZuM = new DataRowCollection(this);
        this.zzXER = new DataColumnCollection(this);
        this.zzX5o = new ConstraintCollection(this);
        this.zzY7v = new zzXJV(this);
        this.zzWU1 = "";
        this.zzXtX = true;
        this.zzt8 = new ArrayList<DataTableEventListener>();
        this.zzZnm = new HashSet<DataRow>();
        this.zzZ3Z = new DataRelationCollection();
        this.zzXoP = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzO3.zzYIY(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzZuM = new DataRowCollection(this);
        this.zzXER = new DataColumnCollection(this);
        this.zzX5o = new ConstraintCollection(this);
        this.zzY7v = new zzXJV(this);
        this.zzWU1 = "";
        this.zzXtX = true;
        this.zzt8 = new ArrayList<DataTableEventListener>();
        this.zzZnm = new HashSet<DataRow>();
        this.zzZ3Z = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzWSa = resultSet;
        this.zzXoP = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzWSa != null) {
            if (this.zzWSa.getStatement() != null) {
                this.zzWSa.getStatement().getConnection().close();
            }
            this.zzWSa = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzXoP;
    }

    public void setTableName(String tableName) {
        this.zzXoP = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzXER.getCount();
    }

    public String getColumnName(int index) {
        return this.zzXER.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzWSa;
    }

    public DataSet getDataSet() {
        return this.zzZfS;
    }

    final void zz1O(DataSet dataSet) {
        this.zzZfS = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzZfS.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzZ3Z.add(dataRelation);
        }
        return this.zzZ3Z;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzZfS.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzZuM;
    }

    public DataColumnCollection getColumns() {
        return this.zzXER;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzX5o;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzWIY == null) {
            return new DataColumn[0];
        }
        return this.zzWIY.getColumns();
    }

    final void zzXJV(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzWIY != null) {
                this.zzWIY.zzXmM(false);
                this.getConstraints().remove(this.zzWIY);
                this.zzWIY = null;
            }
            return;
        }
        if (this.zzWIY != null && DataColumn.areColumnSetsTheSame(value, this.zzWIY.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzYIY(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzWIY != null) {
            this.zzWIY.zzXmM(false);
            this.getConstraints().remove(this.zzWIY);
            this.zzWIY = null;
        }
        UniqueConstraint.zzYIY(this.getConstraints(), uniqueConstraint);
        this.zzWIY = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzWU1;
    }

    public void setNamespace(String namespace) {
        this.zzWU1 = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzXtX;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzXtX = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzZnm.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzO3.zzYIY(this.getResultSet(), this);
            zzO3.zzO3(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzA2.zz1O(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzO3.zzVOB(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzt8.contains(listener)) {
            this.zzt8.add(listener);
        }
    }

    public void removeEventListener(zzZM5 listener) {
        if (this.zzt8.contains(listener)) {
            this.zzt8.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzt8.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzZnm.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzt8) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzZnm.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzt8) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzZnm.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzt8) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzt8) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzt8) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzYTv zzYIY(zzO3[] zzO3Array) {
        DataColumn[] dataColumnArray = new DataColumn[zzO3Array.length];
        for (int i = 0; i < zzO3Array.length; ++i) {
            dataColumnArray[i] = zzO3Array[i].zzXnc();
        }
        DataTable dataTable = this;
        zzYTv zzYTv2 = dataTable.zzY7v.zz1O(dataColumnArray);
        if (zzYTv2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzYTv2;
    }

    final zzXJV zzZRe() {
        return this.zzY7v;
    }

    final Set<DataRow> zzWpl() {
        return this.zzZnm;
    }
}

