/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzVW0;
import com.aspose.words.internal.zzW2e;
import com.aspose.words.internal.zzWGP;
import com.aspose.words.internal.zzWuD;
import com.aspose.words.internal.zzX6b;
import com.aspose.words.internal.zzXaO;
import com.aspose.words.internal.zzYR5;
import com.aspose.words.internal.zzZzN;
import com.aspose.words.internal.zzau;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzZrk
extends CertPathBuilderSpi {
    private final zzZzN zzVYr;
    private zzau zzYia;

    zzZrk(zzZzN zzZzN2) {
        this.zzVYr = zzZzN2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzYR5 pkixParams;
        if (params instanceof zzYR5) {
            pkixParams = (zzYR5)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzYR5.zzYIY((PKIXBuilderParameters)params).zzWpD();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzYR5.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzXaO zzXaO2 = pkixParams.zzWwB().zzZbX();
        try {
            collection = zzW2e.zzYIY(zzXaO2, pkixParams.zzWwB().zzZYB());
            collection.addAll(zzW2e.zzYIY(zzXaO2, pkixParams.zzWwB().zzZlg()));
        }
        catch (zzau zzau2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzau2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzYIY(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzYia != null) {
            throw new CertPathBuilderException(this.zzYia.getMessage(), this.zzYia.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzYIY(X509Certificate x509Certificate, zzYR5 zzYR52, List list) throws CertPathBuilderException {
        zzWGP zzWGP2;
        zzVW0 zzVW02;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzYR52.zzWYs().contains(x509Certificate)) {
            return null;
        }
        if (zzYR52.zzXUY() != -1 && list.size() - 1 > zzYR52.zzXUY()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzVW02 = new zzVW0(this.zzVYr);
            zzWGP2 = new zzWGP(this.zzVYr);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzW2e.zzYIY(x509Certificate, zzYR52.zzWwB().zzYn8(), zzYR52.zzWwB().zzW7W()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzVW02.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzau("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzWGP2.engineValidate(certPath, zzYR52);
                }
                catch (Exception exception) {
                    throw new zzau("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzWuD> arrayList = new ArrayList<zzWuD>();
            arrayList.addAll(zzYR52.zzWwB().zzZYB());
            try {
                arrayList.addAll(zzW2e.zzYIY(x509Certificate.getExtensionValue(zzX6b.zzZTQ.getId()), zzYR52.zzWwB().zzYl9()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzau("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzW2e.zzYIY(x509Certificate, zzYR52.zzWwB().zzZlg(), arrayList));
            }
            catch (zzau zzau2) {
                throw new zzau("Cannot find issuer certificate for certificate in certification path.", zzau2);
            }
            if (hashSet.isEmpty()) {
                throw new zzau("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzYIY(x509Certificate2, zzYR52, list);
            }
        }
        catch (zzau zzau3) {
            this.zzYia = zzau3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

