/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzXlW;
import com.aspose.words.internal.zzYfJ;

public abstract class SaveOptions {
    private boolean zzZBE;
    private IDocumentSavingCallback zzZdo;
    private boolean zzYzo = true;
    private boolean zzZRN = false;
    private boolean zzYHJ = true;
    private boolean zzM7;
    private String zzYiC;
    private boolean zzZkP;
    private boolean zzYdS = false;
    private boolean zzec = true;
    private int zzW8C = 1;
    private int zzWlz = 1;
    private int zz0L = 0;
    private String zzYFB = "";
    private boolean zzYXn = true;
    private boolean zzVTM = true;
    private boolean zzYP3;
    private boolean zzZae;
    private int zzHy = 0;
    private boolean zzVYq = true;
    private boolean zzWLE = false;
    boolean zzW8b = true;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzXpe() {
        return false;
    }

    boolean zzZ5g() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzYHJ;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzYHJ = value;
    }

    public String getTempFolder() {
        return this.zzYiC;
    }

    public void setTempFolder(String value) {
        this.zzYiC = value;
    }

    public boolean getPrettyFormat() {
        return this.zzM7;
    }

    public void setPrettyFormat(boolean value) {
        this.zzM7 = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzZkP;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzZkP = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzYdS;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzYdS = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzec;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzec = value;
    }

    public int getDmlRenderingMode() {
        return this.zzW8C;
    }

    public void setDmlRenderingMode(int value) {
        this.zzW8C = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zz0L;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zz0L = value;
    }

    public int getImlRenderingMode() {
        return this.zzWlz;
    }

    public void setImlRenderingMode(int value) {
        this.zzWlz = value;
    }

    public String getDefaultTemplate() {
        return this.zzYFB;
    }

    public void setDefaultTemplate(String value) {
        this.zzYFB = value;
    }

    public boolean getUpdateFields() {
        return this.zzYXn;
    }

    public void setUpdateFields(boolean value) {
        this.zzYXn = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzYP3;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzYP3 = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzZae;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzZae = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzWLE;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzWLE = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzZRN;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzZRN = value;
    }

    final boolean zzZON() {
        return this.zzVTM;
    }

    final boolean zzow() {
        return this.zzVYq;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzr(zzXlW.zz0u(zzYfJ.zzX1v(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzHy;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzHy = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzZdo;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzZdo = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzZBE;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzZBE = value;
    }

    @Deprecated
    public boolean getFlatOpcXmlMappingOnly() {
        return this.zzW8b;
    }

    @Deprecated
    public void setFlatOpcXmlMappingOnly(boolean value) {
        this.zzW8b = value;
    }

    final boolean zzXLn() {
        return this.zzYzo;
    }
}

