/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzWlQ;
import com.aspose.words.internal.zzZxK;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzW9p;
import com.aspose.words.zzXPG;
import com.aspose.words.zzY1i;
import com.aspose.words.zzZsm;
import com.aspose.words.zzq6;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzXWe;
    private Node zzlO;
    private Node zzXdH;
    private int zzdT;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzZM5(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzXWe == null) {
            return null;
        }
        if (this.zzXWe.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzXWe;
    }

    final CompositeNode zzOe() {
        if (zzZsm.zzZV1(this.getParentNode())) {
            return this.getParentNode().zzOe();
        }
        return this.getParentNode();
    }

    final CompositeNode zzRq() {
        if (zzZsm.zzZV1(this.getParentNode()) || zzZsm.zzXzE(this.getParentNode())) {
            return this.getParentNode().zzRq();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzXWe != null) {
            return this.zzXWe.getDocument();
        }
        return null;
    }

    final Document zzZWS() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzLL() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzWCc();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzXdH;
    }

    final Node zzWlN() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzZsm.zzZXW((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzYy8() {
        Node node = zzZsm.zzYMa(this.getPreviousSibling(), false);
        if (node == null && zzZsm.zzZV1(this.getParentNode())) {
            node = this.getParentNode().zzYy8();
        }
        return node;
    }

    final Node zzZm4() {
        Node node = zzZsm.zzpB(this.getNextSibling(), false);
        if (node == null && zzZsm.zzZV1(this.getParentNode())) {
            node = this.getParentNode().zzZm4();
        }
        return node;
    }

    final CompositeNode zzcR() {
        Node node = this;
        while ((node = node.zzYy8()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzWL() {
        Node node = this;
        while ((node = node.zzZm4()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzlO;
    }

    final Node zzXuz() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzZsm.zzZXW((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzYtO() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzX4b() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzY5M() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzZsm.zzZZ0(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzWa2() {
        return this.zzlO;
    }

    final void zzWbz(Node node) {
        this.zzlO = node;
    }

    final Node zzE9() {
        return this.zzXdH;
    }

    final void zzBj(Node node) {
        this.zzXdH = node;
    }

    final Node zzZXn() {
        Node node = this;
        if (node.zzlO != null) {
            node = this;
            return node.zzlO;
        }
        return this.getParentNode();
    }

    final int zzYAg() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzZsm.zzY2s(this);
        boolean bl2 = zzZsm.zzYeJ(this);
        boolean bl3 = zzZsm.zzI8(this);
        boolean bl4 = zzZsm.zzWBD(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzYAg() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzYAg() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzYIY(isCloneChildren, new zzYIY(this));
    }

    Node zzYIY(boolean bl, zzW9p zzW9p2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzXWe != null) {
            node.zzXWe = this.getDocument().zzVZx();
        }
        node.zzlO = null;
        node.zzXdH = null;
        if (zzW9p2 != null) {
            zzW9p2.zz1O(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzXnd(StringBuilder stringBuilder) {
        zzZxK.zzO3(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzT4(Node node) {
        this.zzXWe = node != null ? node : this.getDocument().zzVZx();
    }

    final void zzZM5(DocumentBase documentBase) {
        this.zzXWe = documentBase != null ? documentBase.zzVZx() : null;
    }

    final boolean zzZrz(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzZci() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzXxC(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzXZn(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzZNW(Node node, int n) {
        for (Node node2 = this.nextPreOrder(node); node2 != null; node2 = node2.nextPreOrder(node)) {
            if (node2.getNodeType() != 8) continue;
            return node2;
        }
        return null;
    }

    final Node zzXnd(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzWRg(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzXPG zzXPG2 = zzZsm.zzWFF(saveFormat);
        return zzXPG2.zzXwl(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzXPG zzXPG2 = zzZsm.zzO3(saveOptions);
        return zzXPG2.zzXwl(this);
    }

    final Node zzOK(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzZsm.zzym(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzY1i zzW5f() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzY1i.zzW5N(node);
        }
        return zzY1i.zzYpV(this.getParentNode());
    }

    final zzY1i zzZDF() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzY1i.zzYpV(node);
        }
        return zzY1i.zzW5N(this.getParentNode());
    }

    final boolean zzXLQ(Node node) {
        return Node.zzZzK(this, node);
    }

    final boolean zzWgq() {
        return this.getAncestor(1) == null;
    }

    static Node zzsY(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzWlQ<Node> zzWlQ2 = Node.zz6z(node);
        zzWlQ<Node> zzWlQ3 = Node.zz6z(node2);
        return Node.zzYIY(zzWlQ2, zzWlQ3);
    }

    static boolean zzZzK(Node node, Node node2) {
        zzWlQ<Node> zzWlQ2;
        if (node == null || node2 == null) {
            return false;
        }
        zzWlQ<Node> zzWlQ3 = Node.zz6z(node);
        Node node3 = Node.zzYIY(zzWlQ3, zzWlQ2 = Node.zz6z(node2));
        if (node3 == null) {
            return false;
        }
        zzWlQ<Node> zzWlQ4 = zzWlQ3;
        if (zzWlQ4.size() == 0 || (zzWlQ4 = zzWlQ2).size() == 0) {
            zzWlQ4 = zzWlQ2;
            boolean bl = zzWlQ4.size() > 0;
            return bl;
        }
        Object e = zzWlQ3.peek();
        Object e2 = zzWlQ2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes()) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzWlQ<Node> zz6z(Node node) {
        zzWlQ<Node> zzWlQ2 = new zzWlQ<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzWlQ2.push(node2);
        }
        return zzWlQ2;
    }

    private static Node zzYIY(zzWlQ<Node> zzWlQ2, zzWlQ<Node> zzWlQ3) {
        Node node = null;
        while (zzWlQ2.peek() == zzWlQ3.peek()) {
            node = (Node)zzWlQ2.pop();
            zzWlQ3.pop();
            zzWlQ<Node> zzWlQ4 = zzWlQ2;
            if (zzWlQ4.size() != 0 && (zzWlQ4 = zzWlQ3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzdT;
    }

    public void setCustomNodeId(int value) {
        this.zzdT = value;
    }

    public String toString() {
        return super.toString();
    }

    public void dd() {
    }

    final Node zzym(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzWBD(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzYeJ(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zzWBD(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zzWBD(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zzYIY
    implements zzW9p {
        private Node zzIX;
        private HashMap<Integer, Integer> zzYd0;

        zzYIY(Node node) {
            this.zzIX = node;
        }

        @Override
        public final void zz1O(Node node, Node node2) {
            if (node == this.zzIX) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zzq6 zzq62 = (zzq6)((Object)node2);
            if (this.zzYd0 == null) {
                this.zzYd0 = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zzZxK.zzYIY(this.zzYd0, Integer.valueOf(zzq62.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzWAD();
                zzZxK.zzO3(this.zzYd0, Integer.valueOf(zzq62.getIdInternal()), Integer.valueOf(n));
            }
            zzq62.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zzZxK.zzYIY(this.zzYd0, Integer.valueOf(zzq62.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zzq62.setParentIdInternal(n2);
            }
        }
    }
}

