/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzX1R;
import com.aspose.words.internal.zzXlW;
import com.aspose.words.internal.zzZhm;
import com.aspose.words.internal.zzZxK;
import com.aspose.words.internal.zzyr;
import com.aspose.words.internal.zzz7;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzY28;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzZZD = new HashMap();
    private static HashMap<Integer, Integer> zzZo5 = new HashMap();
    private static HashMap<Integer, Integer> zzWY9 = new HashMap();
    private static HashMap<Integer, Integer> zzXVw = new HashMap();
    private static HashMap<Integer, Integer> zzW02 = new HashMap();
    private static HashMap<Integer, Integer> zzZSi = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzZxK.zzO3(fileName, "fileName");
        try (zzyr zzyr2 = zzZxK.zzVX8(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzZMw(zzyr2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzZMw(zzz7.zzYIY(stream));
    }

    static FileFormatInfo zzZMw(zzZhm zzZhm2) throws Exception {
        if (zzZhm2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzY28 zzY282 = new zzY28();
            zzZhm zzZhm3 = zzZhm2;
            zzY28 zzY283 = zzY282;
            return zzY282.zzO3(zzZhm3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzZM5(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzp8(zzXlW.zz6j(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzr(zzXlW.zz6j(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzX1R.zzYSp(string = zzXlW.zzZxK(FileFormatUtil.zzWLW(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzp8(FileFormatUtil.zzXnf(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzr(FileFormatUtil.zzWLW(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzXlW.zzZxK(FileFormatUtil.zzXnf(saveFormat));
        if (zzX1R.zzYSp(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzr(zzXlW.zz0u(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzXlW.zzZxK(FileFormatUtil.zzXkY(imageType));
    }

    static Exception zzZM5(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzWk6(int n) {
        return zzXlW.toString(FileFormatUtil.zzXnf(n));
    }

    static int zzr(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzZxK.zzYIY(zzW02, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzWEP(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzZxK.zzYIY(zzZSi, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzCX(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzWLW(int n) {
        return zzZxK.zzYIY(zzZZD, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzXnf(int n) {
        return zzZxK.zzYIY(zzZo5, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzXkY(int n) {
        return zzZxK.zzYIY(zzWY9, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzp8(int n) {
        return zzZxK.zzYIY(zzXVw, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzZEl(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzZxK.zzO3(zzW02, Integer.valueOf(n), Integer.valueOf(n2));
            zzZxK.zzO3(zzZo5, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzXVw.containsKey(n)) {
                zzZxK.zzO3(zzXVw, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzZxK.zzO3(zzZZD, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzZxK.zzO3(zzZSi, Integer.valueOf(n), Integer.valueOf(n4));
            zzZxK.zzO3(zzWY9, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzZEl(11, 10, 10, 1);
        FileFormatUtil.zzZEl(11, 0, 0, 1);
        FileFormatUtil.zzZEl(12, 11, 11, 1);
        FileFormatUtil.zzZEl(13, 20, 20, 1);
        FileFormatUtil.zzZEl(13, 0, 254, 1);
        FileFormatUtil.zzZEl(14, 21, 21, 1);
        FileFormatUtil.zzZEl(15, 22, 22, 1);
        FileFormatUtil.zzZEl(16, 23, 23, 1);
        FileFormatUtil.zzZEl(18, 24, 24, 1);
        FileFormatUtil.zzZEl(19, 25, 25, 1);
        FileFormatUtil.zzZEl(20, 26, 26, 1);
        FileFormatUtil.zzZEl(21, 27, 27, 1);
        FileFormatUtil.zzZEl(24, 30, 30, 1);
        FileFormatUtil.zzZEl(17, 31, 31, 1);
        FileFormatUtil.zzZEl(25, 50, 50, 1);
        FileFormatUtil.zzZEl(26, 45, 255, 1);
        FileFormatUtil.zzZEl(27, 51, 51, 1);
        FileFormatUtil.zzZEl(28, 0, 52, 1);
        FileFormatUtil.zzZEl(29, 0, 53, 1);
        FileFormatUtil.zzZEl(31, 53, 54, 1);
        FileFormatUtil.zzZEl(22, 60, 60, 1);
        FileFormatUtil.zzZEl(23, 61, 61, 1);
        FileFormatUtil.zzZEl(34, 40, 64, 1);
        FileFormatUtil.zzZEl(41, 47, 255, 1);
        FileFormatUtil.zzZEl(42, 48, 255, 1);
        FileFormatUtil.zzZEl(35, 41, 255, 1);
        FileFormatUtil.zzZEl(36, 46, 255, 1);
        FileFormatUtil.zzZEl(38, 42, 255, 1);
        FileFormatUtil.zzZEl(37, 44, 255, 1);
        FileFormatUtil.zzZEl(30, 52, 55, 1);
        FileFormatUtil.zzZEl(32, 70, 62, 1);
        FileFormatUtil.zzZEl(33, 73, 63, 1);
        FileFormatUtil.zzZEl(39, 71, 255, 1);
        FileFormatUtil.zzZEl(8, 100, 255, 1);
        FileFormatUtil.zzZEl(9, 105, 255, 1);
        FileFormatUtil.zzZEl(6, 101, 255, 6);
        FileFormatUtil.zzZEl(7, 102, 255, 7);
        FileFormatUtil.zzZEl(5, 104, 255, 5);
        FileFormatUtil.zzZEl(4, 0, 255, 4);
        FileFormatUtil.zzZEl(3, 0, 255, 3);
        FileFormatUtil.zzZEl(40, 72, 255, 1);
        FileFormatUtil.zzZEl(2, 103, 255, 2);
    }
}

