/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zz23;
import com.aspose.words.internal.zzWF1;
import com.aspose.words.internal.zzYUi;
import com.aspose.words.internal.zzYW4;
import com.aspose.words.internal.zzYdc;
import com.aspose.words.internal.zzZ4e;
import com.aspose.words.internal.zzZCZ;
import com.aspose.words.internal.zzZhm;
import com.aspose.words.internal.zzZsL;
import com.aspose.words.internal.zzZxK;
import com.aspose.words.internal.zzyr;
import com.aspose.words.internal.zzzI;
import com.aspose.words.zzMR;
import com.aspose.words.zzW6p;
import com.aspose.words.zzW9o;
import com.aspose.words.zzWJ1;
import com.aspose.words.zzX51;
import com.aspose.words.zzY28;
import com.aspose.words.zzYbW;
import com.aspose.words.zzZjl;
import com.aspose.words.zzZns;
import com.aspose.words.zzZzR;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzYIY(zzZhm zzZhm2, zzZhm zzZhm3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzZxK.zzO3((Object)zzZhm2, "srcStream");
        zzZxK.zzO3((Object)zzZhm3, "dstStream");
        zzZxK.zzO3((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzO3(zzZhm2, zzZhm3, certificateHolder, signOptions);
        zzZhm3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzYIY(zzZhm.zzO3(srcStream), (zzZhm)zzZhm.zzZM5(dstStream), certHolder, signOptions);
    }

    private static void zzO3(zzZhm zzZhm2, zzZhm zzZhm3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzZM5(digitalSignature);
        }
        if (zzY28.zzYFM(zzZhm2)) {
            DigitalSignatureUtil.zzYIY(zzZhm2, zzZhm3, digitalSignature, true);
            return;
        }
        zzY28 zzY282 = new zzY28();
        zzZhm zzZhm4 = zzZhm2;
        zzY28 zzY283 = zzY282;
        FileFormatInfo fileFormatInfo = zzY282.zzO3(zzZhm4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zz23 zz232 = new zz23(zzZhm2);
                int n = fileFormatInfo.zzEU() == 1 ? 1 : 2;
                zzZjl.zzYIY(zz232, digitalSignature, n);
                zzZhm3.zzWsc(0L);
                zz232.zzia(zzZhm3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzYIY(fileFormatInfo.zzo3(), zzZhm3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzYIY(zzZhm2, zzZhm3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzYIY(zzZhm2, zzZhm3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzZxK.zzO3(srcFileName, "srcFileName");
        zzZxK.zzO3(dstFileName, "dstFileName");
        try (zzyr zzyr2 = zzZxK.zzO3(srcFileName, 3, 1);){
            try (zzyr zzyr3 = zzZxK.zzO3(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzYIY((zzZhm)zzyr2, (zzZhm)zzyr3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzzI zzzI2 = zzZhm.zzZM5(dstStream);
        zzZhm zzZhm2 = zzZhm.zzO3(srcStream);
        DigitalSignatureUtil.zzYIY(zzZhm2, (zzZhm)zzzI2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzyr zzyr2 = zzZxK.zzO3(srcFileName, 3, 1);){
            try (zzyr zzyr3 = zzZxK.zzO3(dstFileName, 4, 2);){
                DigitalSignatureUtil.zz1O(zzyr2, zzyr3);
            }
            return;
        }
    }

    private static void zz1O(zzZhm zzZhm2, zzZhm zzZhm3) throws Exception {
        zzY28 zzY282 = new zzY28();
        zzZhm zzZhm4 = zzZhm2;
        zzY28 zzY283 = zzY282;
        FileFormatInfo fileFormatInfo = zzY282.zzO3(zzZhm4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zz23 zz232 = new zz23(zzZhm2);
                zz232.zzXOj().zzY2s("_xmlsignatures");
                zz232.zzXOj().zzY2s("_signatures");
                zzZhm3.zzWwJ(0L);
                zz232.zzia(zzZhm3);
                zzZhm zzZhm5 = zzZhm3;
                zzZhm5.zzWsc(zzZhm5.zzWF3());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzZCZ zzZCZ2 = new zzZCZ(zzZhm2);
                zzZ4e zzZ4e2 = zzZCZ2.zzYIY(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzZ4e2 != null) {
                    for (zzYW4 zzYW42 : zzZ4e2.zzXLH()) {
                        String string = zzZ4e2.zzYIY(zzYW42);
                        zzZCZ2.zzru().remove(string);
                    }
                    zzZCZ2.zzru().remove(zzZ4e2.getName());
                    zzYW4 zzYW43 = zzZCZ2.zzXLH().zzWJP("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzZCZ2.zzXLH().remove(zzYW43.getId());
                    zzZCZ2.zzZ85();
                }
                zzZhm3.zzWwJ(0L);
                zzZCZ2.zzia(zzZhm3);
                zzZhm zzZhm6 = zzZhm3;
                zzZhm6.zzWsc(zzZhm6.zzWF3());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zz1O(zzZhm.zzO3(srcStream), zzZhm.zzZM5(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzyr zzyr2 = zzZxK.zzO3(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzZvT(zzyr2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzZvT(zzZhm zzZhm2) throws Exception {
        if (zzY28.zzYFM(zzZhm2)) {
            return DigitalSignatureUtil.zzY0c(zzZhm2);
        }
        zzY28 zzY282 = new zzY28();
        zzZhm zzZhm3 = zzZhm2;
        zzY28 zzY283 = zzY282;
        FileFormatInfo fileFormatInfo = zzY282.zzO3(zzZhm3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzZhm2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzZvT(zzZhm.zzO3(stream));
    }

    static zzYUi zzYIY(zz23 zz232, String string) throws Exception {
        zzW6p zzW6p2 = new zzW6p(zz232);
        if (zzW6p2.zzVZV()) {
            zzYUi zzYUi2 = zzW6p2.zzvH(string);
            return zzYUi2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzYJM(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzZsL.zzO3("Unexpected digest algorithm: {0}.", n));
    }

    static String zzW5N(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzYJM(n);
    }

    private static void zzYIY(zzZhm zzZhm2, zzZhm zzZhm3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzZCZ zzZCZ2 = new zzZCZ(zzZhm2);
        zzX51 zzX512 = bl ? new zzW9o(zzZCZ2) : new zzWJ1(zzZCZ2);
        zzX512.zzO3(digitalSignature);
        zzZhm3.zzWsc(0L);
        zzZCZ2.zzia(zzZhm3);
    }

    private static void zzYIY(zzZhm zzZhm2, zzZhm zzZhm3, DigitalSignature digitalSignature) throws Exception {
        zzMR zzMR2 = new zzMR(zzZhm2);
        zzYbW zzYbW2 = new zzYbW(zzMR2);
        zzYbW2.zzO3(digitalSignature);
        zzZhm3.zzWsc(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzZhm zzZhm4 = zzZhm3;
        zzMR zzMR3 = zzMR2;
        zzMR3.zzYIY(zzZhm4, string, null);
    }

    private static void zzYIY(zz23 zz232, zzZhm zzZhm2, DigitalSignature digitalSignature, String string) throws Exception {
        zzYUi zzYUi2 = DigitalSignatureUtil.zzYIY(zz232, string);
        zzYUi zzYUi3 = new zzYUi();
        DigitalSignatureUtil.zzYIY((zzZhm)zzYUi2, (zzZhm)zzYUi3, digitalSignature, false);
        zz23 zz233 = zzW6p.zzZM5(zzYUi3, string);
        zz233.zzia(zzZhm2);
    }

    private static DigitalSignatureCollection zzY0c(zzZhm zzZhm2) throws Exception {
        zzZhm2.zzWwJ(0L);
        zzZCZ zzZCZ2 = new zzZCZ(zzZhm2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzZ4e zzZ4e2 = zzZCZ2.zzYIY(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzZ4e2 != null) {
            for (zzYW4 zzYW42 : zzZ4e2.zzXLH()) {
                String string = zzZ4e2.zzYIY(zzYW42);
                zzZ4e zzZ4e3 = zzZCZ2.zzYG8(string);
                zzZ4e zzZ4e4 = zzZCZ2.zzYIY(zzZ4e3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzYdc zzYdc2 = zzWF1.zzZJJ(zzZ4e4.zzZpq().zzXUC());
                zzZns.zzYIY(zzZ4e3.zzXG2(), zzYdc2, new zzZzR(zzZCZ2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

