/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzZxK;
import com.aspose.words.zzW9p;
import com.aspose.words.zzWGf;
import com.aspose.words.zzX1c;
import com.aspose.words.zzXPo;
import com.aspose.words.zzXqF;
import com.aspose.words.zzZ3i;
import com.aspose.words.zzZh9;
import com.aspose.words.zzZsm;
import com.aspose.words.zzZxU;
import com.aspose.words.zzZxj;

public class Cell
extends CompositeNode<Node>
implements zzZh9,
zzZxU {
    private zzZ3i zzXIY;
    private CellFormat zzY6e;
    private ParagraphCollection zzXFI;
    private TableCollection zzZPS;

    public Cell(DocumentBase doc) {
        this(doc, new zzZ3i());
    }

    Cell(DocumentBase doc, zzZ3i cellPr) {
        super(doc);
        this.zzXIY = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    final Cell zzZWK() {
        return (Cell)this.zzWL();
    }

    public Row getParentRow() {
        return (Row)this.zzOe();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzZjd() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzZM5(this, true);
        }
        return -1;
    }

    final int zzYyh() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzYyh();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzY6e == null) {
            this.zzY6e = new CellFormat(this);
        }
        return this.zzY6e;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzXFI == null) {
            this.zzXFI = new ParagraphCollection(this);
        }
        return this.zzXFI;
    }

    public TableCollection getTables() {
        if (this.zzZPS == null) {
            this.zzZPS = new TableCollection(this);
        }
        return this.zzZPS;
    }

    final zzZ3i zzX6W() {
        return this.zzXIY;
    }

    final void zzYIY(zzZ3i zzZ3i2) {
        this.zzXIY = zzZ3i2;
    }

    @Override
    final Node zzYIY(boolean bl, zzW9p zzW9p2) {
        zzZ3i zzZ3i2;
        Cell cell = (Cell)super.zzYIY(bl, zzW9p2);
        zzZ3i zzZ3i3 = this.zzXIY;
        cell.zzXIY = zzZ3i2 = (zzZ3i)zzZ3i3.zzZkf();
        cell.zzY6e = null;
        cell.zzXFI = null;
        cell.zzZPS = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzYIY(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellStart(this);
    }

    @Override
    final int zzO3(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzXqF.zzZJJ(this);
    }

    @Override
    final boolean zzZa1(Node node) {
        return zzZsm.zzYeJ(node);
    }

    final int zzW6j() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        Cell cell = row.getFirstCell();
        while (cell != null) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell == this) {
                return n;
            }
            Cell cell2 = cell;
            cell = (Cell)cell2.zzWL();
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzXIY.zzVWk(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzXIY.zzVWk(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzZxj zzZxj2 = zzZxK.zzYIY(object, zzZxj.class);
        if (zzZxj2 != null && zzZxj2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzYnL(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzZ3i.zzZnu(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzXIY.zzXaw(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzXIY.clear();
    }

    private Object zzYnL(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzZxK.zzYIY((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzYIY(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXPo getInsertRevision() {
        Cell cell = this;
        return cell.zzXIY.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzXPo value) {
        Cloneable cloneable = this;
        zzXPo zzXPo2 = value;
        cloneable = cloneable.zzXIY;
        ((zzX1c)cloneable).zzXaw(14, zzXPo2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXPo getDeleteRevision() {
        Cell cell = this;
        return cell.zzXIY.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzXPo value) {
        Cloneable cloneable = this;
        zzXPo zzXPo2 = value;
        cloneable = cloneable.zzXIY;
        ((zzX1c)cloneable).zzXaw(12, zzXPo2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzWGf getMoveFromRevision() {
        Cell cell = this;
        return cell.zzXIY.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzWGf value) {
        Cloneable cloneable = this;
        zzWGf zzWGf2 = value;
        cloneable = cloneable.zzXIY;
        ((zzX1c)cloneable).zzXaw(13, zzWGf2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzWGf getMoveToRevision() {
        Cell cell = this;
        return cell.zzXIY.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzWGf value) {
        Cloneable cloneable = this;
        zzWGf zzWGf2 = value;
        cloneable = cloneable.zzXIY;
        ((zzX1c)cloneable).zzXaw(15, zzWGf2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzXIY.remove(13);
        cell = this;
        cell.zzXIY.remove(15);
    }

    final zzZ3i zzW0G(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzZ3i zzZ3i2 = new zzZ3i();
        this.zzYIY(3120, zzZ3i2);
        this.zzYIY(3140, zzZ3i2);
        this.zzYIY(3110, zzZ3i2);
        this.zzYIY(3130, zzZ3i2);
        this.zzYIY(3090, zzZ3i2);
        this.zzYIY(3100, zzZ3i2);
        this.zzYIY(3070, zzZ3i2);
        this.zzYIY(3080, zzZ3i2);
        if (bl && (tableStyle = zzZxK.zzYIY((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzO3(this, zzZ3i2);
        }
        this.zzXIY.zzO3((zzX1c)zzZ3i2);
        return zzZ3i2;
    }

    private void zzYIY(int n, zzZ3i zzZ3i2) {
        zzZ3i2.zzXaw(n, this.fetchInheritedCellAttr(n));
    }
}

