/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzZsL;
import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DBNull;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataKey;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzYTv;

public class DataRelation {
    private DataKey zzW7o;
    private DataKey zzWh1;
    private String zzWKX;
    private String zzZE1;
    private String zzXdF;
    private String[] zzIe;
    private String[] zzYB8;
    private DataColumn[] zzYI7;
    private DataColumn[] zzWzJ;
    private UniqueConstraint zzWh8;
    private ForeignKeyConstraint zzWa1;
    private boolean zzW6n = true;
    private DataSet zzZfS;

    public DataRelation(String relationName, DataTable parentTable, DataTable childTable, String[] parentColumnNames, String[] childColumnNames) {
        DataColumn[] dataColumnArray = DataRelation.zzO3(parentTable, parentColumnNames);
        DataColumn[] dataColumnArray2 = DataRelation.zzO3(childTable, childColumnNames);
        this.zzYIY(relationName, dataColumnArray, dataColumnArray2, true);
    }

    public DataRelation(String relationName, DataColumn[] parentColumns, DataColumn[] childColumns, boolean createConstraints) {
        this.zzYIY(relationName, parentColumns, childColumns, createConstraints);
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn, boolean createConstraint) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, createConstraint);
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, true);
    }

    private static DataColumn[] zzO3(DataTable dataTable, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Column names need to have at least one column name.");
        }
        if (dataTable == null) {
            throw new IllegalArgumentException("Table cannot be null");
        }
        DataColumn[] dataColumnArray = new DataColumn[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            DataColumn dataColumn = dataTable.getColumns().get(stringArray[i]);
            if (dataColumn == null) {
                throw new IllegalArgumentException(zzZsL.zzO3("The given column {0} does not exist in {1}", stringArray[i], dataTable.getTableName()));
            }
            dataColumnArray[i] = dataColumn;
        }
        return dataColumnArray;
    }

    private void zzYIY(String string, DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2, boolean bl) {
        int n;
        DataColumn dataColumn;
        int n2;
        if (dataColumnArray == null) {
            throw new IllegalArgumentException("parentColumns");
        }
        if (dataColumnArray2 == null) {
            throw new IllegalArgumentException("childColumns");
        }
        if (dataColumnArray.length != dataColumnArray2.length) {
            throw new IllegalArgumentException("Key Length mismatch");
        }
        DataTable dataTable = dataColumnArray[0].getTable();
        DataTable dataTable2 = dataColumnArray2[0].getTable();
        if (dataTable.getDataSet() != dataTable2.getDataSet()) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < dataColumnArray.length; ++i) {
            if (dataColumnArray[i].getTable().getDataSet() != null && dataColumnArray2[i].getTable().getDataSet() != null) continue;
            throw new IllegalArgumentException("Parent or Child columns do not have DataSet");
        }
        DataColumn[] dataColumnArray3 = dataColumnArray;
        int n3 = dataColumnArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray3[n2];
            if (dataColumn.getTable() == dataTable) continue;
            throw new IllegalStateException();
        }
        dataColumnArray3 = dataColumnArray2;
        n3 = dataColumnArray2.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray3[n2];
            if (dataColumn.getTable() == dataTable2) continue;
            throw new IllegalStateException();
        }
        for (n = 0; n < dataColumnArray2.length; ++n) {
            if (dataColumnArray[n].zzO3(dataColumnArray2[n])) continue;
            throw new IllegalStateException("Parent Columns and Child Columns don't have matching column types");
        }
        this.zzYI7 = dataColumnArray;
        this.zzWzJ = dataColumnArray2;
        this.zzWKX = string == null ? "" : string;
        this.zzW6n = bl;
        this.zzWh1 = new DataKey(dataColumnArray, true);
        this.zzW7o = new DataKey(dataColumnArray2, true);
        this.zzZfS = dataTable.getDataSet();
        this.zzIe = new String[this.zzYI7.length];
        for (n = 0; n < this.zzYI7.length; ++n) {
            this.zzIe[n] = this.zzYI7[n].getColumnName();
        }
        this.zzYB8 = new String[this.zzWzJ.length];
        for (n = 0; n < this.zzWzJ.length; ++n) {
            this.zzYB8[n] = this.zzWzJ[n].getColumnName();
        }
    }

    public String getRelationName() {
        return this.zzWKX;
    }

    public String getParentTableName() {
        DataTable dataTable = this.getParentTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public String getChildTableName() {
        DataTable dataTable = this.getChildTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public DataTable getParentTable() {
        return this.getParentKey().getTable();
    }

    public DataTable getChildTable() {
        return this.getChildKey().getTable();
    }

    public String[] getParentColumnNames() {
        return this.zzIe;
    }

    public String[] getChildColumnNames() {
        return this.zzYB8;
    }

    public DataColumn[] getParentColumns() {
        return this.zzYI7;
    }

    public DataColumn[] getChildColumns() {
        return this.zzWzJ;
    }

    public void setNested(boolean nested) {
    }

    public UniqueConstraint getParentKeyConstraint() {
        return this.zzWh8;
    }

    public void setParentKeyConstraint(UniqueConstraint parentKeyConstraint) {
        this.zzWh8 = parentKeyConstraint;
    }

    public ForeignKeyConstraint getChildKeyConstraint() {
        return this.zzWa1;
    }

    public void setChildKeyConstraint(ForeignKeyConstraint childKeyConstraint) {
        this.zzWa1 = childKeyConstraint;
    }

    public DataKey getChildKey() {
        return this.zzW7o;
    }

    public DataKey getParentKey() {
        return this.zzWh1;
    }

    public DataSet getDataSet() {
        return this.zzZfS;
    }

    public int hashCode() {
        int n = 31 + this.zzWKX.hashCode();
        n = n * 31 + this.zzZE1.hashCode();
        n = n * 31 + this.zzXdF.hashCode();
        for (int i = 0; i < this.zzIe.length; ++i) {
            n = n * 31 + this.zzIe[i].hashCode();
            n = n * 31 + this.zzYB8[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataRelation)) {
            return false;
        }
        DataRelation dataRelation = (DataRelation)obj;
        boolean bl = this.getRelationName().equals(dataRelation.getRelationName()) && this.getParentTableName().equals(dataRelation.getParentTableName()) && this.getChildTableName().equals(dataRelation.getChildTableName());
        if (!bl) {
            return false;
        }
        if (this.getParentColumnNames().length != dataRelation.getParentColumnNames().length || this.getChildColumnNames().length != dataRelation.getChildColumnNames().length) {
            return false;
        }
        for (int i = 0; i < this.getParentColumnNames().length; ++i) {
            if (this.getParentColumnNames()[i].equals(dataRelation.getParentColumnNames()[i]) && this.getChildColumnNames()[i].equals(dataRelation.getChildColumnNames()[i])) continue;
            return false;
        }
        return true;
    }

    static DataRow[] zzYIY(DataKey dataKey, DataKey dataKey2, DataRow dataRow) {
        Object[] objectArray = dataRow.getKeyValues(dataKey2);
        if (DataRelation.zzYMa(objectArray)) {
            return new DataRow[0];
        }
        zzYTv zzYTv2 = dataKey.getSortIndex();
        return zzYTv2.zzP5(objectArray);
    }

    private static boolean zzYMa(Object[] objectArray) {
        if (objectArray == null) {
            return true;
        }
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray2[i];
            if (DataRelation.zzZqa(object)) continue;
            return false;
        }
        return true;
    }

    private static boolean zzZqa(Object object) {
        return object == null || DBNull.Value == object;
    }

    final void zzYsr() throws InvalidConstraintException, DataException {
        if (!this.zzW6n) {
            return;
        }
        DataRelation dataRelation = this;
        ForeignKeyConstraint foreignKeyConstraint = dataRelation.zzZM5(dataRelation.getChildTable().getConstraints());
        DataRelation dataRelation2 = this;
        UniqueConstraint uniqueConstraint = dataRelation2.zzO3(dataRelation2.getParentTable().getConstraints());
        if (uniqueConstraint == null) {
            uniqueConstraint = new UniqueConstraint(this.getParentColumns(), false);
            this.getParentTable().getConstraints().add(uniqueConstraint);
        }
        if (foreignKeyConstraint == null) {
            foreignKeyConstraint = new ForeignKeyConstraint(this.getRelationName(), this.getParentColumns(), this.getChildColumns());
            this.getChildTable().getConstraints().add(foreignKeyConstraint);
        }
        this.setParentKeyConstraint(uniqueConstraint);
        this.setChildKeyConstraint(foreignKeyConstraint);
    }

    private UniqueConstraint zzO3(ConstraintCollection constraintCollection) {
        for (Constraint constraint : constraintCollection) {
            if (!(constraint instanceof UniqueConstraint)) continue;
            UniqueConstraint uniqueConstraint = (UniqueConstraint)constraint;
            if (!DataRelation.zzYIY(this.getParentColumns(), uniqueConstraint.getColumns())) continue;
            return uniqueConstraint;
        }
        return null;
    }

    private ForeignKeyConstraint zzZM5(ConstraintCollection constraintCollection) {
        for (Constraint constraint : constraintCollection) {
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            ForeignKeyConstraint foreignKeyConstraint = (ForeignKeyConstraint)constraint;
            if (!DataRelation.zzYIY(this.getChildColumns(), foreignKeyConstraint.getColumns()) || !DataRelation.zzYIY(this.getParentColumns(), foreignKeyConstraint.getRelatedColumns())) continue;
            return foreignKeyConstraint;
        }
        return null;
    }

    private static boolean zzYIY(DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2) {
        if (dataColumnArray.length != dataColumnArray2.length) {
            return false;
        }
        for (int i = 0; i < dataColumnArray.length; ++i) {
            DataColumn dataColumn = dataColumnArray[i];
            DataColumn dataColumn2 = dataColumnArray2[i];
            if (dataColumn.getColumnName().equals(dataColumn2.getColumnName()) && dataColumn.getDataType() == dataColumn2.getDataType() && dataColumn.getTable().getTableName().equals(dataColumn2.getTable().getTableName())) continue;
            return false;
        }
        return true;
    }
}

