/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzW3R;
import com.aspose.words.internal.zzX1R;
import com.aspose.words.internal.zzXbQ;
import com.aspose.words.internal.zzYMz;
import com.aspose.words.internal.zzYkZ;
import com.aspose.words.internal.zzZsL;
import com.aspose.words.internal.zzZxK;
import com.aspose.words.zzXLD;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zz7q;
    private zzXLD zzZwm;

    Watermark(Document doc, zzXLD watermarkProvider) {
        this.zz7q = doc;
        this.zzZwm = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzXLV(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzYIY(text, textWatermarkOptions, this.zz7q);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzZxK.zzO3((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zz7q, 75);
        shape.getImageData().setImage(image);
        this.zzYIY(shape, options, this.zz7q);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzZxK.zzO3((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zz7q, 75);
        shape.getImageData().setImage(imagePath);
        this.zzYIY(shape, options, this.zz7q);
    }

    public final int getType() {
        Shape shape = this.zzZwm.get();
        if (shape == null) {
            return 2;
        }
        shape.zzY95();
        if (shape.zzZ89()) {
            return 0;
        }
        if (shape.zzXUe()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzZwm.add(shape);
    }

    public final void remove() {
        this.zzZwm.remove();
    }

    private static void zzXLV(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (zzX1R.zzZGw(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzZxK.zzYIY(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzYIY(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzO3(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzVOB(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzO3(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzZ69() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzWuu()) / d2) > (double)(f = pageSetup.zzYzN())) {
            d = (double)f / d3;
        }
        shape.zzXbn(zzYMz.zzZM5(d2 * d, 2, zzW3R.zzZGJ));
        shape.zzZBH(zzYMz.zzZM5(d3 * d, 2, zzW3R.zzZGJ));
    }

    private Shape zzYIY(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzYIY(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzVOB(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzYIY(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzZT2() ? 1.0f : textWatermarkOptions.getFontSize();
        zzXbQ zzXbQ2 = document.zzW7a().zzZM5(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzXbQ2.zzWBD(shape.getTextPath().getText());
        if (textWatermarkOptions.zzZT2()) {
            l = Watermark.zzYIY(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzXbn(zzYMz.zzZM5(Float.intBitsToFloat(n), 2, zzW3R.zzZGJ));
        shape.zzZBH(zzYMz.zzZM5(zzYkZ.zzXeN(l), 2, zzW3R.zzZGJ));
    }

    private static long zzYIY(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzWuu();
        float f2 = pageSetup.zzYzN();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzYkZ.zzXeN(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzYkZ.zzZJJ(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzYkZ.zzXeN(l) >= Float.intBitsToFloat(n)) {
            return zzYkZ.zzZJJ(f2 / f3, f2);
        }
        float f6 = f;
        return zzYkZ.zzZJJ(f6, f6 * f3);
    }

    private static void zzVOB(Shape shape, String string) {
        shape.setName(zzZsL.zzO3("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
    }
}

