/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzZsL;
import com.aspose.words.internal.zzZxK;
import com.aspose.words.zzW9p;
import com.aspose.words.zzYGp;
import com.aspose.words.zzw9;

public final class Section
extends CompositeNode<Node>
implements zzYGp {
    private zzw9 zzXQy;
    private PageSetup zzyZ;
    private HeaderFooterCollection zzX9K;

    public Section(DocumentBase doc) {
        this(doc, new zzw9());
    }

    Section(DocumentBase doc, zzw9 sectPr) {
        super(doc);
        this.zzXQy = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzX9K == null) {
            this.zzX9K = new HeaderFooterCollection(this);
        }
        return this.zzX9K;
    }

    public final PageSetup getPageSetup() {
        if (this.zzyZ == null) {
            Section section = this;
            this.zzyZ = new PageSetup(section, section.getDocument().zzZIm(), this.getDocument().getStyles(), new zzYIY(this));
        }
        return this.zzyZ;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzY68();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzVZF(!value);
    }

    final zzw9 zzWvg() {
        return this.zzXQy;
    }

    final void zzZM5(zzw9 zzw92) {
        this.zzXQy = zzw92;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzYIY(boolean bl, zzW9p zzW9p2) {
        zzw9 zzw92;
        Section section = (Section)super.zzYIY(bl, zzW9p2);
        zzw9 zzw93 = this.zzXQy;
        section.zzXQy = zzw92 = (zzw9)zzw93.zzZkf();
        section.zzyZ = null;
        section.zzX9K = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzYIY(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzO3(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zz1O(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zz1O(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzWKQ(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzZa1(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzWKQ(n) == null;
            }
        }
        return false;
    }

    final void zzZM5(Shape shape, boolean bl) throws Exception {
        this.zzYIY(shape, 4, bl);
        this.zzYIY(shape, 0, bl);
        this.zzYIY(shape, 1, bl);
    }

    private void zzYIY(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzW2n());
        shape2.setName(zzZsL.zzO3("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final void zzZJX() {
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzce()) {
                if (!shape.zzY95()) continue;
                shape.remove();
            }
        }
    }

    private void zz1O(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzO3(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzXQy.zzVWk(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzZIm().zzVUh.zzX6d(key);
        }
        return zzw9.zzZnu(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzXQy.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzZIm().zzVUh.zzXaw(key, value);
            return;
        }
        this.zzXQy.zzXaw(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzXQy.clear();
    }

    final boolean zzWy8() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzQw() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        return super.toString();
    }

    static final class zzYIY
    implements zzYGp {
        private Section zzXPl;

        zzYIY(Section section) {
            this.zzXPl = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzX9D().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzX9D().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzX9D().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzYGp zzX9D() {
            Document document = zzZxK.zzYIY((Object)this.zzXPl.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzXPl;
        }
    }
}

