/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzz7;
import com.aspose.words.zzVOw;
import com.aspose.words.zzX3g;
import com.aspose.words.zzY3R;
import com.aspose.words.zzYgQ;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzY3R,
Iterable<T> {
    private Node zzZfW;
    private CompositeNode zzYoa;
    private DocumentBase zzWVF;
    private boolean zzYXy;
    private int zz7H;
    private int zzYCM;
    private Node zzV2;
    private int zzZAN;
    private zzX3g zzXS8;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzYgQ.zzX6(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzYgQ(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzX3g matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzYoa = container;
        this.zzWVF = container.getDocument();
        this.zzXS8 = matcher;
        this.zzYXy = isDeep;
        this.zzZGP();
    }

    public Node get(int index) {
        try {
            this.zzXpw();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzYCM == index) {
                return this.zzV2;
            }
            int n = index - this.zzYCM;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzhb(nodeCollection.zzV2, n);
            if (node != null) {
                this.zzYCM = index;
                this.zzV2 = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzYXy) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzYoa.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzYXy) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzYoa.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzkV();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzVOw(this);
    }

    final <TNode extends Node> zzVOw<TNode> zzW3D() {
        return new zzVOw(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzkV() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzz7.zzYIY(arrayList, node);
        }
        return arrayList;
    }

    private Node zzhb(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzYpV(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzX1c(curNode, true);
    }

    private Node zzX1c(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzZfW = node;
        do {
            node2 = this.zzZfW;
            Node node3 = this.zzYXy ? this.zzYIY(true, this.zzZfW) : (this.zzZfW = this.zzXS8.zzYUp() ? this.zzZM5(true, this.zzZfW) : this.zzO3(true, this.zzZfW));
        } while (this.zzZfW != null && !this.zzXS8.zzXnd(this.zzZfW));
        return node2;
    }

    private Node zzYpV(Node node, boolean bl) throws Exception {
        while ((this.zzYXy ? this.zzYIY(bl, node) : (node = this.zzXS8.zzYUp() ? this.zzZM5(bl, node) : this.zzO3(bl, node))) != null && !this.zzXS8.zzXnd(node)) {
        }
        return node;
    }

    private Node zzYIY(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzYoa);
        }
        return node.previousPreOrder(this.zzYoa);
    }

    private Node zzO3(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzYoa) {
                return this.zzYoa.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzYoa) {
            return this.zzYoa.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzZM5(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzYoa ? this.zzYoa.zzX7K() : node.zzZm4();
        } else {
            Node node3 = node2 = node == this.zzYoa ? this.zzYoa.zzY8Q() : node.zzYy8();
        }
        if (node2 == this.zzYoa.getNextSibling() || node2 == this.zzYoa.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzXpw() {
        if (this.zz7H != this.zzXDp()) {
            this.zzZGP();
        }
    }

    private void zzZGP() {
        this.zz7H = this.zzXDp();
        this.zzYCM = -1;
        this.zzV2 = this.zzYoa;
        this.zzZAN = -1;
    }

    private int zzXDp() {
        if (this.zzWVF != null) {
            return this.zzWVF.zz9V();
        }
        return 0;
    }

    public int getCount() {
        this.zzXpw();
        if (this.zzZAN == -1) {
            this.zzZAN = zzVOw.zzYIY(this);
        }
        return this.zzZAN;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzZfW;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzYoa;
    }
}

