/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zz0E;
import com.aspose.words.internal.zzBI;
import com.aspose.words.internal.zzJP;
import com.aspose.words.internal.zzQH;
import com.aspose.words.internal.zzWPb;
import com.aspose.words.internal.zzWlQ;
import com.aspose.words.internal.zzWqd;
import com.aspose.words.internal.zzX1R;
import com.aspose.words.internal.zzXeV;
import com.aspose.words.internal.zzXqt;
import com.aspose.words.internal.zzXxR;
import com.aspose.words.internal.zzYUi;
import com.aspose.words.internal.zzYfJ;
import com.aspose.words.internal.zzYgE;
import com.aspose.words.internal.zzZhm;
import com.aspose.words.internal.zzZsL;
import com.aspose.words.internal.zzZxK;
import com.aspose.words.internal.zzqd;
import com.aspose.words.zz1t;
import com.aspose.words.zz21;
import com.aspose.words.zz4e;
import com.aspose.words.zz6i;
import com.aspose.words.zzA1;
import com.aspose.words.zzAS;
import com.aspose.words.zzVU2;
import com.aspose.words.zzW64;
import com.aspose.words.zzWJq;
import com.aspose.words.zzWXX;
import com.aspose.words.zzWY;
import com.aspose.words.zzWYF;
import com.aspose.words.zzWcn;
import com.aspose.words.zzWe8;
import com.aspose.words.zzWeV;
import com.aspose.words.zzWqz;
import com.aspose.words.zzX1c;
import com.aspose.words.zzXEe;
import com.aspose.words.zzXEk;
import com.aspose.words.zzXqF;
import com.aspose.words.zzXuX;
import com.aspose.words.zzY1;
import com.aspose.words.zzY1i;
import com.aspose.words.zzY75;
import com.aspose.words.zzY8j;
import com.aspose.words.zzYBU;
import com.aspose.words.zzYDz;
import com.aspose.words.zzYFM;
import com.aspose.words.zzYIW;
import com.aspose.words.zzYSy;
import com.aspose.words.zzYa7;
import com.aspose.words.zzYqp;
import com.aspose.words.zzYwN;
import com.aspose.words.zzYxb;
import com.aspose.words.zzYxz;
import com.aspose.words.zzZ2j;
import com.aspose.words.zzZ3i;
import com.aspose.words.zzZc5;
import com.aspose.words.zzZh9;
import com.aspose.words.zzZsm;
import com.aspose.words.zzZxU;
import com.aspose.words.zzeM;
import com.aspose.words.zzw9;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzYa7,
zzYqp,
zzZh9 {
    private Document zz7q;
    private Node zzWPB;
    private Node zzWHS;
    private zzXEe zzJ9;
    private Font zzR0;
    private zzWlQ<zzXEe> zzYPB;
    private zzWlQ<zzY8j> zzDc;
    private zzWlQ<zzYIY> zzmk;
    private zz4e zzXOo = zz4e.zzY90();
    private zzZ3i zzXIY = new zzZ3i();
    private RowFormat zzXdO;
    private CellFormat zzY6e;
    private zzWlQ<zzWYF> zzZdI;
    private int zzZTa = 0;
    private int zz7O = -1;
    private int zzXMY;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzP5(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzP5(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzP5(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYIY(documentBuilder.getCurrentSection(), zzXqF.zzXHL(headerFooterType), 0, 0);
    }

    private void zzP5(int n, int n2, int n3, int n4) {
        this.zz7q.ensureMinimum();
        Section section = (Section)this.zz7q.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzYIY(section, 1, n3, n4);
    }

    private void zzYIY(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzXqF.zzX4K(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zz7q, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zz7q));
            }
        }
        this.zzYIY(story, n2, n3);
    }

    private void zzYIY(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYIY((CompositeNode)paragraph2, n3);
    }

    final void zzYIY(Paragraph paragraph, int n) {
        this.zzYIY((CompositeNode)paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzYeY().zzWgq() ? zzWeV.zzZa1(this.zz7q, fieldName) : zzWeV.zzgF(this.zzYeY(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzYIY(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzYIY(field, isAfter, false);
    }

    private boolean zzYIY(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzW64 zzW642 = field.getFormat().zzWn6();
        Inline inline = zzW642.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzYIY(inline.zzWdY(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzYFM.zzYIY(this.zz7q, bookmarkName) : zzYFM.zzO3(this.zz7q, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzYAg() == 6) {
            this.zzYIY((Paragraph)node.zzOe(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzZsm.zzZ0a(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzYIY(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYIY(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzYlt(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzYIY(cell, characterIndex);
    }

    private void zzYIY(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzYAg() == 6) {
            this.zzWcn(node);
        } else {
            Node node2 = node;
            if (zzZsm.zzZXW(node2.getNodeType())) {
                Paragraph paragraph = zzZsm.zzZ0a(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzWcn(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzYAg() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzWcn(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzXMY = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzXm4();
            return;
        }
        if (!this.zzW7M()) {
            this.zzXm4();
        }
    }

    private boolean zzW7M() {
        Node node = this.zzYeY();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zzYeY(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzYIY(inline.zzWdY(), true);
            return true;
        }
        return false;
    }

    private void zzXm4() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYIY(documentBuilder.getCurrentParagraph().zzJq(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzYlt(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzZaD() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzYeY().zzZrz(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzWL();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzYIY((CompositeNode)paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzsY(text, false);
    }

    public void writeln(String text) {
        this.zzsY(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        this.zzZ3E();
        Paragraph paragraph = this.getCurrentParagraph();
        zzXuX zzXuX2 = new zzXuX(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zz7q, this.zzZg(), this.zzZXS());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzO3(this.zzYeY(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzXuX2.dispose();
        }
        if (this.getDocument().zzKW()) {
            zzZsm.zzZM5((zzZxU)paragraph, this.getDocument().zzY6A());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzYfO() {
        zzXEe zzXEe2;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zzZ3E();
        Node node = this.zzYeY();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzsG(false);
        } else {
            run2 = run = (Run)node.zzXZn(21);
        }
        if (run2 == null && zzZxK.zzZNW(node, paragraph.zzXfb())) {
            run = paragraph.zzXfb();
        }
        if (run != null) {
            cloneable = run.zzWdY();
            zzXEe2 = (zzXEe)((zzX1c)cloneable).zzZkf();
        } else {
            cloneable = paragraph.zzJq();
            zzXEe2 = (zzXEe)((zzX1c)cloneable).zzZkf();
        }
        zzXEe zzXEe3 = zzXEe2;
        Paragraph paragraph2 = new Paragraph(this.zz7q, this.zzZg(), zzXEe3);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzXuX zzXuX2 = new zzXuX(this.zz7q);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzO3(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzXuX2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzAS.zzZa1(this);
    }

    public void insertBreak(int breakType) {
        this.zzXeW(breakType, true);
    }

    final void zzXeW(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzY9y(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzZrf(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzWi9())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzY9y(bl)) {
                        this.zzZrf(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzY9y(bl)) {
                        this.zzWoN(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzY9y(bl)) {
                        this.zzWoN(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzY9y(bl)) {
                        this.zzWoN(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzY9y(bl)) {
                        this.zzWoN(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzY9y(bl)) {
                        this.zzWoN(4);
                    }
                    return;
                }
                case 8: {
                    this.zzZrf(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzX1R.zzYSp(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzZsL.zzO3("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzZ3E();
        return zzZsm.zzYIY(fieldType, updateField, this.zzZXS(), this.zzYeY(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzZ3E();
        return zzZsm.zzYIY(fieldCode, this.zzZXS(), this.zzYeY(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzZ3E();
        return zzZsm.zzYIY(fieldCode, fieldValue, this.zzZXS(), this.zzYeY(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzZxK.zzO3((Object)displayText, "displayText");
        zzZxK.zzO3((Object)urlOrBookmark, "hrefOrBookmark");
        zzZ2j zzZ2j2 = this.zzO3(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzZ2j2.zzO3(documentBuilder.zzYrf(88, true));
        return zzZsm.zzYIY(zzZ2j2.getStart(), zzZ2j2.getSeparator(), zzZ2j2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzXXQ(70);
        if (zzX1R.zzYSp(name)) {
            this.startBookmark(name);
        }
        this.zzXFq(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zz7Q(70);
        String string = zzX1R.zzYSp(fieldValue) ? fieldValue : FormField.zzYPu;
        Run run = new Run(this.zz7q, string, this.zzZXS());
        this.insertNode(run);
        Node node = this.zzYrf(70, true);
        if (zzX1R.zzYSp(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzZzK(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzYIY((Paragraph)node.zzOe(), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzXXQ(71);
        if (zzX1R.zzYSp(name)) {
            this.startBookmark(name);
        }
        this.zzXFq(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzYrf(71, false);
        if (zzX1R.zzYSp(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzZzK(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzXXQ(83);
        if (zzX1R.zzYSp(name)) {
            this.startBookmark(name);
        }
        this.zzXFq(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzYrf(83, false);
        if (zzX1R.zzYSp(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzZzK(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zz7q, footnoteType, !zzX1R.zzYSp(referenceMark), referenceMark, this.zzZXS());
        Style style = this.getDocument().getStyles().zzXBj(zzZsm.zzXvX(footnoteType));
        footnote.zzWdY().set(50, style.zzZMF());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zz7q);
        Style style2 = this.getDocument().getStyles().zzXBj(zzZsm.zzno(footnoteType));
        paragraph.zzYSx().set(1000, style2.zzZMF());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zz7q, '\u0002', new zzXEe()) : new Run(this.zz7q, footnote.getReferenceMark(), new zzXEe());
        inline.zzWdY().set(50, style.zzZMF());
        paragraph.appendChild(inline);
        if (zzX1R.zzYSp(footnoteText)) {
            Node node = this.zzYeY();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzWcn(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzZpc(zzZhm zzZhm2) throws Exception {
        return this.zzYIY(zzZhm2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzZpc(zzZhm.zzO3(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzYIY(zzZhm zzZhm2, double d, double d2) throws Exception {
        return this.zzYIY(zzZhm2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzYIY(zzZhm.zzO3(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        zzYUi zzYUi2 = new zzYUi();
        try {
            zzqd.zzYIY(image, zzYUi2);
            Shape shape = this.zzYIY(zzYUi2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            zzYUi2.close();
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzZxK.zzO3(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzQH.zzXKb(fileName);
        try {
            Shape shape = this.zzYIY((zzZhm)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzZhm)object).close();
            }
        }
    }

    private Shape zzYIY(zzZhm zzZhm2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzZhm2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzZxK.zzYTv(zzZhm2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzYIY(zzZhm.zzO3(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzYIY(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzYIY(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("imageBytes");
        }
        boolean bl2 = false;
        if (zzJP.zzYH1(object)) {
            object4 = new zzqd((byte[])object);
            bl2 = true;
            ((zzWPb)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zz7q.getCompatibilityOptions().getMswVersion() > 12 || this.zz7q.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zz7q, 0);
            object3 = new zzYIW();
            ((zzY75)object3).zzYIY(zzXEk.zzZoC("rect"));
            ((zzYIW)object3).zzYIY(new zz6i());
            ((zzYIW)object3).zzWdD().zzXab().zzZM5(this.zz7q);
            object2 = new zzYwN();
            ((zzWY)object2).zzO3(new zzYBU(this.zz7q.zzW2n(), ""));
            ((zzWY)object2).zzYIY(new zzWXX());
            ((zzWqz)object3).zzYIY((zzWY)object2);
            shape.zzZp7(75);
            shape.zzYTv((zzWqz)object3);
        } else {
            shape = new Shape((DocumentBase)this.zz7q, 75);
        }
        if (zzJP.zzz7(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzYIY((byte[])object, new zz21(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zz21(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzJP.zzYVy((byte[])object2));
                this.zzYIY((zzYIW)shape.zzYwG(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzYIW)shape.zzYwG()).zzWdD().zzXab().zzW0G((byte[])object);
            object3 = zzJP.zzZ6o(object);
            object4 = new zz21(((zzXxR)object3).getWidthPoints(), ((zzXxR)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzYIY(this.zzZXS());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzJP.zzZvT(object)) {
            d5 = DocumentBuilder.zzYIY(shape, object);
        }
        shape.zzYIY(d3, d4, (zz21)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzYIY(Shape shape, byte[] byArray) throws Exception {
        int n = zzJP.zzWpz(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzZsm.zzXgr(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzZsm.zzWPD(n);
        return d;
    }

    private void zzYIY(zzYIW zzYIW2, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzYIW2.zzWdD().zzXab().getExtensions();
        zzYUi zzYUi2 = new zzYUi(byArray);
        try {
            object = zzZsm.zzYIY(zzYUi2, this.zz7q);
            ((zzWJq)object).zzXFn(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzWJq)object).zzYA9();
            byArray2 = ((zzWJq)object).zzH5(true);
        }
        finally {
            zzYUi2.close();
        }
        zzYIW2.zzWdD().zzXab().setExtensions(new zzBI<zzZc5>());
        object = zzZc5.zzYIY(byArray2, this.zz7q);
        zzYIW2.zzWdD().zzXab().getExtensions().zzVOB(((zzZc5)object).getUri(), (zzZc5)object);
    }

    private Shape zzYIY(zzZhm zzZhm2, String string, boolean bl, zzZhm zzZhm3) throws Exception {
        zzVU2 zzVU22 = zzVU2.zzZ5i(string);
        Shape shape = this.zzYIY(zzZhm3, bl, zzVU22, null);
        zzeM zzeM2 = zzYSy.zzYIY(zzZhm2, string, bl);
        return DocumentBuilder.zzYIY(null, false, shape, zzVU22.zzMI, zzeM2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzYIY(zzZhm.zzO3(stream), progId, asIcon, zzZhm.zzO3(presentation));
    }

    private Shape zzYIY(String string, boolean bl, boolean bl2, zzZhm zzZhm2) throws Exception {
        zzVU2 zzVU22 = zzVU2.zzW8p(zzYfJ.zzX1v(string));
        return this.zzYIY(string, bl, bl2, zzZhm2, zzVU22);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzYIY(fileName, isLinked, asIcon, zzZhm.zzO3(presentation));
    }

    private Shape zzYIY(String string, String string2, boolean bl, boolean bl2, zzZhm zzZhm2) throws Exception {
        zzVU2 zzVU22 = zzVU2.zzZ5i(string2);
        return this.zzYIY(string, bl, bl2, zzZhm2, zzVU22);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzYIY(fileName, progId, isLinked, asIcon, zzZhm.zzO3(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzVU2 zzVU22 = zzVU2.zzW8p(zzYfJ.zzX1v(fileName));
        return this.zzYIY(fileName, isLinked, iconFile, iconCaption, zzVU22);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzVU2 zzVU22 = zzVU2.zzZ5i(progId);
        return this.zzYIY(fileName, isLinked, iconFile, iconCaption, zzVU22);
    }

    private Shape zzYIY(zzZhm zzZhm2, String string, String string2, String string3) throws Exception {
        zzVU2 zzVU22 = zzVU2.zzZ5i(string);
        Shape shape = this.zzYIY(string2, string3, zzVU22);
        zzeM zzeM2 = zzYSy.zzYIY(zzZhm2, string, true);
        return DocumentBuilder.zzYIY(null, false, shape, zzVU22.zzMI, zzeM2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzYIY(zzZhm.zzO3(stream), progId, iconFile, iconCaption);
    }

    final Shape zzYIY(zz1t zz1t2, zzZhm zzZhm2) throws Exception {
        Shape shape = this.zzZPJ(zzZhm2);
        shape.zzZp7(201);
        shape.getOleFormat().zzO3(zz1t2.zzWgU());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzZ3E();
        if (this.zzYlH()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzWdG(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzA1 zzA12 = zzZsm.zzYIY(html, options, this);
        zzA12.zz4j();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzZ3E();
        return zzZsm.zzYIY(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzZ3E();
        return zzZsm.zzYIY(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzWe8 zzWe82 = new zzWe8();
        return zzWe82.zzYIY(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYxb(this).zzYIY(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYxb(this).zzYIY(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zz7q, 75);
        shape.zzYIY(this.zzZXS());
        shape.zzYAx(true);
        shape.getSignatureLine().zzYIY(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzYC4(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzr9(this.zz7q);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzYlH() {
        boolean bl = false;
        if (this.zzYeY().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzYeY().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzWdG(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzZ3E();
        if (this.zzZaD() == null) {
            this.startTable();
        }
        if (this.zzZaD().zzYb9() == 1) {
            this.zzZaD().zzX6v();
        }
        if (this.zzZaD().zzYb9() == 3) {
            this.zzZaD().zzZRK();
        }
        return this.zzZaD().zzLC();
    }

    public Table startTable() {
        this.zzZdI.push(new zzWYF(this));
        return this.zzZaD().startTable();
    }

    public Table endTable() {
        if (this.zzZaD() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzZaD().endTable();
        this.zzZdI.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzZaD() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzZaD().endRow();
        if (this.zzR0 != null && this.zzR0.getHidden()) {
            row.zzWDA().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zz7q, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zz7q, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzWcR();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zz7q, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzW6j();
        bookmarkStart.zzdR(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzWcR();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzW6j();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zz7q, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzXAJ(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zz7q);
        this.zz7O = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zz7O == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zz7q, this.zz7O);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zz7q, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzZxK.zzO3((Object)importFormatOptions, "ImportFormatOptions");
        this.zzZ3E();
        return zzYDz.zzYIY(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zz7q;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zz7q) {
            return;
        }
        this.zz7q = value;
        this.zzWcn(null);
        this.zzJ9 = new zzXEe();
        this.zzYPB = null;
        this.zzDc = null;
        this.zzR0 = null;
        this.zzZdI = new zzWlQ();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzR0 == null) {
            DocumentBuilder documentBuilder = this;
            this.zzR0 = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzR0;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzXdO == null) {
            this.zzXdO = new RowFormat(this);
        }
        return this.zzXdO;
    }

    public CellFormat getCellFormat() {
        if (this.zzY6e == null) {
            this.zzY6e = new CellFormat(this);
        }
        return this.zzY6e;
    }

    final void zzsY(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzXEe zzXEe2 = this.getCurrentParagraph().zzJq();
        this.zzWgt().push(new zzYIY(this.zzZXS(), (zzXEe)zzXEe2.zzZkf()));
    }

    public void popFont() {
        zzWlQ<zzYIY> zzWlQ2 = this.zzWgt();
        if (zzWlQ2.size() > 0) {
            zzYIY zzYIY2 = (zzYIY)this.zzWgt().pop();
            this.zzYIY(zzYIY2.zzWdY(), false);
            this.getCurrentParagraph().zzZZx(zzYIY2.zzWQe());
        }
    }

    final void zzZzP() {
        this.zzVWs().push(this.zzZXS());
    }

    final void zzVR9() {
        zzWlQ<zzXEe> zzWlQ2 = this.zzVWs();
        if (zzWlQ2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzYIY((zzXEe)documentBuilder.zzVWs().pop(), false);
        }
    }

    final void zzZVO() {
        this.zzZjD().push(this.zzZg());
    }

    final void zzWE1() {
        zzWlQ<zzY8j> zzWlQ2 = this.zzZjD();
        if (zzWlQ2.size() > 0) {
            this.getCurrentParagraph().zzYIY((zzY8j)this.zzZjD().pop());
        }
    }

    final zzZ2j zzO3(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzXXQ(88);
        zzYxz zzYxz2 = new zzYxz();
        zzYxz2.setTarget(string2);
        zzYxz2.setScreenTip(string3);
        if (bl) {
            zzYxz2.setSubAddress(string);
        } else {
            zzYxz2.setAddress(zzXqt.zzWIb(string));
            zzYxz2.setSubAddress(zzXqt.zzZRV(string));
        }
        this.zzXFq(zzYxz2.zzZKP());
        FieldSeparator fieldSeparator = this.zz7Q(88);
        return new zzZ2j(fieldStart, fieldSeparator, null);
    }

    final zzZ2j zzXaw(String string, String string2, String string3) {
        boolean bl = zzXqt.zzZBH(string);
        String string4 = bl ? zzXqt.zzZRV(string) : string;
        return this.zzO3(string4, bl, string2, string3);
    }

    final FieldEnd zzY2x() {
        return this.zzYrf(88, true);
    }

    final zzXEe zzZXS() {
        zzXEe zzXEe2 = this.zzJ9;
        return (zzXEe)zzXEe2.zzZkf();
    }

    final zzY8j zzZg() {
        zzY8j zzY8j2 = this.getCurrentParagraph().zzYSx();
        return (zzY8j)zzY8j2.zzZkf();
    }

    final zz4e zzca() {
        zz4e zz4e2 = this.zzWDA();
        return (zz4e)zz4e2.zzZkf();
    }

    final zzZ3i zzXwX() {
        zzZ3i zzZ3i2 = this.zzX6W();
        return (zzZ3i)zzZ3i2.zzZkf();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzYeY(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzYeY().getNodeType() == 8;
    }

    private void zzsY(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzXqF.zzXsU(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzYUo(string2.substring(n4, n4 + n2));
                }
                switch (this.zzZTa) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzZrf(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzYUo(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzZ3E();
        if (this.zzZaD() != null && this.zzZaD().zzYb9() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zzYeY().getParentNode().insertBefore(node, this.zzYeY());
    }

    final void zzYCV(int n) {
        this.zzY9y(true);
        this.zzWoN(n);
    }

    private void zzWoN(int n) {
        this.insertParagraph();
        zzXuX zzXuX2 = new zzXuX(this.getDocument());
        try {
            zzw9 zzw92 = this.getCurrentSection().zzWvg();
            zzw9 zzw93 = (zzw9)zzw92.zzZkf();
            Section section = new Section(this.zz7q, zzw93);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zz7q));
            this.zz7q.insertAfter(section, this.getCurrentSection());
            section.getBody().zzO3(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzXuX2.dispose();
        }
    }

    final FieldStart zzXXQ(int n) {
        this.zzZ3E();
        return zzZsm.zzYIY(n, this.zzZXS(), this.zzYeY(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzXFq(String string) {
        return zzZsm.zzO3(string, this.zzZXS(), this.zzYeY(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzYrf(int n, boolean bl) {
        return zzZsm.zzO3(n, bl, this.zzZXS(), this.zzYeY(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zz7Q(int n) {
        return zzZsm.zzO3(n, this.zzZXS(), this.zzYeY(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzZzK(Node node) {
        FormField formField = new FormField((DocumentBase)this.zz7q, new zzY1(), this.zzZXS());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzY9y(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzZaD() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzYlt(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzYUo(String string) {
        if (this.zzXcK(string)) {
            zzWqd zzWqd2 = new zzWqd(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zz0E zz0E2 : zzWqd2.zzXY8(this.getParagraphFormat().getBidi())) {
                zzWcn zzWcn2 = zzWcn.zzYhS(zz0E2.zzWBk());
                zzXEe zzXEe2 = this.zzZXS();
                zzXEe2.zzXaw(265, zzWcn2);
                if (zz0E2.zzYq8()) {
                    zzXEe2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zz7q, zz0E2.getText(), zzXEe2);
                this.insertNode(run);
            }
            return;
        }
        this.zzZrf(string);
    }

    private boolean zzXcK(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzYgE.zzWBD(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzYIY(zzXEe zzXEe2, boolean bl) {
        zzXEe zzXEe3;
        if (bl) {
            zzXEe zzXEe4 = zzXEe2;
            zzXEe3 = (zzXEe)zzXEe4.zzZkf();
        } else {
            zzXEe3 = zzXEe2;
        }
        this.zzJ9 = zzXEe3;
    }

    final void zzai() {
        this.zzJ9.clear();
    }

    final void zzH2() {
        if (this.zzWcR() != null) {
            zzZ3i zzZ3i2;
            zzZ3i zzZ3i3 = zzZ3i2 = this.zzWcR().zzX6W();
            this.zzXIY = (zzZ3i)zzZ3i3.zzZkf();
            zzZ3i2.zzO3(this.zzXIY);
        }
    }

    private Shape zzYIY(String string, boolean bl, boolean bl2, zzZhm zzZhm2, zzVU2 zzVU22) throws Exception {
        if (zzVU22 == null) {
            throw new NullPointerException("oleInfo");
        }
        Shape shape = this.zzYIY(zzZhm2, bl2, zzVU22, string);
        zzeM zzeM2 = zzYSy.zzYIY(string, bl, bl2, zzVU22);
        return DocumentBuilder.zzYIY(string, bl, shape, zzVU22.zzMI, zzeM2);
    }

    private Shape zzYIY(String string, boolean bl, String string2, String string3, zzVU2 zzVU22) throws Exception {
        if (zzVU22 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string3 == null) {
            string3 = zzYfJ.zzXy8(string);
        }
        Shape shape = string2 != null ? this.zzZ6o(string2, string3) : this.zzYIY(null, string3, zzVU22);
        zzeM zzeM2 = zzYSy.zzYIY(string, bl, true, zzVU22);
        return DocumentBuilder.zzYIY(string, bl, shape, zzVU22.zzMI, zzeM2);
    }

    private static Shape zzYIY(String string, boolean bl, Shape shape, String string2, zzeM zzeM2) {
        if (shape == null) {
            throw new NullPointerException("insertedOleImage");
        }
        shape.zzZp7(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzO3(zzeM2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzYIY(zzZhm zzZhm2, boolean bl, zzVU2 zzVU22, String string) throws Exception {
        if (zzVU22 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (zzZhm2 != null) {
            return this.zzZPJ(zzZhm2);
        }
        if (!bl) {
            return this.zzYfH(zzYSy.zzY3c().get("normal"));
        }
        String string2 = string != null ? zzYfJ.zzXy8(string) : zzYSy.zzWBI(zzVU22.zzWvh);
        return this.zzYIY(zzVU22, string2);
    }

    private Shape zzYIY(String string, String string2, zzVU2 zzVU22) throws Exception {
        if (zzVU22 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string2 == null) {
            string2 = zzYSy.zzWBI(zzVU22.zzWvh);
        }
        if (string != null) {
            return this.zzZ6o(string, string2);
        }
        return this.zzYIY(zzVU22, string2);
    }

    private Shape zzYIY(zzVU2 zzVU22, String string) throws Exception {
        if (zzVU22 == null) {
            throw new NullPointerException("oleInfo");
        }
        byte[] byArray = zzYSy.zzYH(zzVU22.zzWvh);
        zzXeV zzXeV2 = new zzXeV(byArray, null, string, this.getDocument().zzW7a());
        return this.zzYfH(zzXeV2.zzYX2());
    }

    private Shape zzZ6o(String string, String string2) throws Exception {
        zzXeV zzXeV2 = new zzXeV(string, string2, this.getDocument().zzW7a());
        return this.zzYfH(zzXeV2.zzYX2());
    }

    private Shape zzZPJ(zzZhm zzZhm2) throws Exception {
        byte[] byArray = zzZxK.zzYTv(zzZhm2);
        return this.zzYfH(byArray);
    }

    private Shape zzYfH(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zz7q, 1);
        shape.zzZp7(75);
        shape.zzYIY(this.zzZXS());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzYC4(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzYIY(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzO3(compositeNode, n);
            return;
        }
        this.zzZM5(compositeNode, n);
    }

    private void zzO3(CompositeNode compositeNode, int n) {
        zzY1i zzY1i2 = zzY1i.zzYpV(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            zzY1i2.zzYIY(null, true, true, true, false, true);
            node = zzY1i2.getNode();
            if (zzY1i2.zzTu() && (!node.isComposite() || node.zzYAg() != 6 || n != 0)) continue;
            int n2 = node.isComposite() ? ((CompositeNode)node).zzBP().length() : node.getTextLength();
            int n3 = n;
            if (n3 != 0 && (n -= n2) >= 0) continue;
            this.zzYIY(null, node);
            this.zzXMY = n3;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzZM5(CompositeNode compositeNode, int n) {
        zzY1i zzY1i2 = zzY1i.zzW5N(compositeNode);
        while (zzY1i2.getNode() != compositeNode || !zzY1i2.zzTu()) {
            int n2;
            Node node = zzY1i2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzBP().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzYIY(null, node);
                this.zzXMY = n;
                return;
            }
            while (zzY1i2.zzYIY(null, false, true, true, false, true) && zzY1i2.zzTu() && zzY1i2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzZ3E() {
        int n = this.zzXMY;
        if (n == 0) {
            return;
        }
        this.zzXMY = 0;
        Run run = zzZxK.zzYIY((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzYqD(n);
        }
    }

    private Run zzZrf(String string) {
        Run run = new Run(this.zz7q, string, this.zzZXS());
        this.insertNode(run);
        return run;
    }

    final boolean zzW4W() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzXFg() {
        return this.zzZTa;
    }

    final void zzVW1(int n) {
        this.zzZTa = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zzYeY();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzYeY();
        }
        return (Paragraph)this.zzYeY().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzWYF zzZaD() {
        zzWlQ<zzWYF> zzWlQ2 = this.zzZdI;
        if (zzWlQ2.size() > 0) {
            return (zzWYF)this.zzZdI.peek();
        }
        return null;
    }

    private Cell zzWcR() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzWbT();
    }

    private zzWlQ<zzXEe> zzVWs() {
        if (this.zzYPB == null) {
            this.zzYPB = new zzWlQ();
        }
        return this.zzYPB;
    }

    private zzWlQ<zzY8j> zzZjD() {
        if (this.zzDc == null) {
            this.zzDc = new zzWlQ();
        }
        return this.zzDc;
    }

    private zzWlQ<zzYIY> zzWgt() {
        if (this.zzmk == null) {
            this.zzmk = new zzWlQ();
        }
        return this.zzmk;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzJ9.zzVWk(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzYdc(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzYdc(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzJ9.zzXaw(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzXwv()) {
            this.getCurrentParagraph().zzJq().zzXaw(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzJ9.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzJ9.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzXwv()) {
            this.getCurrentParagraph().zzJq().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzWDA().zzVWk(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzWDA().zzX6d(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzWDA().zzYkD(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzWDA().zzXaw(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzWDA().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzWDA().clear();
        zz4e.zzY90().zzO3(this.zzWDA());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzX6W().zzVWk(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzX6W().zzX6d(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzX6W().zzYkD(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzZxK.zzYIY(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzWcR() != null ? this.zzWcR().getCellFormat() : this.getCellFormat();
            border.zzYIY(cellFormat);
        }
        this.zzX6W().zzXaw(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzX6W().clear();
    }

    private Node zzYeY() {
        Node node = this.zzWPB != null && this.zzWPB.getParentNode() == null ? this.zzWHS : this.zzWPB;
        if (node != null && node.zzYAg() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zzWcn(Node node) {
        this.zzWPB = node;
        if (this.zzWPB != null) {
            this.zzWHS = this.zzWPB.getParentNode();
        }
    }

    private zz4e zzWDA() {
        if (this.zzZaD() != null && this.zzZaD().zzYb9() == 1) {
            return this.zzXOo;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzWDA();
        }
        return this.zzXOo;
    }

    private zzZ3i zzX6W() {
        if (this.zzZaD() != null && this.zzZaD().zzYb9() != 3) {
            return this.zzXIY;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzWbT().zzX6W();
        }
        return this.zzXIY;
    }

    static final class zzYIY {
        private zzXEe zzJ9;
        private zzXEe zzZeR;

        public zzYIY(zzXEe zzXEe2, zzXEe zzXEe3) {
            this.zzJ9 = zzXEe2;
            this.zzZeR = zzXEe3;
        }

        public final zzXEe zzWdY() {
            return this.zzJ9;
        }

        public final zzXEe zzWQe() {
            return this.zzZeR;
        }
    }
}

