/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzZxK;
import com.aspose.words.zzVOw;
import com.aspose.words.zzW9p;
import com.aspose.words.zzXhU;
import com.aspose.words.zzXuX;
import com.aspose.words.zzY3R;
import com.aspose.words.zzYqJ;
import com.aspose.words.zzYrK;
import com.aspose.words.zzZsm;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzY3R,
Iterable<T> {
    private Node zzYtI;
    private Node zzY6L;
    private Node zzZfW;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.getParentNode().zzO3((Node)this, true);
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzZmL() {
        return this.zzX7K() != null;
    }

    final boolean zzWqv() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzYgB() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzYqJ) {
                return true;
            }
            CompositeNode compositeNode = zzZxK.zzYIY((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzYgB()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzYtI;
    }

    public Node getLastChild() {
        return this.zzY6L;
    }

    final Node zzX7K() {
        return zzZsm.zzpB(this.getFirstChild(), false);
    }

    final Node zzY8Q() {
        return zzZsm.zzYMa(this.getLastChild(), false);
    }

    final CompositeNode zzYFl() {
        return (CompositeNode)zzZsm.zzpB(this.getFirstChild(), true);
    }

    final CompositeNode zzZuy() {
        return (CompositeNode)zzZsm.zzYMa(this.getLastChild(), true);
    }

    final Node zzYmx() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzZsm.zzZXW((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzYFg() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzZsm.zzZXW((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzYIY(boolean bl, zzW9p zzW9p2) {
        CompositeNode compositeNode = (CompositeNode)super.zzYIY(bl, zzW9p2);
        ((CompositeNode)super.zzYIY(bl, zzW9p2)).zzY6L = null;
        compositeNode.zzYtI = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzWsc(node.zzYIY(true, zzW9p2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzXnd(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzXnd(StringBuilder stringBuilder) {
        this.zzhb(stringBuilder);
        zzZxK.zzO3(stringBuilder, this.zzBP());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzO3(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzZsm.zzZEF(nodeType);
            Node node2 = node = bl ? this.zzX7K() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzZm4() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzXhU.zzZM5(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzXhU.zz1O(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzVOw(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzYIY(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzYIY(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        return this.zzO3(oldChild, false);
    }

    private Node zzO3(Node node, boolean bl) {
        if (node == null) {
            throw new NullPointerException("oldChild");
        }
        if (node.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzYIY(node, (Node)this, null, 1);
        if (documentBase.zzKW() && zzZsm.zzWCk(node)) {
            return node;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzYIY(nodeChangingArgs);
        }
        if (!bl && zzZsm.zzAX(node)) {
            zzZsm.zzXaw(node, false);
        }
        Node node2 = this.zzWwJ(node);
        if (nodeChangingArgs != null) {
            documentBase.zzO3(nodeChangingArgs);
        }
        return node2;
    }

    public void removeAllChildren() {
        zzYrK.zzYC4(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzWsc(Node node) {
        node.getParentNode();
        if (this.zzY6L == null) {
            node.zzBj(null);
            node.zzWbz(null);
            this.zzYtI = node;
        } else {
            node.zzBj(this.zzY6L);
            node.zzWbz(null);
            this.zzY6L.zzWbz(node);
        }
        this.zzY6L = node;
        node.zzT4(this);
        return node;
    }

    final void zzYIY(Node node, Node node2, Node node3) {
        this.zzYIY(node, node2, node3, false);
    }

    final void zzYIY(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzZa1(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzO3(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzZM5(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzZsm.zzZXW(node3.getNodeType())) continue;
            if (zzZsm.zzYTv(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzBP().length();
    }

    String zzBP() {
        return "";
    }

    final String zzXtl() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzhb(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzhb(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzXnd(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzYIY(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzO3(visitor));
    }

    abstract int zzYIY(DocumentVisitor var1) throws Exception;

    abstract int zzO3(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzZa1(Node var1);

    final Node zzYIY(Node node, Node node2, boolean bl) {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzZrz(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzZa1(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zzXuX(documentBase);
            try {
                compositeNode.zzO3(node, true);
            }
            finally {
                ((zzXuX)object).dispose();
            }
        }
        if ((object = documentBase.zzYIY(node, null, (Node)this, 0)) != null) {
            documentBase.zzYIY((NodeChangingArgs)object);
        }
        if (this.zzY6L == null) {
            node.zzBj(null);
            node.zzWbz(null);
            this.zzYtI = node;
            this.zzY6L = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzO3(node, node2);
            } else {
                this.zzZM5(node, this.zzYtI);
            }
        } else if (node2 != null) {
            this.zzZM5(node, node2);
        } else {
            this.zzO3(node, this.zzY6L);
        }
        node.zzT4(this);
        if (object != null) {
            documentBase.zzO3((NodeChangingArgs)object);
        }
        if (documentBase.zzKW()) {
            zzZsm.zzYIY(node, compositeNode, node3);
        }
        return node;
    }

    private void zzO3(Node node, Node node2) {
        Node node3 = node2.zzWa2();
        node.zzBj(node2);
        node.zzWbz(node3);
        node2.zzWbz(node);
        if (node3 == null) {
            this.zzY6L = node;
            return;
        }
        node3.zzBj(node);
    }

    private void zzZM5(Node node, Node node2) {
        Node node3 = node2.zzE9();
        node.zzBj(node3);
        node.zzWbz(node2);
        node2.zzBj(node);
        if (node3 == null) {
            this.zzYtI = node;
            return;
        }
        node3.zzWbz(node);
    }

    private Node zzWwJ(Node node) {
        if (node == this.zzYtI) {
            if (this.zzYtI == this.zzY6L) {
                this.zzYtI = null;
                this.zzY6L = null;
            } else {
                this.zzYtI = node.zzWa2();
                this.zzYtI.zzBj(null);
            }
        } else {
            Node node2 = node.zzE9();
            Node node3 = node.zzWa2();
            node2.zzWbz(node3);
            if (node3 == null) {
                this.zzY6L = node2;
            } else {
                node3.zzBj(node2);
            }
        }
        node.zzWbz(null);
        node.zzBj(null);
        node.zzT4(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzZfW = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzZfW;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

