/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzY1j;
import com.aspose.words.internal.zzZxK;
import com.aspose.words.zzM8;
import com.aspose.words.zzXoy;
import com.aspose.words.zzXwc;
import com.aspose.words.zzYBa;
import com.aspose.words.zzYFf;
import com.aspose.words.zzYOs;
import com.aspose.words.zzZN1;
import com.aspose.words.zzZvJ;
import com.aspose.words.zzde;
import com.aspose.words.zzqF;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzXwc zzVYg;

    ChartSeriesCollection(zzXwc dmlChart) {
        this.zzVYg = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzVYg.zzXM2().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzVYg.zzXM2().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzVYg.zzXM2().removeAt(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzVYg.zzXM2().clear();
        this.zzWbz(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYIY(seriesName, values);
        chartSeries.zzVi().zz1O(ChartSeriesCollection.zzia(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYIY(seriesName, yValues);
        chartSeries.zzVi().zz1O(ChartSeriesCollection.zz1O(xValues));
        return chartSeries;
    }

    private ChartSeries zzYIY(String string, zzY1j[] zzY1jArray, double[] dArray) {
        if (zzY1jArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzY1jArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzY1jArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYIY(string, dArray);
        chartSeries.zzVi().zz1O(ChartSeriesCollection.zzYIY(zzY1jArray));
        if (!this.zzVYg.zzXOa()) {
            this.zzWbz(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzYIY(seriesName, zzY1j.zzYIY(dates), values);
    }

    private void zzWbz(boolean bl) {
        zzXoy zzXoy2 = zzZxK.zzYIY((Object)this.zzVYg, zzXoy.class);
        if (zzXoy2 != null && zzXoy2.zzXy7().zzXN0()) {
            zzXoy2.zzXy7().zz4u().zzZNW(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzVYg.zzbQ() != 15) {
            this.zzVYg.zzXJV(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzYIY(seriesName, yValues);
        chartSeries.zzyn().zzZDt().zzZNW(3, this.zzVYg.zzXTL());
        chartSeries.zzVi().zz1O(ChartSeriesCollection.zz1O(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzZNu().zz1O(ChartSeriesCollection.zz1O(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzYIY(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzVYg);
        chartSeries.setName(string);
        this.zzP5(chartSeries);
        chartSeries.zzYxe(this.zzVYg.zzYPD().zzWu3() + 1);
        chartSeries.zzY5C(this.zzVYg.zzYPD().zzVVq() + 1);
        chartSeries.zzXDD().zz1O(ChartSeriesCollection.zz1O(dArray));
        this.zzVYg.zzVPO().zzWLn();
        this.zzVYg.zzXM2().zzXac(chartSeries);
        return chartSeries;
    }

    private void zzP5(ChartSeries chartSeries) {
        chartSeries.zzyn().zzZDt().zzZNW(5, new zzYBa());
        switch (this.zzVYg.zzbQ()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzYIY(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzYIY(chartSeries, 5);
                ChartSeriesCollection.zzZEl(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzYIY(chartSeries, 1);
                ChartSeriesCollection.zzZEl(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzXaw(chartSeries);
            }
        }
    }

    private static void zzXaw(ChartSeries chartSeries) {
        zzYBa zzYBa2 = new zzYBa();
        zzYBa2.setOutline(new zzYFf());
        zzYOs zzYOs2 = new zzYOs();
        zzYOs2.zzYZb(1);
        zzYBa2.getOutline().setFill(new zzde(zzYOs2));
        zzYBa2.getOutline().zz6z(19050.0);
        chartSeries.zzyn().zzZDt().zzZNW(5, zzYBa2);
    }

    private static void zzZEl(ChartSeries chartSeries) {
        zzYBa zzYBa2 = new zzYBa();
        zzYBa2.setOutline(new zzYFf());
        zzYBa2.getOutline().setFill(new zzZN1());
        zzYBa2.getOutline().setEndCap(0);
        zzYBa2.getOutline().zz6z(19050.0);
        chartSeries.zzyn().zzZDt().zzZNW(5, zzYBa2);
    }

    private static void zzYIY(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzZPr());
        chartMarker.zzm0().zzZNW(0, n);
        chartSeries.zzyn().zzZDt().zzZNW(4, chartMarker);
    }

    private static zzZvJ zz1O(double[] dArray) {
        int n = 0;
        zzZvJ zzZvJ2 = new zzZvJ(2);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzZvJ2.zzZa1(new zzM8(n, d, "General"));
            }
            ++n;
        }
        zzZvJ2.zzWjp(dArray.length);
        return zzZvJ2;
    }

    private static zzZvJ zzYIY(zzY1j[] zzY1jArray) {
        int n = 0;
        zzZvJ zzZvJ2 = new zzZvJ(2);
        zzY1j[] zzY1jArray2 = zzY1jArray;
        int n2 = zzY1jArray.length;
        for (int i = 0; i < n2; ++i) {
            zzY1j zzY1j2 = zzY1jArray2[i];
            zzZvJ2.zzZa1(new zzM8(n++, zzY1j2.zzXC7(), "m/d/yyyy"));
        }
        zzZvJ2.zzWjp(zzY1jArray.length);
        return zzZvJ2;
    }

    private static zzZvJ zzia(String[] stringArray) {
        int n = 0;
        zzZvJ zzZvJ2 = new zzZvJ(1);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzZvJ2.zzZa1(new zzqF(n++, string));
        }
        zzZvJ2.zzWjp(stringArray.length);
        return zzZvJ2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzVYg.zzXM2().getCount();
    }
}

