/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXXA;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzEr;
import com.aspose.words.net.System.Data.zzYJv;
import com.aspose.words.net.System.Data.zzYtN;
import com.aspose.words.net.System.Data.zzZpP;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzYca;
    private final DataColumnCollection zzYDA;
    private final ConstraintCollection zzXn9;
    private final zzYtN zzW9I;
    private ResultSet zzWre;
    private String zzwP;
    private DataSet zzYba;
    private String zzUc;
    private UniqueConstraint zzWWx;
    private boolean zzXLn;
    private final List<DataTableEventListener> zzXOJ;
    private final Set<DataRow> zzZXo;
    private DataRelationCollection zzWDO;

    public DataTable() {
        this.zzYca = new DataRowCollection(this);
        this.zzYDA = new DataColumnCollection(this);
        this.zzXn9 = new ConstraintCollection(this);
        this.zzW9I = new zzYtN(this);
        this.zzUc = "";
        this.zzXLn = true;
        this.zzXOJ = new ArrayList<DataTableEventListener>();
        this.zzZXo = new HashSet<DataRow>();
        this.zzWDO = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzYca = new DataRowCollection(this);
        this.zzYDA = new DataColumnCollection(this);
        this.zzXn9 = new ConstraintCollection(this);
        this.zzW9I = new zzYtN(this);
        this.zzUc = "";
        this.zzXLn = true;
        this.zzXOJ = new ArrayList<DataTableEventListener>();
        this.zzZXo = new HashSet<DataRow>();
        this.zzWDO = new DataRelationCollection();
        this.zzwP = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzEr.zzYl6(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzYca = new DataRowCollection(this);
        this.zzYDA = new DataColumnCollection(this);
        this.zzXn9 = new ConstraintCollection(this);
        this.zzW9I = new zzYtN(this);
        this.zzUc = "";
        this.zzXLn = true;
        this.zzXOJ = new ArrayList<DataTableEventListener>();
        this.zzZXo = new HashSet<DataRow>();
        this.zzWDO = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzWre = resultSet;
        this.zzwP = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzWre != null) {
            if (this.zzWre.getStatement() != null) {
                this.zzWre.getStatement().getConnection().close();
            }
            this.zzWre = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzwP;
    }

    public void setTableName(String tableName) {
        this.zzwP = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzYDA.getCount();
    }

    public String getColumnName(int index) {
        return this.zzYDA.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzWre;
    }

    public DataSet getDataSet() {
        return this.zzYba;
    }

    final void zzX2p(DataSet dataSet) {
        this.zzYba = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzYba.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzWDO.add(dataRelation);
        }
        return this.zzWDO;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzYba.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzYca;
    }

    public DataColumnCollection getColumns() {
        return this.zzYDA;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzXn9;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzWWx == null) {
            return new DataColumn[0];
        }
        return this.zzWWx.getColumns();
    }

    final void zzYtN(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzWWx != null) {
                this.zzWWx.zzYpC(false);
                this.getConstraints().remove(this.zzWWx);
                this.zzWWx = null;
            }
            return;
        }
        if (this.zzWWx != null && DataColumn.areColumnSetsTheSame(value, this.zzWWx.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzYl6(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzWWx != null) {
            this.zzWWx.zzYpC(false);
            this.getConstraints().remove(this.zzWWx);
            this.zzWWx = null;
        }
        UniqueConstraint.zzYl6(this.getConstraints(), uniqueConstraint);
        this.zzWWx = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzUc;
    }

    public void setNamespace(String namespace) {
        this.zzUc = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzXLn;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzXLn = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzZXo.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzEr.zzYl6(this.getResultSet(), this);
            zzEr.zzEr(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzXXA.zzX2p(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzEr.zzW5C(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzXOJ.contains(listener)) {
            this.zzXOJ.add(listener);
        }
    }

    public void removeEventListener(zzYJv listener) {
        if (this.zzXOJ.contains(listener)) {
            this.zzXOJ.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzXOJ.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzZXo.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXOJ) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzZXo.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXOJ) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzZXo.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXOJ) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXOJ) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXOJ) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzZpP zzYl6(zzEr[] zzErArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzErArray.length];
        for (int i = 0; i < zzErArray.length; ++i) {
            dataColumnArray[i] = zzErArray[i].zzYYE();
        }
        DataTable dataTable = this;
        zzZpP zzZpP2 = dataTable.zzW9I.zzX2p(dataColumnArray);
        if (zzZpP2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzZpP2;
    }

    final zzYtN zzZZV() {
        return this.zzW9I;
    }

    final Set<DataRow> zzWpy() {
        return this.zzZXo;
    }
}

