/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzWrJ;
import com.aspose.words.internal.zzXSy;
import com.aspose.words.internal.zzXgt;
import com.aspose.words.internal.zzYiy;
import com.aspose.words.internal.zzYvg;
import com.aspose.words.internal.zzZdl;
import com.aspose.words.internal.zzZrQ;
import com.aspose.words.zzXYS;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzZgu;
    private zzXYS zzvd;

    Watermark(Document doc, zzXYS watermarkProvider) {
        this.zzZgu = doc;
        this.zzvd = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzRk(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzYl6(text, textWatermarkOptions, this.zzZgu);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzXSy.zzEr((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzZgu, 75);
        shape.getImageData().setImage(image);
        this.zzYl6(shape, options, this.zzZgu);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzXSy.zzEr((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzZgu, 75);
        shape.getImageData().setImage(imagePath);
        this.zzYl6(shape, options, this.zzZgu);
    }

    public final int getType() {
        Shape shape = this.zzvd.get();
        if (shape == null) {
            return 2;
        }
        shape.zzGp();
        if (shape.zzYgX()) {
            return 0;
        }
        if (shape.zzZMW()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzvd.add(shape);
    }

    public final void remove() {
        this.zzvd.remove();
    }

    private static void zzRk(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (zzZrQ.zzY0m(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzXSy.zzYl6(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzYl6(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzEr(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzW5C(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzEr(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzZWA() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzkq()) / d2) > (double)(f = pageSetup.zzZL0())) {
            d = (double)f / d3;
        }
        shape.zzrk(zzWrJ.zzYJv(d2 * d, 2, zzXgt.zzXha));
        shape.zzXd6(zzWrJ.zzYJv(d3 * d, 2, zzXgt.zzXha));
    }

    private Shape zzYl6(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzYl6(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzW5C(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzYl6(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzZfy() ? 1.0f : textWatermarkOptions.getFontSize();
        zzYvg zzYvg2 = document.zzX0c().zzYJv(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzYvg2.zzZae(shape.getTextPath().getText());
        if (textWatermarkOptions.zzZfy()) {
            l = Watermark.zzYl6(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzrk(zzWrJ.zzYJv(Float.intBitsToFloat(n), 2, zzXgt.zzXha));
        shape.zzXd6(zzWrJ.zzYJv(zzZdl.zzZuU(l), 2, zzXgt.zzXha));
    }

    private static long zzYl6(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzkq();
        float f2 = pageSetup.zzZL0();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzZdl.zzZuU(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzZdl.zzX6a(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzZdl.zzZuU(l) >= Float.intBitsToFloat(n)) {
            return zzZdl.zzX6a(f2 / f3, f2);
        }
        float f6 = f;
        return zzZdl.zzX6a(f6, f6 * f3);
    }

    private static void zzW5C(Shape shape, String string) {
        shape.setName(zzYiy.zzEr("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
    }
}

