/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzWXO;
import com.aspose.words.internal.zzXSy;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzVZ0;
import com.aspose.words.zzWyN;
import com.aspose.words.zzXme;
import com.aspose.words.zzYHT;
import com.aspose.words.zzng;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzWxF;
    private Node zzUZ;
    private Node zzZ3m;
    private int zzZGP;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzYJv(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzWxF == null) {
            return null;
        }
        if (this.zzWxF.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzWxF;
    }

    final CompositeNode zzYTd() {
        if (zzVZ0.zzK6(this.getParentNode())) {
            return this.getParentNode().zzYTd();
        }
        return this.getParentNode();
    }

    final CompositeNode zzWvV() {
        if (zzVZ0.zzK6(this.getParentNode()) || zzVZ0.zzY6N(this.getParentNode())) {
            return this.getParentNode().zzWvV();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzWxF != null) {
            return this.zzWxF.getDocument();
        }
        return null;
    }

    final Document zzWad() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzWZx() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzZ2b();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzZ3m;
    }

    final Node zzgO() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzVZ0.zzxV((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzPg() {
        Node node = zzVZ0.zzWz8(this.getPreviousSibling(), false);
        if (node == null && zzVZ0.zzK6(this.getParentNode())) {
            node = this.getParentNode().zzPg();
        }
        return node;
    }

    final Node zzZvT() {
        Node node = zzVZ0.zzX81(this.getNextSibling(), false);
        if (node == null && zzVZ0.zzK6(this.getParentNode())) {
            node = this.getParentNode().zzZvT();
        }
        return node;
    }

    final CompositeNode zzYWK() {
        Node node = this;
        while ((node = node.zzPg()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzsZ() {
        Node node = this;
        while ((node = node.zzZvT()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzUZ;
    }

    final Node zzZKy() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzVZ0.zzxV((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzXMl() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzXYf() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zz4X() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzVZ0.zzWlq(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzY76() {
        return this.zzUZ;
    }

    final void zzW6n(Node node) {
        this.zzUZ = node;
    }

    final Node zzXMW() {
        return this.zzZ3m;
    }

    final void zzW69(Node node) {
        this.zzZ3m = node;
    }

    final Node zzX38() {
        Node node = this;
        if (node.zzUZ != null) {
            node = this;
            return node.zzUZ;
        }
        return this.getParentNode();
    }

    final int zzZZp() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzVZ0.zzWjm(this);
        boolean bl2 = zzVZ0.zzYC1(this);
        boolean bl3 = zzVZ0.zzYnp(this);
        boolean bl4 = zzVZ0.zzZae(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzZZp() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzZZp() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzYl6(isCloneChildren, new zzYl6(this));
    }

    Node zzYl6(boolean bl, zzXme zzXme2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzWxF != null) {
            node.zzWxF = this.getDocument().zzZUh();
        }
        node.zzUZ = null;
        node.zzZ3m = null;
        if (zzXme2 != null) {
            zzXme2.zzX2p(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzZxd(StringBuilder stringBuilder) {
        zzXSy.zzEr(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzZvF(Node node) {
        this.zzWxF = node != null ? node : this.getDocument().zzZUh();
    }

    final void zzYJv(DocumentBase documentBase) {
        this.zzWxF = documentBase != null ? documentBase.zzZUh() : null;
    }

    final boolean zzLs(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzvC() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzND(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzYbE(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzh2(Node node, int n) {
        for (Node node2 = this.nextPreOrder(node); node2 != null; node2 = node2.nextPreOrder(node)) {
            if (node2.getNodeType() != 8) continue;
            return node2;
        }
        return null;
    }

    final Node zzZQw(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzYyL(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzYHT zzYHT2 = zzVZ0.zzWTp(saveFormat);
        return zzYHT2.zzWOn(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzYHT zzYHT2 = zzVZ0.zzEr(saveOptions);
        return zzYHT2.zzWOn(this);
    }

    final Node zz0z(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzVZ0.zzZIC(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzWyN zzVT3() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzWyN.zzX8S(node);
        }
        return zzWyN.zzWgz(this.getParentNode());
    }

    final zzWyN zzZTY() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzWyN.zzWgz(node);
        }
        return zzWyN.zzX8S(this.getParentNode());
    }

    final boolean zzXig(Node node) {
        return Node.zzWzF(this, node);
    }

    final boolean zzXN3() {
        return this.getAncestor(1) == null;
    }

    static Node zzW9i(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzWXO<Node> zzWXO2 = Node.zzZuV(node);
        zzWXO<Node> zzWXO3 = Node.zzZuV(node2);
        return Node.zzYl6(zzWXO2, zzWXO3);
    }

    static boolean zzWzF(Node node, Node node2) {
        zzWXO<Node> zzWXO2;
        if (node == null || node2 == null) {
            return false;
        }
        zzWXO<Node> zzWXO3 = Node.zzZuV(node);
        Node node3 = Node.zzYl6(zzWXO3, zzWXO2 = Node.zzZuV(node2));
        if (node3 == null) {
            return false;
        }
        zzWXO<Node> zzWXO4 = zzWXO3;
        if (zzWXO4.size() == 0 || (zzWXO4 = zzWXO2).size() == 0) {
            zzWXO4 = zzWXO2;
            boolean bl = zzWXO4.size() > 0;
            return bl;
        }
        Object e = zzWXO3.peek();
        Object e2 = zzWXO2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes()) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzWXO<Node> zzZuV(Node node) {
        zzWXO<Node> zzWXO2 = new zzWXO<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzWXO2.push(node2);
        }
        return zzWXO2;
    }

    private static Node zzYl6(zzWXO<Node> zzWXO2, zzWXO<Node> zzWXO3) {
        Node node = null;
        while (zzWXO2.peek() == zzWXO3.peek()) {
            node = (Node)zzWXO2.pop();
            zzWXO3.pop();
            zzWXO<Node> zzWXO4 = zzWXO2;
            if (zzWXO4.size() != 0 && (zzWXO4 = zzWXO3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzZGP;
    }

    public void setCustomNodeId(int value) {
        this.zzZGP = value;
    }

    public String toString() {
        return super.toString();
    }

    public void dd() {
    }

    final Node zzZIC(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzZae(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzYC1(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zzZae(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zzZae(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zzYl6
    implements zzXme {
        private Node zzZxF;
        private HashMap<Integer, Integer> zzG6;

        zzYl6(Node node) {
            this.zzZxF = node;
        }

        @Override
        public final void zzX2p(Node node, Node node2) {
            if (node == this.zzZxF) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zzng zzng2 = (zzng)((Object)node2);
            if (this.zzG6 == null) {
                this.zzG6 = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zzXSy.zzYl6(this.zzG6, Integer.valueOf(zzng2.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzX7Q();
                zzXSy.zzEr(this.zzG6, Integer.valueOf(zzng2.getIdInternal()), Integer.valueOf(n));
            }
            zzng2.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zzXSy.zzYl6(this.zzG6, Integer.valueOf(zzng2.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zzng2.setParentIdInternal(n2);
            }
        }
    }
}

