/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zz0h;
import com.aspose.words.internal.zz3T;
import com.aspose.words.internal.zzVOI;
import com.aspose.words.internal.zzVSb;
import com.aspose.words.internal.zzVXZ;
import com.aspose.words.internal.zzWdF;
import com.aspose.words.internal.zzXAV;
import com.aspose.words.internal.zzXSy;
import com.aspose.words.internal.zzXfW;
import com.aspose.words.internal.zzYUE;
import com.aspose.words.internal.zzYfD;
import com.aspose.words.internal.zzYiy;
import com.aspose.words.zzAB;
import com.aspose.words.zzWHR;
import com.aspose.words.zzWKP;
import com.aspose.words.zzWz9;
import com.aspose.words.zzX7s;
import com.aspose.words.zzXAR;
import com.aspose.words.zzXAt;
import com.aspose.words.zzY8U;
import com.aspose.words.zzYRq;
import com.aspose.words.zzZHJ;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzYl6(zzXAV zzXAV2, zzXAV zzXAV3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzXSy.zzEr((Object)zzXAV2, "srcStream");
        zzXSy.zzEr((Object)zzXAV3, "dstStream");
        zzXSy.zzEr((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzEr(zzXAV2, zzXAV3, certificateHolder, signOptions);
        zzXAV3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzYl6(zzXAV.zzEr(srcStream), (zzXAV)zzXAV.zzYJv(dstStream), certHolder, signOptions);
    }

    private static void zzEr(zzXAV zzXAV2, zzXAV zzXAV3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzYJv(digitalSignature);
        }
        if (zzY8U.zzSb(zzXAV2)) {
            DigitalSignatureUtil.zzYl6(zzXAV2, zzXAV3, digitalSignature, true);
            return;
        }
        zzY8U zzY8U2 = new zzY8U();
        zzXAV zzXAV4 = zzXAV2;
        zzY8U zzY8U3 = zzY8U2;
        FileFormatInfo fileFormatInfo = zzY8U2.zzEr(zzXAV4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzXfW zzXfW2 = new zzXfW(zzXAV2);
                int n = fileFormatInfo.zzWCd() == 1 ? 1 : 2;
                zzXAR.zzYl6(zzXfW2, digitalSignature, n);
                zzXAV3.zzWmS(0L);
                zzXfW2.zzZxd(zzXAV3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzYl6(fileFormatInfo.zzX7I(), zzXAV3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzYl6(zzXAV2, zzXAV3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzYl6(zzXAV2, zzXAV3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzXSy.zzEr(srcFileName, "srcFileName");
        zzXSy.zzEr(dstFileName, "dstFileName");
        try (zz3T zz3T2 = zzXSy.zzEr(srcFileName, 3, 1);){
            try (zz3T zz3T3 = zzXSy.zzEr(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzYl6((zzXAV)zz3T2, (zzXAV)zz3T3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzYUE zzYUE2 = zzXAV.zzYJv(dstStream);
        zzXAV zzXAV2 = zzXAV.zzEr(srcStream);
        DigitalSignatureUtil.zzYl6(zzXAV2, (zzXAV)zzYUE2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zz3T zz3T2 = zzXSy.zzEr(srcFileName, 3, 1);){
            try (zz3T zz3T3 = zzXSy.zzEr(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzX2p(zz3T2, zz3T3);
            }
            return;
        }
    }

    private static void zzX2p(zzXAV zzXAV2, zzXAV zzXAV3) throws Exception {
        zzY8U zzY8U2 = new zzY8U();
        zzXAV zzXAV4 = zzXAV2;
        zzY8U zzY8U3 = zzY8U2;
        FileFormatInfo fileFormatInfo = zzY8U2.zzEr(zzXAV4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzXfW zzXfW2 = new zzXfW(zzXAV2);
                zzXfW2.zzXxG().zzWjm("_xmlsignatures");
                zzXfW2.zzXxG().zzWjm("_signatures");
                zzXAV3.zzXp0(0L);
                zzXfW2.zzZxd(zzXAV3);
                zzXAV zzXAV5 = zzXAV3;
                zzXAV5.zzWmS(zzXAV5.zzWUQ());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzWdF zzWdF2 = new zzWdF(zzXAV2);
                zzVOI zzVOI2 = zzWdF2.zzYl6(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzVOI2 != null) {
                    for (zzVXZ zzVXZ2 : zzVOI2.zzYV6()) {
                        String string = zzVOI2.zzYl6(zzVXZ2);
                        zzWdF2.zzWx6().remove(string);
                    }
                    zzWdF2.zzWx6().remove(zzVOI2.getName());
                    zzVXZ zzVXZ3 = zzWdF2.zzYV6().zzLW("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzWdF2.zzYV6().remove(zzVXZ3.getId());
                    zzWdF2.zzVU1();
                }
                zzXAV3.zzXp0(0L);
                zzWdF2.zzZxd(zzXAV3);
                zzXAV zzXAV6 = zzXAV3;
                zzXAV6.zzWmS(zzXAV6.zzWUQ());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzX2p(zzXAV.zzEr(srcStream), zzXAV.zzYJv(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zz3T zz3T2 = zzXSy.zzEr(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzVUR(zz3T2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzVUR(zzXAV zzXAV2) throws Exception {
        if (zzY8U.zzSb(zzXAV2)) {
            return DigitalSignatureUtil.zzWvP(zzXAV2);
        }
        zzY8U zzY8U2 = new zzY8U();
        zzXAV zzXAV3 = zzXAV2;
        zzY8U zzY8U3 = zzY8U2;
        FileFormatInfo fileFormatInfo = zzY8U2.zzEr(zzXAV3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzXAV2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzVUR(zzXAV.zzEr(stream));
    }

    static zz0h zzYl6(zzXfW zzXfW2, String string) throws Exception {
        zzXAt zzXAt2 = new zzXAt(zzXfW2);
        if (zzXAt2.zzuH()) {
            zz0h zz0h2 = zzXAt2.zzXFG(string);
            return zz0h2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzYvi(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzYiy.zzEr("Unexpected digest algorithm: {0}.", n));
    }

    static String zzX8S(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzYvi(n);
    }

    private static void zzYl6(zzXAV zzXAV2, zzXAV zzXAV3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzWdF zzWdF2 = new zzWdF(zzXAV2);
        zzWKP zzWKP2 = bl ? new zzX7s(zzWdF2) : new zzWz9(zzWdF2);
        zzWKP2.zzEr(digitalSignature);
        zzXAV3.zzWmS(0L);
        zzWdF2.zzZxd(zzXAV3);
    }

    private static void zzYl6(zzXAV zzXAV2, zzXAV zzXAV3, DigitalSignature digitalSignature) throws Exception {
        zzZHJ zzZHJ2 = new zzZHJ(zzXAV2);
        zzWHR zzWHR2 = new zzWHR(zzZHJ2);
        zzWHR2.zzEr(digitalSignature);
        zzXAV3.zzWmS(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzXAV zzXAV4 = zzXAV3;
        zzZHJ zzZHJ3 = zzZHJ2;
        zzZHJ3.zzYl6(zzXAV4, string, null);
    }

    private static void zzYl6(zzXfW zzXfW2, zzXAV zzXAV2, DigitalSignature digitalSignature, String string) throws Exception {
        zz0h zz0h2 = DigitalSignatureUtil.zzYl6(zzXfW2, string);
        zz0h zz0h3 = new zz0h();
        DigitalSignatureUtil.zzYl6((zzXAV)zz0h2, (zzXAV)zz0h3, digitalSignature, false);
        zzXfW zzXfW3 = zzXAt.zzYJv(zz0h3, string);
        zzXfW3.zzZxd(zzXAV2);
    }

    private static DigitalSignatureCollection zzWvP(zzXAV zzXAV2) throws Exception {
        zzXAV2.zzXp0(0L);
        zzWdF zzWdF2 = new zzWdF(zzXAV2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzVOI zzVOI2 = zzWdF2.zzYl6(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzVOI2 != null) {
            for (zzVXZ zzVXZ2 : zzVOI2.zzYV6()) {
                String string = zzVOI2.zzYl6(zzVXZ2);
                zzVOI zzVOI3 = zzWdF2.zzXF7(string);
                zzVOI zzVOI4 = zzWdF2.zzYl6(zzVOI3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzVSb zzVSb2 = zzYfD.zzX6a(zzVOI4.zzYae().zzSo());
                zzYRq.zzYl6(zzVOI3.zzXpw(), zzVSb2, new zzAB(zzWdF2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

