/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzXSy;
import com.aspose.words.zzVZ0;
import com.aspose.words.zzWEU;
import com.aspose.words.zzXKV;
import com.aspose.words.zzXme;
import com.aspose.words.zzXtx;
import com.aspose.words.zzYU;
import com.aspose.words.zzZ8E;
import com.aspose.words.zzZEb;
import com.aspose.words.zzZfg;
import com.aspose.words.zzZuz;

public class Cell
extends CompositeNode<Node>
implements zzWEU,
zzZfg {
    private zzXKV zzYA7;
    private CellFormat zz7o;
    private ParagraphCollection zzXVX;
    private TableCollection zzCn;

    public Cell(DocumentBase doc) {
        this(doc, new zzXKV());
    }

    Cell(DocumentBase doc, zzXKV cellPr) {
        super(doc);
        this.zzYA7 = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    final Cell zzOA() {
        return (Cell)this.zzsZ();
    }

    public Row getParentRow() {
        return (Row)this.zzYTd();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzYEH() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzYJv(this, true);
        }
        return -1;
    }

    final int zzZeG() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzZeG();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zz7o == null) {
            this.zz7o = new CellFormat(this);
        }
        return this.zz7o;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzXVX == null) {
            this.zzXVX = new ParagraphCollection(this);
        }
        return this.zzXVX;
    }

    public TableCollection getTables() {
        if (this.zzCn == null) {
            this.zzCn = new TableCollection(this);
        }
        return this.zzCn;
    }

    final zzXKV zzWUt() {
        return this.zzYA7;
    }

    final void zzYl6(zzXKV zzXKV2) {
        this.zzYA7 = zzXKV2;
    }

    @Override
    final Node zzYl6(boolean bl, zzXme zzXme2) {
        zzXKV zzXKV2;
        Cell cell = (Cell)super.zzYl6(bl, zzXme2);
        zzXKV zzXKV3 = this.zzYA7;
        cell.zzYA7 = zzXKV2 = (zzXKV)zzXKV3.zzW7g();
        cell.zz7o = null;
        cell.zzXVX = null;
        cell.zzCn = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzYl6(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellStart(this);
    }

    @Override
    final int zzEr(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzXtx.zzX6a(this);
    }

    @Override
    final boolean zzlE(Node node) {
        return zzVZ0.zzYC1(node);
    }

    final int zzV() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        Cell cell = row.getFirstCell();
        while (cell != null) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell == this) {
                return n;
            }
            Cell cell2 = cell;
            cell = (Cell)cell2.zzsZ();
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzYA7.zzXj5(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzYA7.zzXj5(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzZuz zzZuz2 = zzXSy.zzYl6(object, zzZuz.class);
        if (zzZuz2 != null && zzZuz2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzZ9z(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzXKV.zz0K(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzYA7.zzn1(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzYA7.clear();
    }

    private Object zzZ9z(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzXSy.zzYl6((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzYl6(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZEb getInsertRevision() {
        Cell cell = this;
        return cell.zzYA7.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzZEb value) {
        Cloneable cloneable = this;
        zzZEb zzZEb2 = value;
        cloneable = cloneable.zzYA7;
        ((zzYU)cloneable).zzn1(14, zzZEb2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZEb getDeleteRevision() {
        Cell cell = this;
        return cell.zzYA7.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzZEb value) {
        Cloneable cloneable = this;
        zzZEb zzZEb2 = value;
        cloneable = cloneable.zzYA7;
        ((zzYU)cloneable).zzn1(12, zzZEb2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZ8E getMoveFromRevision() {
        Cell cell = this;
        return cell.zzYA7.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzZ8E value) {
        Cloneable cloneable = this;
        zzZ8E zzZ8E2 = value;
        cloneable = cloneable.zzYA7;
        ((zzYU)cloneable).zzn1(13, zzZ8E2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZ8E getMoveToRevision() {
        Cell cell = this;
        return cell.zzYA7.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzZ8E value) {
        Cloneable cloneable = this;
        zzZ8E zzZ8E2 = value;
        cloneable = cloneable.zzYA7;
        ((zzYU)cloneable).zzn1(15, zzZ8E2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzYA7.remove(13);
        cell = this;
        cell.zzYA7.remove(15);
    }

    final zzXKV zzWaO(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzXKV zzXKV2 = new zzXKV();
        this.zzYl6(3120, zzXKV2);
        this.zzYl6(3140, zzXKV2);
        this.zzYl6(3110, zzXKV2);
        this.zzYl6(3130, zzXKV2);
        this.zzYl6(3090, zzXKV2);
        this.zzYl6(3100, zzXKV2);
        this.zzYl6(3070, zzXKV2);
        this.zzYl6(3080, zzXKV2);
        if (bl && (tableStyle = zzXSy.zzYl6((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzEr(this, zzXKV2);
        }
        this.zzYA7.zzEr((zzYU)zzXKV2);
        return zzXKV2;
    }

    private void zzYl6(int n, zzXKV zzXKV2) {
        zzXKV2.zzn1(n, this.fetchInheritedCellAttr(n));
    }
}

