/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzYX0;
import com.aspose.words.internal.zzYlQ;
import com.aspose.words.zzWsD;
import com.aspose.words.zzYzR;
import com.aspose.words.zzZqj;

public final class Section
extends CompositeNode<Node>
implements zzWsD {
    private zzYzR zzRg;
    private PageSetup zzXFf;
    private HeaderFooterCollection zzU4;

    public Section(DocumentBase doc) {
        this(doc, new zzYzR());
    }

    Section(DocumentBase doc, zzYzR sectPr) {
        super(doc);
        this.zzRg = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzU4 == null) {
            this.zzU4 = new HeaderFooterCollection(this);
        }
        return this.zzU4;
    }

    public final PageSetup getPageSetup() {
        if (this.zzXFf == null) {
            Section section = this;
            this.zzXFf = new PageSetup(section, section.getDocument().zzYlp(), this.getDocument().getStyles(), new zzYyt(this));
        }
        return this.zzXFf;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzcI();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzZtV(!value);
    }

    final zzYzR zzYbv() {
        return this.zzRg;
    }

    final void zzWII(zzYzR zzYzR2) {
        this.zzRg = zzYzR2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzYyt(boolean bl, zzZqj zzZqj2) {
        zzYzR zzYzR2;
        Section section = (Section)super.zzYyt(bl, zzZqj2);
        zzYzR zzYzR3 = this.zzRg;
        section.zzRg = zzYzR2 = (zzYzR)zzYzR3.zzPE();
        section.zzXFf = null;
        section.zzU4 = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzYyt(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzYcj(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzUt(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzUt(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzWPF(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzWCn(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzWPF(n) == null;
            }
        }
        return false;
    }

    final void zzWII(Shape shape, boolean bl) throws Exception {
        this.zzYyt(shape, 4, bl);
        this.zzYyt(shape, 0, bl);
        this.zzYyt(shape, 1, bl);
    }

    private void zzYyt(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzWZx());
        shape2.setName(zzYX0.zzYcj("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final void zzbo() {
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzZDc()) {
                if (!shape.zzYO7()) continue;
                shape.remove();
            }
        }
    }

    private void zzUt(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzYcj(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzRg.zzXzy(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzYlp().zzwH.zzWLg(key);
        }
        return zzYzR.zzX0U(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzRg.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzYlp().zzwH.zzY7U(key, value);
            return;
        }
        this.zzRg.zzY7U(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzRg.clear();
    }

    final boolean zzM() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zz7O() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        return super.toString();
    }

    static final class zzYyt
    implements zzWsD {
        private Section zzW4e;

        zzYyt(Section section) {
            this.zzW4e = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzYns().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzYns().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzYns().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzWsD zzYns() {
            Document document = zzYlQ.zzYyt((Object)this.zzW4e.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzW4e;
        }
    }
}

