/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Cell;
import com.aspose.words.Comment;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Field;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FrameFormat;
import com.aspose.words.HeaderFooter;
import com.aspose.words.Inline;
import com.aspose.words.List;
import com.aspose.words.ListFormat;
import com.aspose.words.ListLabel;
import com.aspose.words.ListLevel;
import com.aspose.words.Node;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.Run;
import com.aspose.words.RunCollection;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.TabStop;
import com.aspose.words.Table;
import com.aspose.words.TableStyle;
import com.aspose.words.WordAttrCollection;
import com.aspose.words.internal.zzYX0;
import com.aspose.words.internal.zzYlQ;
import com.aspose.words.ref.RefBoolean;
import com.aspose.words.ref.RefDouble;
import com.aspose.words.zzVPT;
import com.aspose.words.zzW0k;
import com.aspose.words.zzWBK;
import com.aspose.words.zzWrJ;
import com.aspose.words.zzWs4;
import com.aspose.words.zzX46;
import com.aspose.words.zzXI5;
import com.aspose.words.zzXRY;
import com.aspose.words.zzY6G;
import com.aspose.words.zzZ0l;
import com.aspose.words.zzZPZ;
import com.aspose.words.zzZqj;
import com.aspose.words.zzjc;
import com.aspose.words.zzvF;
import java.util.Iterator;

public class Paragraph
extends CompositeNode<Node>
implements zzWBK,
zzXI5,
zzvF {
    private zzjc zzYi5;
    private zzW0k zzXyc;
    private ParagraphFormat zzXx2;
    private FrameFormat zzX49;
    private ListFormat zzVZG;
    private ListLabel zzZVi;
    private RunCollection zzVSg;
    private int zzXA0;
    private int zz1H;

    public Paragraph(DocumentBase doc) {
        this(doc, new zzjc(), new zzW0k());
    }

    Paragraph(DocumentBase doc, zzjc paraPr, zzW0k runPr) {
        super(doc);
        this.zzYi5 = paraPr;
        this.zzXyc = runPr;
    }

    @Override
    public int getNodeType() {
        return 8;
    }

    public Story getParentStory() {
        return (Story)this.getAncestor(Story.class);
    }

    public Section getParentSection() {
        return (Section)this.getAncestor(2);
    }

    public boolean isInCell() {
        return this.zzYoU() instanceof Cell;
    }

    final boolean zzXdf() {
        CompositeNode compositeNode = this.getParentNode();
        if (compositeNode == null) {
            return false;
        }
        if (zzX46.zzVP7(compositeNode)) {
            if (this.isInCell()) {
                Paragraph paragraph = this;
                if (paragraph.zzWj7(paragraph.zzYoU().getFirstChild())) {
                    return true;
                }
            }
            return false;
        }
        return this.isInCell() && this == compositeNode.zzZcr();
    }

    public boolean isEndOfCell() {
        CompositeNode compositeNode = this.zzYoU();
        return compositeNode instanceof Cell && compositeNode.zzZ17() == this;
    }

    public boolean getBreakIsStyleSeparator() {
        return zzX46.zzUt(this.zzXyc, 130) && zzX46.zzUt(this.zzXyc, 10);
    }

    final boolean zz0D() {
        return this.isEndOfCell() && this.zzYIF().isLastCell();
    }

    final Cell zzYIF() {
        return zzYlQ.zzYyt((Object)this.zzYoU(), Cell.class);
    }

    final Row getParentRow() {
        if (this.zzYIF() != null) {
            return this.zzYIF().getParentRow();
        }
        return null;
    }

    final Table getParentTable() {
        if (this.getParentRow() != null) {
            return this.getParentRow().getParentTable();
        }
        return null;
    }

    public boolean isEndOfSection() {
        Story story = this.getParentStory();
        return story != null && story.getStoryType() == 1 && this == story.zzZ17();
    }

    public boolean isEndOfHeaderFooter() {
        Story story = this.getParentStory();
        return story instanceof HeaderFooter && story.zzZ17() == this;
    }

    public boolean isEndOfDocument() {
        if (!this.isEndOfSection()) {
            return false;
        }
        for (Node node = this.getDocument().getLastChild(); node != null; node = node.getPreviousSibling()) {
            if (!(node instanceof Section)) continue;
            return node == this.getParentSection();
        }
        return true;
    }

    final boolean zzZ7J() {
        if (this.zzW0V() != null) {
            return false;
        }
        if (this.getParentNode().getNodeType() != 3) {
            return false;
        }
        return !this.getParentSection().zzW2s();
    }

    public ParagraphFormat getParagraphFormat() {
        if (this.zzXx2 == null) {
            Paragraph paragraph = this;
            this.zzXx2 = new ParagraphFormat(paragraph, paragraph.getDocument().getStyles());
        }
        return this.zzXx2;
    }

    public ListFormat getListFormat() {
        if (this.zzVZG == null) {
            Paragraph paragraph = this;
            this.zzVZG = new ListFormat(paragraph, paragraph, this.getDocument().getLists());
        }
        return this.zzVZG;
    }

    public FrameFormat getFrameFormat() {
        if (this.zzX49 == null) {
            this.zzX49 = new FrameFormat(this);
        }
        return this.zzX49;
    }

    public ListLabel getListLabel() {
        if (this.zzZVi == null) {
            this.zzZVi = new ListLabel(this);
        }
        return this.zzZVi;
    }

    public RunCollection getRuns() {
        if (this.zzVSg == null) {
            this.zzVSg = new RunCollection(this);
        }
        return this.zzVSg;
    }

    public Font getParagraphBreakFont() {
        Paragraph paragraph = this;
        return new Font(paragraph, paragraph.getDocument());
    }

    public boolean isInsertRevision() {
        return this.zzXyc.zz0x();
    }

    public boolean isDeleteRevision() {
        return this.zzXyc.zzWQb();
    }

    public boolean isMoveFromRevision() {
        return this.zzXyc.zzjN();
    }

    public boolean isMoveToRevision() {
        return this.zzXyc.zzWbt();
    }

    public boolean isFormatRevision() {
        return this.zzYi5.zzE6();
    }

    final Style zzYIj() {
        return this.zzVUQ(0);
    }

    final Style zzVUQ(int n) {
        Object object = this.zzYi5.zzYPZ(1000, n);
        int n2 = object != null ? (Integer)object : 0;
        return this.getDocument().getStyles().zzWDB(n2, 0);
    }

    private Style zzY0z() {
        return this.getDocument().getStyles().zzWDB(this.zzXyc.zzzR(), 10);
    }

    final zzjc zzWXJ() {
        return this.zzYi5;
    }

    final void zzYyt(zzjc zzjc2) {
        this.zzYi5 = zzjc2;
    }

    final void zzXjl(Paragraph paragraph) {
        if (paragraph.getListLabel().zzXj1() != null && paragraph.getListLabel().zzWnC() != null) {
            this.getListLabel().zzYyt(paragraph.getListLabel().zzXj1(), paragraph.getListLabel().zzXnp(), paragraph.getListLabel().zzWnC().zzZ1Q(), 0);
        }
        if (paragraph.getListLabel().zzXup() != null && paragraph.getListLabel().zzYJO() != null) {
            this.getListLabel().zzYyt(paragraph.getListLabel().zzXup(), paragraph.getListLabel().zzGV(), paragraph.getListLabel().zzYJO().zzZ1Q(), 1);
        }
    }

    final void zzW6s(int n) {
        if (this.zzZVi != null) {
            this.zzZVi.zzYyt(null, null, null, n);
        }
    }

    final zzW0k zzYFL() {
        return this.zzXyc;
    }

    final void zzWLh(zzW0k zzW0k2) {
        this.zzXyc = zzW0k2;
    }

    @Override
    final Node zzYyt(boolean bl, zzZqj zzZqj2) {
        zzW0k zzW0k2;
        zzjc zzjc2;
        Paragraph paragraph = (Paragraph)super.zzYyt(bl, zzZqj2);
        WordAttrCollection wordAttrCollection = this.zzYi5;
        paragraph.zzYi5 = zzjc2 = (zzjc)wordAttrCollection.zzPE();
        wordAttrCollection = this.zzXyc;
        paragraph.zzXyc = zzW0k2 = (zzW0k)wordAttrCollection.zzPE();
        paragraph.zzXx2 = null;
        paragraph.zzX49 = null;
        paragraph.zzVZG = null;
        paragraph.zzZVi = null;
        paragraph.zzVSg = null;
        return paragraph;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzYyt(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitParagraphStart(this);
    }

    @Override
    final int zzYcj(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitParagraphEnd(this);
    }

    @Override
    public String getText() {
        return super.getText();
    }

    final zzjc zzXUA(int n) {
        zzjc zzjc2 = new zzjc();
        this.zzYcj(zzjc2, n);
        return zzjc2;
    }

    final void zzYcj(zzjc zzjc2, int n) {
        TableStyle tableStyle;
        Cloneable cloneable;
        Cloneable cloneable2;
        Cloneable cloneable3;
        boolean bl = (n & 0x40) != 0;
        boolean bl2 = (n & 1) != 0;
        boolean bl3 = (n & 0x80) == 0;
        n &= 0xFFFFFF7F;
        if (bl2) {
            this.getDocument().getStyles().zzZFB().zzYyt((zzZPZ)zzjc2, bl);
        }
        if ((n & 4) != 0 && (cloneable3 = this.zzYIF()) != null && (cloneable2 = ((Cell)(cloneable = cloneable3)).getParentRow().getParentTable()) != null && (tableStyle = zzYlQ.zzYyt((Object)((Table)cloneable2).getStyle(), TableStyle.class)) != null) {
            tableStyle.zzYyt((Cell)cloneable3, zzjc2);
        }
        cloneable3 = this.zzYi5.zzRI(n);
        if ((n & 0x10) != 0 && this.zzYi5.zzE6()) {
            zzjc2.zzYyt((zzWrJ)this.zzYi5.zzZh9().deepCloneComplexAttr());
        }
        cloneable2 = this.getDocument().getStyles().zzWDB(((zzjc)cloneable3).zzzR(), 0);
        int n2 = bl2 ? n & 0xFFFFFFFE : n;
        n2 = bl ? n2 & 0xFFFFFFBF : n2;
        ((Style)cloneable2).zzYcj(zzjc2, n2);
        if (zzjc2.getListId() != ((zzjc)cloneable3).getListId() || zzjc2.zzYYV() != ((zzjc)cloneable3).zzYYV()) {
            Cloneable cloneable4 = cloneable3;
            if (!((zzZPZ)cloneable3).zzq3(1110) && zzjc2.zzq3(1110)) {
                cloneable = cloneable3;
                cloneable4 = (zzjc)((zzZPZ)cloneable).zzPE();
                ((zzZPZ)cloneable4).zzY7U(1110, zzjc2.get(1110));
            }
            this.getDocument().getLists().zzYyt((zzjc)cloneable4, zzjc2);
        }
        if ((n & 8) != 0 && this.zzYi5.zzq3(1585)) {
            this.getDocument().zzZaK().zzYyt(this.zzYi5, zzjc2, this.getParentTable() == null);
        }
        if (bl3) {
            ((zzZPZ)cloneable3).zzYcj(zzjc2);
        }
        ((zzjc)cloneable3).zzXze(zzjc2);
        if (((zzjc)cloneable3).zzX81()) {
            if (!((zzZPZ)cloneable3).zzq3(1170)) {
                zzjc2.zzYci(0);
            }
            if (!((zzZPZ)cloneable3).zzq3(1160)) {
                zzjc2.zzzJ(0);
            }
            if (!((zzZPZ)cloneable3).zzq3(1165)) {
                if (bl) {
                    zzjc2.set(1165, 0);
                } else {
                    zzjc2.remove(1165);
                }
            }
            if (!((zzZPZ)cloneable3).zzq3(1175)) {
                if (bl) {
                    zzjc2.set(1175, 0);
                } else {
                    zzjc2.remove(1175);
                }
            }
        }
        if (((Node)(cloneable = this)).zzYoU() instanceof Shape) {
            zzjc2.zzWPp();
        }
        if ((n & 2) != 0) {
            zzjc2.zzXLF();
        }
    }

    final zzW0k zzZxh(int n) {
        zzW0k zzW0k2 = new zzW0k();
        int n2 = n;
        zzW0k zzW0k3 = zzW0k2;
        Paragraph paragraph = this;
        zzX46.zzYyt(paragraph, zzW0k3, n2);
        return zzW0k2;
    }

    final void zzXg4(zzjc zzjc2) {
        for (int i = 0; i < zzjc2.getCount(); ++i) {
            Object object;
            int n = zzjc2.zzY35(i);
            Object object2 = zzjc2.zzX4Y(i);
            if (object2.equals(object = this.fetchInheritedParaAttr(n))) {
                this.zzYi5.remove(n);
                continue;
            }
            this.zzYi5.zzY7U(n, object2);
        }
    }

    final boolean zzY2x() {
        CompositeNode compositeNode = this.zzYoU();
        return compositeNode instanceof Comment && this == compositeNode.zzZ17();
    }

    final boolean zzZLu() {
        CompositeNode compositeNode = this.zzYoU();
        return compositeNode instanceof Footnote && this == compositeNode.zzZ17();
    }

    final boolean zzZIA() {
        CompositeNode compositeNode = this.zzYoU();
        return compositeNode instanceof zzWs4 && this == compositeNode.zzZ17();
    }

    final boolean zzXkh() {
        CompositeNode compositeNode = this.zzYoU();
        return compositeNode instanceof Shape && compositeNode.zzZ17() == this;
    }

    final void zzYyt(RefDouble refDouble, RefDouble refDouble2, RefBoolean refBoolean) {
        refDouble.set(2.147483647E9);
        refDouble2.set(0.0);
        refBoolean.set(false);
        for (Node node = this.zzYty(); node != null; node = node.zzZ7U()) {
            if (!(node instanceof Inline)) continue;
            Paragraph.zzYyt((Inline)node, refDouble, refDouble2, refBoolean);
        }
        if (refDouble2.get() == 0.0) {
            Paragraph.zzYyt(this, refDouble, refDouble2, refBoolean);
        }
    }

    private static void zzYyt(zzWBK zzWBK2, RefDouble refDouble, RefDouble refDouble2, RefBoolean refBoolean) {
        Object object = zzWBK2.getDirectRunAttr(190);
        int n = (Integer)(object != null ? object : zzWBK2.fetchInheritedRunAttr(190));
        double d = (double)n / 2.0;
        refDouble.set(Math.min(d, refDouble.get()));
        refDouble2.set(Math.max(d, refDouble2.get()));
        if (!refBoolean.get()) {
            refBoolean.set(object != null);
            if (!refBoolean.get()) {
                Object object2 = zzWBK2.getDirectRunAttr(50);
                refBoolean.set(object2 != null && (Integer)object2 != 10);
            }
        }
    }

    @Override
    final String zzZZv() {
        if (this.isEndOfCell()) {
            return ControlChar.CELL;
        }
        if (this.isEndOfSection()) {
            return ControlChar.SECTION_BREAK;
        }
        return ControlChar.PARAGRAPH_BREAK;
    }

    @Override
    final boolean zzWCn(Node node) {
        Shape shape;
        Shape shape2 = zzYlQ.zzYyt((Object)node, Shape.class);
        if (shape2 != null && (shape2.zzY59() || shape2.getShapeType() == 20) && (shape = (Shape)this.getAncestor(18)) != null && shape.zzY59()) {
            return false;
        }
        return zzX46.zz2P(node);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key) {
        return this.zzYi5.zzXzy(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key, int revisionsView) {
        return this.zzYi5.zzYPZ(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedParaAttr(int key) {
        return this.zz3(key, 0);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchParaAttr(int key) {
        return this.zzW1C(key, 0);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setParaAttr(int key, Object value) {
        this.zzYi5.zzY7U(key, value);
        switch (key) {
            case 1155: 
            case 1165: 
            case 1175: 
            case 1205: 
            case 1225: {
                this.zzYgu();
            }
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeParaAttr(int key) {
        this.zzYi5.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearParaAttrs() {
        this.zzYi5.clear();
    }

    private Object zz3(int n, int n2) {
        Object object;
        Object object2;
        Paragraph paragraph = this;
        ListLevel listLevel = this.getDocument().getLists().zzYyt(paragraph.zzYi5, n2);
        if (listLevel != null) {
            object2 = listLevel.zzWXJ().zzXzy(n);
            if (object2 != null) {
                return object2;
            }
        } else {
            object = this.zzYi5.zzYPZ(1120, n2);
            if (object != null && (Integer)object == 0 && zzjc.zzWjk(n)) {
                return 0;
            }
        }
        if ((object2 = this.zzVUQ(n2).zzYZY(n, n2)) != null) {
            return object2;
        }
        if (this.zzXJt() && (object2 = ((TableStyle)(object = (TableStyle)this.getParentTable().getStyle())).zzWII(n, this.zzYIF())) != null) {
            return object2;
        }
        return this.getDocument().getStyles().zzZFB().zzWLg(n);
    }

    private boolean zzXJt() {
        Cell cell = this.zzYIF();
        if (cell == null) {
            return false;
        }
        Row row = cell.getParentRow();
        if (row == null) {
            return false;
        }
        Table table = row.getParentTable();
        if (table == null) {
            return false;
        }
        TableStyle tableStyle = zzYlQ.zzYyt((Object)this.getDocument().getStyles().zzZ1t(this.getParentTable().zzzR(), false), TableStyle.class);
        if (tableStyle == null) {
            return false;
        }
        return tableStyle.getStyleIdentifier() != 105;
    }

    final Object zzW1C(int n, int n2) {
        Object object = this.zzYi5.zzYPZ(n, n2);
        if (object != null) {
            return object;
        }
        return this.zz3(n, n2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int key) {
        return this.zzXyc.zzXzy(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int key) {
        Object object = this.zzY0z().zzWHV(key, false);
        if (object != null) {
            return object;
        }
        Paragraph paragraph = this;
        return paragraph.zzVUQ(0).zzWHV(key, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int key, Object value) {
        this.zzXyc.zzY7U(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzXyc.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzXyc.clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXRY getInsertRevision() {
        Paragraph paragraph = this;
        return paragraph.zzXyc.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzXRY value) {
        Cloneable cloneable = this;
        zzXRY zzXRY2 = value;
        cloneable = cloneable.zzXyc;
        ((zzZPZ)cloneable).zzY7U(14, zzXRY2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXRY getDeleteRevision() {
        Paragraph paragraph = this;
        return paragraph.zzXyc.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzXRY value) {
        Cloneable cloneable = this;
        zzXRY zzXRY2 = value;
        cloneable = cloneable.zzXyc;
        ((zzZPZ)cloneable).zzY7U(12, zzXRY2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzVPT getMoveFromRevision() {
        Paragraph paragraph = this;
        return paragraph.zzXyc.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzVPT value) {
        Cloneable cloneable = this;
        zzVPT zzVPT2 = value;
        cloneable = cloneable.zzXyc;
        ((zzZPZ)cloneable).zzY7U(13, zzVPT2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzVPT getMoveToRevision() {
        Paragraph paragraph = this;
        return paragraph.zzXyc.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzVPT value) {
        Cloneable cloneable = this;
        zzVPT zzVPT2 = value;
        cloneable = cloneable.zzXyc;
        ((zzZPZ)cloneable).zzY7U(15, zzVPT2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Paragraph paragraph = this;
        paragraph.zzXyc.remove(13);
        paragraph = this;
        paragraph.zzXyc.remove(15);
    }

    final boolean zzVWh() throws Exception {
        double d;
        CompositeNode compositeNode = this.zzCK();
        if (!(compositeNode instanceof Paragraph)) {
            return false;
        }
        Paragraph paragraph = (Paragraph)compositeNode;
        ParagraphFormat paragraphFormat = this.getParagraphFormat();
        ParagraphFormat paragraphFormat2 = paragraph.getParagraphFormat();
        if (paragraphFormat2.getPageBreakBefore()) {
            return false;
        }
        Paragraph paragraph2 = paragraph;
        Paragraph paragraph3 = paragraph2;
        paragraph3 = this;
        if (paragraph2.zzYi5.zzuS() != paragraph3.zzYi5.zzuS()) {
            return false;
        }
        double d2 = paragraphFormat.getLeftIndent() + Math.min(paragraphFormat.getFirstLineIndent(), 0.0);
        if (d2 != (d = paragraphFormat2.getLeftIndent() + Math.min(paragraphFormat2.getFirstLineIndent(), 0.0))) {
            return false;
        }
        if (paragraphFormat.getRightIndent() != paragraphFormat2.getRightIndent()) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(1).equals(paragraphFormat2.getBorders().getByBorderType(1))) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(2).equals(paragraphFormat2.getBorders().getByBorderType(2))) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(3).equals(paragraphFormat2.getBorders().getByBorderType(3))) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(0).equals(paragraphFormat2.getBorders().getByBorderType(0))) {
            return false;
        }
        return this.zzYVa(paragraph);
    }

    private boolean zzYVa(Paragraph paragraph) {
        Paragraph paragraph2 = paragraph;
        return this.zzYi5.zzY7U(paragraph2.zzYi5);
    }

    final Run zzWaQ() {
        return (Run)this.getChild(21, 0, false);
    }

    final Run zzZnZ(boolean bl) {
        Run run = null;
        for (Node node = this.zzYty(); node != null; node = node.zzZ7U()) {
            if (node.getNodeType() != 21 || bl && zzYX0.zzWUu(node.getText())) continue;
            run = (Run)node;
        }
        return run;
    }

    final boolean zzZ1K() {
        Story story = this.getParentStory();
        return story != null && story.getStoryType() == 1;
    }

    public boolean isListItem() {
        return this.zzWuV();
    }

    public TabStop[] getEffectiveTabStops() {
        zzjc zzjc2 = this.zzXUA(0);
        int n = zzjc2.zzq3(1140) ? zzjc2.getTabStops().getCount() : 0;
        TabStop[] tabStopArray = new TabStop[n];
        for (int i = 0; i < n; ++i) {
            tabStopArray[i] = zzjc2.getTabStops().get(i).zzZq0();
        }
        return tabStopArray;
    }

    public int joinRunsWithSameFormatting() {
        StringBuilder stringBuilder = new StringBuilder();
        Paragraph paragraph = this;
        return Paragraph.zzYyt(paragraph, stringBuilder);
    }

    final boolean zzYlV() {
        return this.zzWuV() && this.getListLabel().zzVXu();
    }

    final boolean zzZGO() {
        return this.zzXKt() && this.getListLabel().zzCJ();
    }

    final boolean hasRevisions() {
        block3: {
            block2: {
                Paragraph paragraph = this;
                if (paragraph.zzXyc.hasRevisions()) break block2;
                paragraph = this;
                if (paragraph.zzYi5.hasRevisions()) break block2;
                paragraph = this;
                if (!paragraph.zzYi5.zzYKT()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzYhc() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!zzX46.zzRZ(node)) continue;
            return true;
        }
        return false;
    }

    final boolean zzVPZ() {
        Iterator iterator = this.getChildNodes().iterator();
        while (iterator.hasNext()) {
            Node node;
            Node node2 = node = (Node)iterator.next();
            if (zzX46.zzWjy(node.getNodeType())) continue;
            return false;
        }
        return true;
    }

    final int zzWSx(StringBuilder stringBuilder) {
        return Paragraph.zzYyt(this, stringBuilder);
    }

    private static int zzYyt(CompositeNode compositeNode, StringBuilder stringBuilder) {
        if (stringBuilder != null) {
            stringBuilder.length();
        }
        int n = 0;
        Run run = null;
        zzW0k zzW0k2 = null;
        for (Node node = compositeNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node node2;
            if (node.getNodeType() == 21) {
                node2 = (Run)node;
                if (run != null) {
                    int n2 = 33;
                    Run run2 = node2;
                    zzW0k zzW0k3 = zzX46.zzYyt((zzZ0l)run2, n2);
                    if (zzW0k2 == null) {
                        n2 = 33;
                        run2 = run;
                        zzW0k2 = zzX46.zzYyt((zzZ0l)run2, n2);
                    }
                    if (zzW0k.zzaM(zzW0k3, zzW0k2)) {
                        if (stringBuilder.length() == 0) {
                            zzYlQ.zzYcj(stringBuilder, run.getText());
                        }
                        zzYlQ.zzYcj(stringBuilder, ((Run)node2).getText());
                        ++n;
                        compositeNode.removeChild(run);
                    } else {
                        Paragraph.zzYyt(run, stringBuilder);
                        zzW0k2 = null;
                    }
                }
                run = node2;
            } else {
                Paragraph.zzYyt(run, stringBuilder);
                run = null;
                zzW0k2 = null;
            }
            if (node.getNodeType() != 28) continue;
            node2 = (StructuredDocumentTag)node;
            Paragraph.zzYyt((CompositeNode)node2, stringBuilder);
        }
        Paragraph.zzYyt(run, stringBuilder);
        stringBuilder.length();
        return n;
    }

    private static void zzYyt(Run run, StringBuilder stringBuilder) {
        if (run != null && stringBuilder.length() != 0) {
            run.setText(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
    }

    public Field appendField(int fieldType, boolean updateField) throws Exception {
        return this.insertField(fieldType, updateField, null, true);
    }

    public Field appendField(String fieldCode) throws Exception {
        return this.insertField(fieldCode, null, true);
    }

    public Field appendField(String fieldCode, String fieldValue) {
        return this.insertField(fieldCode, fieldValue, null, true);
    }

    public Field insertField(int fieldType, boolean updateField, Node refNode, boolean isAfter) throws Exception {
        return zzX46.zzYyt(fieldType, updateField, this.zzWPG(refNode), null, (CompositeNode)this, refNode, isAfter);
    }

    public Field insertField(String fieldCode, Node refNode, boolean isAfter) throws Exception {
        return zzX46.zzYyt(fieldCode, this.zzWPG(refNode), null, (CompositeNode)this, refNode, isAfter);
    }

    public Field insertField(String fieldCode, String fieldValue, Node refNode, boolean isAfter) {
        return zzX46.zzYyt(fieldCode, fieldValue, this.zzWPG(refNode), null, (CompositeNode)this, refNode, isAfter);
    }

    final boolean zzWuV() {
        return (Integer)this.zzW1C(1120, 0) != 0;
    }

    final boolean zzXKt() {
        return (Integer)this.zzW1C(1120, 1) != 0;
    }

    final List zzYfs(boolean bl) {
        int n = bl ? 1 : 0;
        int n2 = (Integer)this.zzW1C(1120, n);
        if (n2 == 0) {
            return null;
        }
        List list = this.getDocument().getLists().zzYYn(n2);
        return list;
    }

    final ListLevel zzWB4(boolean bl) {
        int n = bl ? 1 : 0;
        int n2 = (Integer)this.zzW1C(1120, n);
        if (n2 == 0) {
            return null;
        }
        List list = this.getDocument().getLists().zzYYn(n2);
        int n3 = (Integer)this.zzW1C(1110, n);
        ListLevel listLevel = list.zzYX9(n3);
        return listLevel;
    }

    final int zzYyT() {
        return this.zzXA0;
    }

    final void zzDR(int n) {
        this.zzXA0 = n;
    }

    final int zzXfx() {
        return this.zz1H;
    }

    final void zzXig(int n) {
        this.zz1H = n;
    }

    private zzW0k zzWPG(Node node) {
        if (node == null) {
            if (this.getRuns().getCount() > 0) {
                return this.getRuns().get(this.getRuns().getCount() - 1).zzZi5();
            }
        } else if (node instanceof Run && node.getParentNode() == this) {
            return ((Run)node).zzZi5();
        }
        Paragraph paragraph = this;
        return paragraph.zzXyc;
    }

    private void zzYgu() {
        if (this.getDocument() == null || this.getParentSection() == null || this.getDocument().getNodeType() != 1) {
            return;
        }
        zzY6G zzY6G2 = new zzY6G();
        zzY6G2.visitDocumentStart((Document)this.getDocument());
        zzY6G2.visitSectionStart(this.getParentSection());
        zzY6G2.visitParagraphStart(this);
    }
}

