/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzYWX;
import com.aspose.words.internal.zzYlQ;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzWvC;
import com.aspose.words.zzX46;
import com.aspose.words.zzXjq;
import com.aspose.words.zzYgk;
import com.aspose.words.zzZqj;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzWcR;
    private Node zzYYg;
    private Node zzZu0;
    private int zzZI6;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzWII(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzWcR == null) {
            return null;
        }
        if (this.zzWcR.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzWcR;
    }

    final CompositeNode zzYoU() {
        if (zzX46.zzVP7(this.getParentNode())) {
            return this.getParentNode().zzYoU();
        }
        return this.getParentNode();
    }

    final CompositeNode zzfb() {
        if (zzX46.zzVP7(this.getParentNode()) || zzX46.zz8s(this.getParentNode())) {
            return this.getParentNode().zzfb();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzWcR != null) {
            return this.zzWcR.getDocument();
        }
        return null;
    }

    final Document zzmL() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zz6G() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzMA();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzZu0;
    }

    final Node zzX7H() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzX46.zzWjy((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzXss() {
        Node node = zzX46.zzSU(this.getPreviousSibling(), false);
        if (node == null && zzX46.zzVP7(this.getParentNode())) {
            node = this.getParentNode().zzXss();
        }
        return node;
    }

    final Node zzZ7U() {
        Node node = zzX46.zzWuI(this.getNextSibling(), false);
        if (node == null && zzX46.zzVP7(this.getParentNode())) {
            node = this.getParentNode().zzZ7U();
        }
        return node;
    }

    final CompositeNode zzST() {
        Node node = this;
        while ((node = node.zzXss()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzCK() {
        Node node = this;
        while ((node = node.zzZ7U()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzYYg;
    }

    final Node zzW0V() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzX46.zzWjy((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzW2s() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzWvl() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzXil() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzX46.zzVA(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzYjC() {
        return this.zzYYg;
    }

    final void zzZyw(Node node) {
        this.zzYYg = node;
    }

    final Node zzXB5() {
        return this.zzZu0;
    }

    final void zzZXK(Node node) {
        this.zzZu0 = node;
    }

    final Node zzZsV() {
        Node node = this;
        if (node.zzYYg != null) {
            node = this;
            return node.zzYYg;
        }
        return this.getParentNode();
    }

    final int zzYA5() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzX46.zz2P(this);
        boolean bl2 = zzX46.zzYpx(this);
        boolean bl3 = zzX46.zzWJ0(this);
        boolean bl4 = zzX46.zzZf7(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzYA5() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzYA5() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzYyt(isCloneChildren, new zzYyt(this));
    }

    Node zzYyt(boolean bl, zzZqj zzZqj2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzWcR != null) {
            node.zzWcR = this.getDocument().zzXSh();
        }
        node.zzYYg = null;
        node.zzZu0 = null;
        if (zzZqj2 != null) {
            zzZqj2.zzUt(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzVQ7(StringBuilder stringBuilder) {
        zzYlQ.zzYcj(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzYwQ(Node node) {
        this.zzWcR = node != null ? node : this.getDocument().zzXSh();
    }

    final void zzWII(DocumentBase documentBase) {
        this.zzWcR = documentBase != null ? documentBase.zzXSh() : null;
    }

    final boolean zzWj7(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzXJl() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zz38(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzZQA(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzZGH(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzXt4(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzXjq zzXjq2 = zzX46.zzWf9(saveFormat);
        return zzXjq2.zzYOA(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzXjq zzXjq2 = zzX46.zzYcj(saveOptions);
        return zzXjq2.zzYOA(this);
    }

    final Node zzXW3(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzX46.zzYb(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzYgk zzZrw() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzYgk.zzX0S(node);
        }
        return zzYgk.zzXF2(this.getParentNode());
    }

    final zzYgk zzdR() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzYgk.zzXF2(node);
        }
        return zzYgk.zzX0S(this.getParentNode());
    }

    final boolean zzY7T(Node node) {
        return Node.zzWSx(this, node);
    }

    final boolean zzYCg() {
        return this.getAncestor(1) == null;
    }

    static Node zzZjW(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzYWX<Node> zzYWX2 = Node.zzZ3K(node);
        zzYWX<Node> zzYWX3 = Node.zzZ3K(node2);
        return Node.zzYyt(zzYWX2, zzYWX3);
    }

    static boolean zzWSx(Node node, Node node2) {
        zzYWX<Node> zzYWX2;
        if (node == null || node2 == null) {
            return false;
        }
        zzYWX<Node> zzYWX3 = Node.zzZ3K(node);
        Node node3 = Node.zzYyt(zzYWX3, zzYWX2 = Node.zzZ3K(node2));
        if (node3 == null) {
            return false;
        }
        zzYWX<Node> zzYWX4 = zzYWX3;
        if (zzYWX4.size() == 0 || (zzYWX4 = zzYWX2).size() == 0) {
            zzYWX4 = zzYWX2;
            boolean bl = zzYWX4.size() > 0;
            return bl;
        }
        Object e = zzYWX3.peek();
        Object e2 = zzYWX2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes()) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzYWX<Node> zzZ3K(Node node) {
        zzYWX<Node> zzYWX2 = new zzYWX<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzYWX2.push(node2);
        }
        return zzYWX2;
    }

    private static Node zzYyt(zzYWX<Node> zzYWX2, zzYWX<Node> zzYWX3) {
        Node node = null;
        while (zzYWX2.peek() == zzYWX3.peek()) {
            node = (Node)zzYWX2.pop();
            zzYWX3.pop();
            zzYWX<Node> zzYWX4 = zzYWX2;
            if (zzYWX4.size() != 0 && (zzYWX4 = zzYWX3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzZI6;
    }

    public void setCustomNodeId(int value) {
        this.zzZI6 = value;
    }

    public String toString() {
        return super.toString();
    }

    public void dd() {
    }

    final Node zzVA(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzWkO(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzRZ(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zzWkO(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zzWkO(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zzYyt
    implements zzZqj {
        private Node zzVW4;
        private HashMap<Integer, Integer> zzVPd;

        zzYyt(Node node) {
            this.zzVW4 = node;
        }

        @Override
        public final void zzUt(Node node, Node node2) {
            if (node == this.zzVW4) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zzWvC zzWvC2 = (zzWvC)((Object)node2);
            if (this.zzVPd == null) {
                this.zzVPd = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zzYlQ.zzYyt(this.zzVPd, Integer.valueOf(zzWvC2.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzZSl();
                zzYlQ.zzYcj(this.zzVPd, Integer.valueOf(zzWvC2.getIdInternal()), Integer.valueOf(n));
            }
            zzWvC2.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zzYlQ.zzYyt(this.zzVPd, Integer.valueOf(zzWvC2.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zzWvC2.setParentIdInternal(n2);
            }
        }
    }
}

