/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zz0q;
import com.aspose.words.internal.zzLF;
import com.aspose.words.internal.zzWFc;
import com.aspose.words.internal.zzY0D;
import com.aspose.words.internal.zzYgi;
import com.aspose.words.internal.zzYlQ;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzYbK;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzVWl = new HashMap();
    private static HashMap<Integer, Integer> zzPc = new HashMap();
    private static HashMap<Integer, Integer> zzzF = new HashMap();
    private static HashMap<Integer, Integer> zzZ3Y = new HashMap();
    private static HashMap<Integer, Integer> zzZKa = new HashMap();
    private static HashMap<Integer, Integer> zzYgc = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzYlQ.zzYcj(fileName, "fileName");
        try (zzYgi zzYgi2 = zzYlQ.zzYUQ(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzZHB(zzYgi2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzZHB(zzLF.zzYyt(stream));
    }

    static FileFormatInfo zzZHB(zzWFc zzWFc2) throws Exception {
        if (zzWFc2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzYbK zzYbK2 = new zzYbK();
            zzWFc zzWFc3 = zzWFc2;
            zzYbK zzYbK3 = zzYbK2;
            return zzYbK2.zzYcj(zzWFc3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzWII(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzuI(zzY0D.zzWAe(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzYFz(zzY0D.zzWAe(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zz0q.zzWej(string = zzY0D.zzXQt(FileFormatUtil.zzWPR(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzuI(FileFormatUtil.zzYiF(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzYFz(FileFormatUtil.zzWPR(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzY0D.zzXQt(FileFormatUtil.zzYiF(saveFormat));
        if (zz0q.zzWej(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzYFz(zzY0D.zzWt1(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzY0D.zzXQt(FileFormatUtil.zzSZ(imageType));
    }

    static Exception zzWII(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzWvb(int n) {
        return zzY0D.toString(FileFormatUtil.zzYiF(n));
    }

    static int zzYFz(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzYlQ.zzYyt(zzZKa, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzY1k(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzYlQ.zzYyt(zzYgc, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzCh(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzWPR(int n) {
        return zzYlQ.zzYyt(zzVWl, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzYiF(int n) {
        return zzYlQ.zzYyt(zzPc, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzSZ(int n) {
        return zzYlQ.zzYyt(zzzF, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzuI(int n) {
        return zzYlQ.zzYyt(zzZ3Y, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzXze(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzYlQ.zzYcj(zzZKa, Integer.valueOf(n), Integer.valueOf(n2));
            zzYlQ.zzYcj(zzPc, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzZ3Y.containsKey(n)) {
                zzYlQ.zzYcj(zzZ3Y, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzYlQ.zzYcj(zzVWl, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzYlQ.zzYcj(zzYgc, Integer.valueOf(n), Integer.valueOf(n4));
            zzYlQ.zzYcj(zzzF, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzXze(11, 10, 10, 1);
        FileFormatUtil.zzXze(11, 0, 0, 1);
        FileFormatUtil.zzXze(12, 11, 11, 1);
        FileFormatUtil.zzXze(13, 20, 20, 1);
        FileFormatUtil.zzXze(13, 0, 254, 1);
        FileFormatUtil.zzXze(14, 21, 21, 1);
        FileFormatUtil.zzXze(15, 22, 22, 1);
        FileFormatUtil.zzXze(16, 23, 23, 1);
        FileFormatUtil.zzXze(18, 24, 24, 1);
        FileFormatUtil.zzXze(19, 25, 25, 1);
        FileFormatUtil.zzXze(20, 26, 26, 1);
        FileFormatUtil.zzXze(21, 27, 27, 1);
        FileFormatUtil.zzXze(24, 30, 30, 1);
        FileFormatUtil.zzXze(17, 31, 31, 1);
        FileFormatUtil.zzXze(25, 50, 50, 1);
        FileFormatUtil.zzXze(26, 45, 255, 1);
        FileFormatUtil.zzXze(27, 51, 51, 1);
        FileFormatUtil.zzXze(28, 0, 52, 1);
        FileFormatUtil.zzXze(29, 0, 53, 1);
        FileFormatUtil.zzXze(31, 0, 54, 1);
        FileFormatUtil.zzXze(22, 60, 60, 1);
        FileFormatUtil.zzXze(23, 61, 61, 1);
        FileFormatUtil.zzXze(34, 40, 64, 1);
        FileFormatUtil.zzXze(41, 47, 255, 1);
        FileFormatUtil.zzXze(42, 48, 255, 1);
        FileFormatUtil.zzXze(35, 41, 255, 1);
        FileFormatUtil.zzXze(36, 46, 255, 1);
        FileFormatUtil.zzXze(38, 42, 255, 1);
        FileFormatUtil.zzXze(37, 44, 255, 1);
        FileFormatUtil.zzXze(30, 52, 55, 1);
        FileFormatUtil.zzXze(32, 70, 62, 1);
        FileFormatUtil.zzXze(33, 73, 63, 1);
        FileFormatUtil.zzXze(39, 71, 255, 1);
        FileFormatUtil.zzXze(8, 100, 255, 1);
        FileFormatUtil.zzXze(9, 105, 255, 1);
        FileFormatUtil.zzXze(6, 101, 255, 6);
        FileFormatUtil.zzXze(7, 102, 255, 7);
        FileFormatUtil.zzXze(5, 104, 255, 5);
        FileFormatUtil.zzXze(4, 0, 255, 4);
        FileFormatUtil.zzXze(3, 0, 255, 3);
        FileFormatUtil.zzXze(40, 72, 255, 1);
        FileFormatUtil.zzXze(2, 103, 255, 2);
    }
}

